/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.AbstractIndexInfoOptimizer;

public class AggressiveOptimizer
extends AbstractIndexInfoOptimizer
implements CompassConfigurable {
    private long mergeFactor;

    public void configure(CompassSettings settings) throws CompassException {
        this.mergeFactor = settings.getSettingAsLong("compass.engine.optimizer.aggressive.mergeFactor", 10L);
    }

    public boolean canBeScheduled() {
        return true;
    }

    protected boolean isOptimizeOnlyIfIndexChanged() {
        return true;
    }

    protected boolean doNeedOptimizing(String subIndex, LuceneSubIndexInfo indexInfo) {
        if ((long)indexInfo.size() >= this.mergeFactor) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Need to optimize sub-index [" + subIndex + "]. Optimizing " + indexInfo.size() + " segments into one segment."));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptimize(String subIndex, LuceneSubIndexInfo indexInfo) throws SearchEngineException {
        block16: {
            if (!this.doNeedOptimizing(subIndex, indexInfo)) {
                return;
            }
            LuceneSearchEngineIndexManager indexManager = this.getSearchEngineFactory().getLuceneIndexManager();
            IndexWriter indexWriter = null;
            Directory dir = null;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Optimizing sub-index [" + subIndex + "]"));
                }
                long time = System.currentTimeMillis();
                dir = indexManager.getStore().openDirectory(subIndex);
                indexWriter = indexManager.openIndexWriter(indexManager.getSettings().getSettings(), dir, false);
                long lockTime = System.currentTimeMillis() - time;
                time = System.currentTimeMillis();
                indexWriter.optimize();
                long optimizeTime = System.currentTimeMillis() - time;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Optimization of sub-index [" + subIndex + "] took [" + (optimizeTime + lockTime) + "ms], Locking took [" + lockTime + "ms], and optimization took [" + optimizeTime + "ms]."));
                }
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("Lock obtain")) {
                    this.log.warn((Object)("Failed to obtain lock on sub-index [" + subIndex + "], will do it next time."));
                    break block16;
                }
                throw new SearchEngineException("Failed to optimize sub-index [" + subIndex + "]", e);
            }
            finally {
                try {
                    if (indexWriter != null) {
                        indexWriter.close();
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Failed to close index writer for sub index [" + subIndex + "]"), (Throwable)e);
                }
            }
        }
    }
}

