/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.compass.core.config.ConfigurationException;
import org.compass.core.util.config.AbstractConfigurationHelper;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.ConfigurationHelperUtil;

public class XmlConfigurationHelper
extends AbstractConfigurationHelper
implements ConfigurationHelper,
Serializable {
    private static final long serialVersionUID = 3546076943545219376L;
    protected static final ConfigurationHelper[] EMPTY_ARRAY = new ConfigurationHelper[0];
    private final String m_name;
    private final String m_location;
    private final String m_namespace;
    private final String m_prefix;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public XmlConfigurationHelper(ConfigurationHelper config) throws ConfigurationException {
        this(config.getName(), config.getLocation(), config.getNamespace(), config instanceof AbstractConfigurationHelper ? ((AbstractConfigurationHelper)config).getPrefix() : "");
        this.addAll(config);
    }

    public XmlConfigurationHelper(String name) {
        this(name, null, "", "");
    }

    public XmlConfigurationHelper(String name, String location) {
        this(name, location, "", "");
    }

    public XmlConfigurationHelper(String name, String location, String ns, String prefix) {
        this.m_name = name;
        this.m_location = location;
        this.m_namespace = ns;
        this.m_prefix = prefix;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNamespace() throws ConfigurationException {
        if (null != this.m_namespace) {
            return this.m_namespace;
        }
        throw new ConfigurationException("No namespace (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    protected String getPrefix() throws ConfigurationException {
        if (null != this.m_prefix) {
            return this.m_prefix;
        }
        throw new ConfigurationException("No prefix (not even default \"\") is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue(String defaultValue) {
        if (null != this.m_value) {
            return this.m_value;
        }
        return defaultValue;
    }

    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public ConfigurationHelper[] getChildren() {
        if (null == this.m_children) {
            return new ConfigurationHelper[0];
        }
        return this.m_children.toArray(new ConfigurationHelper[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (null != value) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\" at " + this.getLocation());
    }

    public ConfigurationHelper getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size = this.m_children.size();
            for (int i = 0; i < size; ++i) {
                ConfigurationHelper configuration = (ConfigurationHelper)this.m_children.get(i);
                if (!name.equals(configuration.getName())) continue;
                return configuration;
            }
        }
        if (createNew) {
            return new XmlConfigurationHelper(name, "<generated>" + this.getLocation(), this.m_namespace, this.m_prefix);
        }
        return null;
    }

    public ConfigurationHelper[] getChildren(String name) {
        if (null == this.m_children) {
            return new ConfigurationHelper[0];
        }
        ArrayList<ConfigurationHelper> children = new ArrayList<ConfigurationHelper>();
        int size = this.m_children.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationHelper configuration = (ConfigurationHelper)this.m_children.get(i);
            if (!name.equals(configuration.getName())) continue;
            children.add(configuration);
        }
        return children.toArray(new ConfigurationHelper[0]);
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.m_value = value;
    }

    public void setValue(int value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(long value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(boolean value) {
        this.setValue(String.valueOf(value));
    }

    public void setValue(float value) {
        this.setValue(String.valueOf(value));
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (null != value) {
            if (null == this.m_attributes) {
                this.m_attributes = new HashMap();
            }
            this.m_attributes.put(name, value);
        } else if (null != this.m_attributes) {
            this.m_attributes.remove(name);
        }
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, float value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void addChild(ConfigurationHelper configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void addAll(ConfigurationHelper other) {
        this.checkWriteable();
        this.setValue(other.getValue(null));
        this.addAllAttributes(other);
        this.addAllChildren(other);
    }

    public void addAllAttributes(ConfigurationHelper other) {
        this.checkWriteable();
        String[] attributes = other.getAttributeNames();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            String value = other.getAttribute(name, null);
            this.setAttribute(name, value);
        }
    }

    public void addAllChildren(ConfigurationHelper other) {
        this.checkWriteable();
        ConfigurationHelper[] children = other.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.addChild(children[i]);
        }
    }

    public void addAllChildrenBefore(ConfigurationHelper other) {
        this.checkWriteable();
        ConfigurationHelper[] children = other.getChildren();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        for (int i = children.length - 1; i >= 0; --i) {
            this.m_children.add(0, children[i]);
        }
    }

    public void removeChild(ConfigurationHelper configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        this.m_children.remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }

    protected final boolean isReadOnly() {
        return this.m_readOnly;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ConfigurationHelper)) {
            return false;
        }
        return ConfigurationHelperUtil.equals(this, (ConfigurationHelper)other);
    }

    public int hashCode() {
        int hash = this.m_prefix.hashCode();
        if (this.m_name != null) {
            hash ^= this.m_name.hashCode();
        }
        hash >>>= 7;
        if (this.m_location != null) {
            hash ^= this.m_location.hashCode();
        }
        hash >>>= 7;
        if (this.m_namespace != null) {
            hash ^= this.m_namespace.hashCode();
        }
        hash >>>= 7;
        if (this.m_attributes != null) {
            hash ^= this.m_attributes.hashCode();
        }
        hash >>>= 7;
        if (this.m_children != null) {
            hash ^= this.m_children.hashCode();
        }
        hash >>>= 7;
        if (this.m_value != null) {
            hash ^= this.m_value.hashCode();
        }
        hash >>>= 7;
        return hash ^= this.m_readOnly ? 1 : 3;
    }
}

