/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.lifecycle;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.mapping.CascadeMapping;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.lifecycle.HibernateMirrorFilter;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;

public class HibernateEventListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final HibernateGpsDevice device;
    protected final HibernateMirrorFilter mirrorFilter;
    protected final boolean marshallIds;

    public HibernateEventListener(HibernateGpsDevice device, boolean marshallIds) {
        this.device = device;
        this.mirrorFilter = device.getMirrorFilter();
        this.marshallIds = marshallIds;
    }

    public void onPostInsert(final PostInsertEvent postInsertEvent) {
        Object entity;
        if (!this.device.shouldMirrorDataChanges() || this.device.isPerformingIndexOperation()) {
            return;
        }
        CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
        if (!compassGps.hasMappingForEntityForMirror((entity = postInsertEvent.getEntity()).getClass(), CascadeMapping.Cascade.CREATE)) {
            return;
        }
        if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterInsert(postInsertEvent)) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.device.buildMessage("Creating [" + entity + "]"));
            }
            compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    if (HibernateEventListener.this.marshallIds) {
                        Serializable id = postInsertEvent.getId();
                        postInsertEvent.getPersister().setIdentifier(entity, id, postInsertEvent.getSession().getEntityMode());
                    }
                    session.create(entity);
                }
            });
        }
        catch (Exception e) {
            if (this.device.isIgnoreMirrorExceptions()) {
                this.log.error((Object)this.device.buildMessage("Failed while creating [" + entity + "]"), (Throwable)e);
            }
            throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while creating [" + entity + "]"), e);
        }
    }

    public void onPostUpdate(PostUpdateEvent postUpdateEvent) {
        Object entity;
        if (!this.device.shouldMirrorDataChanges() || this.device.isPerformingIndexOperation()) {
            return;
        }
        CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
        if (!compassGps.hasMappingForEntityForMirror((entity = postUpdateEvent.getEntity()).getClass(), CascadeMapping.Cascade.SAVE)) {
            return;
        }
        if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterUpdate(postUpdateEvent)) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.device.buildMessage("Updating [" + entity + "]"));
            }
            compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    session.save(entity);
                }
            });
        }
        catch (Exception e) {
            if (this.device.isIgnoreMirrorExceptions()) {
                this.log.error((Object)this.device.buildMessage("Failed while updating [" + entity + "]"), (Throwable)e);
            }
            throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while updating [" + entity + "]"), e);
        }
    }

    public void onPostDelete(PostDeleteEvent postDeleteEvent) {
        Object entity;
        if (!this.device.shouldMirrorDataChanges() || this.device.isPerformingIndexOperation()) {
            return;
        }
        CompassGpsInterfaceDevice compassGps = (CompassGpsInterfaceDevice)this.device.getGps();
        if (!compassGps.hasMappingForEntityForMirror((entity = postDeleteEvent.getEntity()).getClass(), CascadeMapping.Cascade.DELETE)) {
            return;
        }
        if (this.mirrorFilter != null && this.mirrorFilter.shouldFilterDelete(postDeleteEvent)) {
            return;
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.device.buildMessage("Deleting [" + entity + "]"));
            }
            compassGps.executeForMirror(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    session.delete(entity);
                }
            });
        }
        catch (Exception e) {
            if (this.device.isIgnoreMirrorExceptions()) {
                this.log.error((Object)this.device.buildMessage("Failed while deleting [" + entity + "]"), (Throwable)e);
            }
            throw new HibernateGpsDeviceException(this.device.buildMessage("Failed while deleting [" + entity + "]"), e);
        }
    }
}

