/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.util;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ogf.schemas.hpcp.x2007.x01.bp.BasicFilterDocument;
import org.ogf.schemas.hpcp.x2007.x01.bp.BasicFilterType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3.x2005.x08.addressing.ReferenceParametersType;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class ActivityUtils {
    public static Fault buildSOAP11Fault(QName faultCode, String faultString) {
        Fault soapFault = Fault.Factory.newInstance();
        soapFault.setFaultcode(faultCode);
        soapFault.setFaultstring(faultString);
        return soapFault;
    }

    public static XmlObject filterActivityAndResources() {
        BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
        BasicFilterType bfType = bfDoc.addNewBasicFilter();
        bfType.setActivityReferences(true);
        bfType.setContainedResources(true);
        return bfDoc;
    }

    public static XmlObject filterOnlyActivityBeans() {
        BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
        BasicFilterType bfType = bfDoc.addNewBasicFilter();
        bfType.setActivityReferences(true);
        bfType.setContainedResources(false);
        return bfDoc;
    }

    public static XmlObject filterOnlyResourceBeans() {
        BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
        BasicFilterType bfType = bfDoc.addNewBasicFilter();
        bfType.setActivityReferences(false);
        bfType.setContainedResources(true);
        return bfDoc;
    }

    public static XmlObject filterNoneBeans() {
        BasicFilterDocument bfDoc = BasicFilterDocument.Factory.newInstance();
        BasicFilterType bfType = bfDoc.addNewBasicFilter();
        bfType.setActivityReferences(false);
        bfType.setContainedResources(false);
        return bfDoc;
    }

    public static String extractRefParamResourceId(EndpointReferenceType eprt) {
        ReferenceParametersType refParam = eprt.getReferenceParameters();
        if (refParam == null) {
            return null;
        }
        XmlCursor cursor = refParam.newCursor();
        cursor.toFirstChild();
        String rid = cursor.getTextValue();
        cursor.dispose();
        return rid;
    }

    public static JobDefinitionDocument getJSDLFromFile(String filePath) throws Exception {
        JobDefinitionDocument jobDoc = null;
        jobDoc = JobDefinitionDocument.Factory.parse(new File(filePath));
        return jobDoc;
    }

    public static void deleteFile(File f) {
        if (!f.isDirectory()) {
            f.delete();
        } else {
            for (File child : f.listFiles()) {
                ActivityUtils.deleteFile(child);
            }
        }
    }

    public static String formatStatus(ActivityStatusType statusType) {
        StringBuffer sb = new StringBuffer();
        sb.append(statusType.getState().toString());
        XmlCursor acursor = statusType.newCursor();
        if (acursor.toFirstChild()) {
            do {
                if (!acursor.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) continue;
                sb.append(":");
                sb.append(acursor.getName().getLocalPart());
            } while (acursor.toNextSibling());
        }
        acursor.dispose();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean statusEquals(ActivityStatusType status1, ActivityStatusType status2) {
        boolean equals = false;
        if (!((Object)((Object)status1.getState())).equals((Object)status2.getState())) return false;
        ActivityStateEnumeration.Enum state = status1.getState();
        if (((Object)((Object)state)).equals((Object)ActivityStateEnumeration.FAILED)) return true;
        if (((Object)((Object)state)).equals((Object)ActivityStateEnumeration.FINISHED)) return true;
        if (((Object)((Object)state)).equals((Object)ActivityStateEnumeration.CANCELLED)) {
            return true;
        }
        XmlCursor cursor1 = status1.newCursor();
        XmlCursor cursor2 = status2.newCursor();
        String s1 = "";
        String s2 = "";
        try {
            if (cursor1.toFirstChild()) {
                do {
                    if (!cursor1.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) continue;
                    s1 = cursor1.getName().getLocalPart();
                } while (cursor1.toNextSibling());
            }
            if (cursor2.toFirstChild()) {
                do {
                    if (!cursor2.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) continue;
                    s2 = cursor2.getName().getLocalPart();
                } while (cursor2.toNextSibling());
            }
            if (!(s1.equals(s2) || s1.equals("") && !s2.equals(""))) {
                if (!s2.equals("")) return equals;
                if (s1.equals("")) return equals;
            }
            equals = true;
            return equals;
        }
        finally {
            if (cursor1 != null) {
                cursor1.dispose();
            }
            if (cursor2 != null) {
                cursor2.dispose();
            }
        }
    }
}

