/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.Task;
import de.fzj.unicore.uas.client.BaseUASClient;
import eu.unicore.unicore6.task.CancelRequestDocument;
import eu.unicore.unicore6.task.ResultDocument;
import eu.unicore.unicore6.task.SubmissionTimeDocument;
import eu.unicore.unicore6.task.TaskPropertiesDocument;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.stream.XMLStreamReader;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.StatusInfoType;
import org.unigrids.services.atomic.types.StatusType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TaskClient
extends BaseUASClient {
    private Calendar submissionTime;
    private Integer exitCode;

    public TaskClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(url, epr, sec);
    }

    public TaskClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public TaskPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TaskPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public XmlObject getResult() throws Exception {
        ResultDocument.Result result = this.getResourcePropertiesDocument().getTaskProperties().getResult();
        if (result == null) {
            return null;
        }
        return XmlObject.Factory.parse((XMLStreamReader)result.newXMLStreamReader());
    }

    public StatusType.Enum getStatus() throws Exception {
        return this.getStatusInfo().getStatus();
    }

    public Integer getExitCode() throws Exception {
        BigInteger eCode;
        StatusInfoType sit;
        if (this.exitCode == null && (sit = this.getStatusInfo()).isSetExitCode() && (eCode = sit.getExitCode()) != null) {
            this.exitCode = eCode.intValue();
        }
        return this.exitCode;
    }

    public Float getProgress() throws Exception {
        StatusInfoType status = this.getStatusInfo();
        if (status.isSetProgress()) {
            return Float.valueOf(status.getProgress());
        }
        return null;
    }

    public Calendar getSubmissionTime() throws Exception {
        if (this.submissionTime == null) {
            this.submissionTime = this.getSingleResourceProperty(SubmissionTimeDocument.class).getSubmissionTime();
        }
        return this.submissionTime;
    }

    public String getStatusMessage() throws Exception {
        return this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo().getDescription();
    }

    public void cancel() throws Exception {
        CancelRequestDocument c = CancelRequestDocument.Factory.newInstance();
        c.addNewCancelRequest();
        this.makeProxy(Task.class).Cancel(c);
    }

    public String waitUntilDone(int timeout) throws Exception {
        StatusType.Enum status = StatusType.UNDEFINED;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (((Object)((Object)status)).equals((Object)StatusType.SUCCESSFUL)) {
                logger.info("Task finished successfully.");
                break;
            }
            if (((Object)((Object)status)).equals((Object)StatusType.FAILED)) {
                String statusDescription = this.getStatusMessage();
                logger.info("Task failed." + (statusDescription != null ? " The error was: " + statusDescription : ""));
                break;
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }

    protected StatusInfoType getStatusInfo() throws Exception {
        return this.getResourcePropertiesDocument().getTaskProperties().getStatusInfo();
    }
}

