/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.ExtensionsType;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseType;
import xmlbeans.org.oasis.saml2.protocol.StatusType;

public class NameIDMappingResponse
extends AbstractStatusResponse<NameIDMappingResponseDocument, NameIDMappingResponseType> {
    public NameIDMappingResponse(NameIDType issuer, String inResponseTo, NameIDType mapped) {
        this(issuer, inResponseTo, mapped, NameIDMappingResponse.createOKStatus());
    }

    public NameIDMappingResponse(NameIDType issuer, String inResponseTo, SAMLServerException error) {
        this(issuer, inResponseTo, null, NameIDMappingResponse.createErrorStatus(error));
    }

    public NameIDMappingResponse(NameIDType issuer, String inResponseTo, NameIDType mapped, StatusType status) {
        NameIDMappingResponseDocument xbdoc = NameIDMappingResponseDocument.Factory.newInstance();
        this.init(xbdoc, xbdoc.addNewNameIDMappingResponse(), issuer, inResponseTo);
        if (mapped != null) {
            ((NameIDMappingResponseType)this.getXMLBean()).setNameID(mapped);
        } else {
            ((NameIDMappingResponseType)this.getXMLBean()).addNewNameID().setNil();
        }
        ((NameIDMappingResponseType)this.getXMLBean()).setStatus(status);
    }

    public void setExtensions(XmlObject val) {
        ExtensionsType exts = ((NameIDMappingResponseType)this.getXMLBean()).getExtensions();
        if (exts == null) {
            exts = ((NameIDMappingResponseType)this.getXMLBean()).addNewExtensions();
        }
        exts.set(val);
    }

    @Override
    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xmlDocuemnt = NameIDMappingResponseDocument.Factory.parse(doc);
            this.xmlResp = ((NameIDMappingResponseDocument)this.xmlDocuemnt).getNameIDMappingResponse();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
    }
}

