/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.user;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;

public class UserAssertion
extends Assertion {
    private static final long serialVersionUID = 7953888384523638747L;
    public static final String USER_ROLE = "USER";
    public static final String ROLE_NAME_FORMAT = "urn:unicore:subject-role";

    public UserAssertion(String consignorDN, String userDN) {
        this.constructorCommon(consignorDN, userDN);
    }

    public UserAssertion(String consignorDN, X509Certificate[] userCertChain) throws CertificateEncodingException {
        String userDN = userCertChain[0].getSubjectX500Principal().getName();
        this.constructorCommon(consignorDN, userDN);
        this.setSenderVouchesX509Confirmation(userCertChain);
    }

    private void constructorCommon(String consignorDN, String userDN) {
        SAMLAttribute attribute = new SAMLAttribute(USER_ROLE, ROLE_NAME_FORMAT);
        this.addAttribute(attribute);
        this.setX509Issuer(consignorDN);
        this.setX509Subject(userDN);
    }

    public UserAssertion(AssertionDocument doc) throws SAMLValidationException, XmlException, IOException {
        super(doc);
        AssertionType assertion = doc.getAssertion();
        SubjectType subject = assertion.getSubject();
        if (subject == null || subject.isNil() || subject.getNameID() == null || subject.getNameID().isNil() || subject.getNameID().getStringValue() == null) {
            throw new SAMLValidationException("No subject (user) in assertion.");
        }
        if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(subject.getNameID().getFormat())) {
            throw new SAMLValidationException("Subject (user) in User assertion must be of DN format");
        }
        boolean found = false;
        AttributeStatementType[] attrSs = assertion.getAttributeStatementArray();
        if (attrSs == null) {
            throw new SAMLValidationException("No attribute statement in SAML assertion");
        }
        for (int i = 0; i < attrSs.length; ++i) {
            AttributeType[] attrs = attrSs[i].getAttributeArray();
            for (int j = 0; j < attrs.length; ++j) {
                if (!attrs[j].getName().equals(USER_ROLE) || !attrs[j].getNameFormat().equals(ROLE_NAME_FORMAT)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            throw new SAMLValidationException("SAML assertion doesn't contain user role attirbute");
        }
    }

    public String getUserDN() {
        return this.getSubjectName();
    }

    public X509Certificate[] getUserCertificate() {
        return this.getSubjectFromConfirmation();
    }
}

