/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import eu.unicore.security.wsutil.client.authn.FilePermHelper;
import eu.unicore.security.wsutil.client.authn.SecuritySessionPersistence;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ClientSecuritySession;
import eu.unicore.util.httpclient.SessionIDProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonSecuritySessionPersistence
implements SecuritySessionPersistence {
    private static final Logger logger = Log.getLogger("unicore.security", JsonSecuritySessionPersistence.class);
    private boolean sessionsEnabled;
    private File sessionIDFile;

    public JsonSecuritySessionPersistence(boolean sessionsEnabled, String sessionsFile) {
        this.sessionsEnabled = sessionsEnabled;
        this.sessionIDFile = null;
        if (sessionsFile != null && sessionsEnabled) {
            this.sessionIDFile = new File(sessionsFile);
            FilePermHelper.set0600(this.sessionIDFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSessionIDs(SessionIDProvider sessionProvider) throws IOException {
        block7: {
            if (!this.sessionsEnabled || sessionProvider == null) {
                return;
            }
            Collection<ClientSecuritySession> sessions = sessionProvider.getAllSessions();
            JSONObject sessionsJson = new JSONObject();
            try {
                for (ClientSecuritySession entry : sessions) {
                    String serverID = entry.getScope();
                    JSONObject info = new JSONObject();
                    info.put("sessionID", (Object)entry.getSessionId());
                    info.put("hash", (Object)entry.getSessionHash());
                    info.put("expiry", entry.getExpiryTS());
                    sessionsJson.put(serverID, (Object)info);
                }
                if (sessions.size() <= 0 || this.sessionIDFile == null) break block7;
                FileWriter writer = new FileWriter(this.sessionIDFile);
                try {
                    sessionsJson.write((Writer)writer);
                }
                finally {
                    writer.close();
                }
                logger.debug("Stored <" + sessions.size() + "> security session ID(s) to <" + this.sessionIDFile.getAbsolutePath());
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void readSessionIDs(SessionIDProvider sessionProvider) throws IOException {
        if (!this.sessionsEnabled || sessionProvider == null) {
            return;
        }
        if (this.sessionIDFile != null && this.sessionIDFile.exists()) {
            try {
                JSONObject sessionsJSON = new JSONObject(FileUtils.readFileToString((File)this.sessionIDFile));
                Iterator serverIDs = sessionsJSON.keys();
                while (serverIDs.hasNext()) {
                    String serverID = (String)serverIDs.next();
                    JSONObject info = sessionsJSON.getJSONObject(serverID);
                    String hash = info.getString("hash");
                    String sessionID = info.getString("sessionID");
                    Long lifetime = info.optLong("expiry", -1L);
                    if (lifetime != null && lifetime < System.currentTimeMillis()) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Session for " + serverID + " expired");
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Re-adding session for " + serverID + " id " + sessionID);
                    }
                    ClientSecuritySession s = new ClientSecuritySession(sessionID, lifetime, hash, serverID);
                    sessionProvider.addSession(s);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            logger.debug("Loaded <" + sessionProvider.getAllSessions().size() + "> security session ID(s) from <" + this.sessionIDFile.getAbsolutePath());
        }
    }
}

