/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CompareAndRemoveBackupOperation
extends CollectionKeyBasedOperation
implements BackupOperation {
    Set<Long> idSet;

    public CompareAndRemoveBackupOperation() {
    }

    public CompareAndRemoveBackupOperation(CollectionProxyId proxyId, Data dataKey, Set<Long> idSet) {
        super(proxyId, dataKey);
        this.idSet = idSet;
    }

    @Override
    public void run() throws Exception {
        CollectionWrapper wrapper = this.getCollectionWrapper();
        if (wrapper == null) {
            this.response = false;
            return;
        }
        Iterator<CollectionRecord> iter = wrapper.getCollection().iterator();
        while (iter.hasNext()) {
            CollectionRecord record = iter.next();
            if (!this.idSet.contains(record.getRecordId())) continue;
            iter.remove();
        }
        this.response = true;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.idSet.size());
        for (Long id : this.idSet) {
            out.writeLong(id);
        }
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.idSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            this.idSet.add(in.readLong());
        }
    }

    @Override
    public int getId() {
        return 4;
    }
}

