/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.collection.operations.CompareAndRemoveBackupOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CompareAndRemoveOperation
extends CollectionBackupAwareOperation {
    List<Data> dataList;
    transient Set<Long> idSet;
    boolean retain;

    public CompareAndRemoveOperation() {
    }

    public CompareAndRemoveOperation(CollectionProxyId proxyId, Data dataKey, int threadId, List<Data> dataList, boolean retain) {
        super(proxyId, dataKey, threadId);
        this.dataList = dataList;
        this.retain = retain;
    }

    @Override
    public void run() throws Exception {
        CollectionWrapper wrapper = this.getCollectionWrapper();
        if (wrapper == null) {
            this.response = false;
            return;
        }
        this.idSet = new HashSet<Long>();
        List<Data> objList = this.dataList;
        if (!this.isBinary()) {
            objList = new ArrayList<Data>(this.dataList.size());
            for (Data data : this.dataList) {
                objList.add((Data)this.toObject(data));
            }
        }
        Iterator<CollectionRecord> iter = wrapper.getCollection().iterator();
        while (iter.hasNext()) {
            CollectionRecord record = iter.next();
            boolean contains = objList.contains(record.getObject());
            if ((!contains || this.retain) && (contains || !this.retain)) continue;
            this.idSet.add(record.getRecordId());
            iter.remove();
        }
        this.response = !this.idSet.isEmpty();
        if (wrapper.getCollection().isEmpty()) {
            this.removeCollection();
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new CompareAndRemoveBackupOperation(this.proxyId, this.dataKey, this.idSet);
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.retain);
        out.writeInt(this.dataList.size());
        for (Data data : this.dataList) {
            data.writeData(out);
        }
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.retain = in.readBoolean();
        int size = in.readInt();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = IOUtil.readData(in);
            this.dataList.add(data);
        }
    }

    @Override
    public int getId() {
        return 5;
    }
}

