/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PortableEntrySetResponse
implements Portable {
    Set<Map.Entry> entrySet = null;

    public PortableEntrySetResponse() {
    }

    public PortableEntrySetResponse(Set<Map.Entry> entrySet) {
        this.entrySet = entrySet;
    }

    public Set<Map.Entry> getEntrySet() {
        return this.entrySet;
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("s", this.entrySet.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Map.Entry entry : this.entrySet) {
            Data key = (Data)entry.getKey();
            Data value = (Data)entry.getValue();
            key.writeData(out);
            value.writeData(out);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.entrySet = new HashSet<Map.Entry>(size);
        for (int i = 0; i < size; ++i) {
            Data key = new Data();
            Data value = new Data();
            key.readData(in);
            value.readData(in);
            this.entrySet.add(new AbstractMap.SimpleEntry<Data, Data>(key, value));
        }
    }
}

