/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.concurrent.semaphore.SemaphorePortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;

public abstract class SemaphoreRequest
extends PartitionClientRequest
implements Portable {
    String name;
    int permitCount;

    protected SemaphoreRequest() {
    }

    protected SemaphoreRequest(String name, int permitCount) {
        this.name = name;
        this.permitCount = permitCount;
    }

    @Override
    protected int getPartition() {
        Data key = this.getClientEngine().getSerializationService().toData(this.name);
        return this.getClientEngine().getPartitionService().getPartitionId(key);
    }

    @Override
    protected int getReplicaIndex() {
        return 0;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:semaphoreService";
    }

    @Override
    public int getFactoryId() {
        return SemaphorePortableHook.F_ID;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("p", this.permitCount);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.permitCount = reader.readInt("p");
    }
}

