/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ClearBackupOperation
extends AbstractNamedOperation
implements BackupOperation,
DataSerializable {
    Set<Data> keys;
    MapService mapService;
    RecordStore recordStore;

    public ClearBackupOperation(String name, Set<Data> keys) {
        super(name);
        this.keys = keys;
    }

    public ClearBackupOperation() {
    }

    @Override
    public void beforeRun() throws Exception {
        this.mapService = (MapService)this.getService();
        this.recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
    }

    @Override
    public void run() {
        if (this.keys == null) {
            this.recordStore.removeAll();
            return;
        }
        for (Data key : this.keys) {
            if (this.recordStore.isLocked(key)) continue;
            this.recordStore.evict(key);
        }
    }

    public Set<Data> getKeys() {
        return this.keys;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (this.keys == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                key.writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        if (size > -1) {
            this.keys = new HashSet<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data data = new Data();
                data.readData(in);
                this.keys.add(data);
            }
        }
    }

    public String toString() {
        return "ClearBackupOperation{}";
    }
}

