/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;

final class FinalizeMigrationOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final MigrationEndpoint endpoint;
    private final boolean success;

    public FinalizeMigrationOperation(MigrationEndpoint endpoint, boolean success) {
        this.endpoint = endpoint;
        this.success = success;
    }

    @Override
    public void run() {
        PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
        MigrationInfo migrationInfo = partitionService.getActiveMigration(this.getPartitionId());
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        if (migrationInfo != null) {
            Collection<MigrationAwareService> services = nodeEngine.getServices(MigrationAwareService.class);
            PartitionMigrationEvent event = new PartitionMigrationEvent(this.endpoint, this.getPartitionId());
            for (MigrationAwareService service : services) {
                try {
                    if (this.success) {
                        service.commitMigration(event);
                        continue;
                    }
                    service.rollbackMigration(event);
                }
                catch (Throwable e) {
                    this.getLogger().warning("Error while finalizing migration -> " + event, e);
                }
            }
            partitionService.removeActiveMigration(this.getPartitionId());
            if (this.success) {
                nodeEngine.onPartitionMigrate(migrationInfo);
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

