/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.PartitionImpl;
import com.hazelcast.partition.PartitionView;
import com.hazelcast.partition.Partitions;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PartitionRuntimeState
implements DataSerializable {
    protected ArrayList<MemberInfo> members = new ArrayList(100);
    private Collection<ShortPartitionInfo> partitionInfos = new LinkedList<ShortPartitionInfo>();
    private long masterTime = Clock.currentTimeMillis();
    private int version;
    private Collection<MigrationInfo> completedMigrations;
    private transient Address endpoint;

    public PartitionRuntimeState() {
    }

    public PartitionRuntimeState(Collection<MemberInfo> memberInfos, Partitions partitions, Collection<MigrationInfo> migrationInfos, long masterTime, int version) {
        this.masterTime = masterTime;
        this.version = version;
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(memberInfos.size());
        int memberIndex = 0;
        for (MemberInfo memberInfo : memberInfos) {
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        this.setPartitions(partitions, addressIndexes);
        this.completedMigrations = migrationInfos != null ? migrationInfos : new ArrayList(0);
    }

    protected void addMemberInfo(MemberInfo memberInfo, Map<Address, Integer> addressIndexes, int memberIndex) {
        this.members.add(memberIndex, memberInfo);
        addressIndexes.put(memberInfo.getAddress(), memberIndex);
    }

    protected void setPartitions(Partitions partitions, Map<Address, Integer> addressIndexes) {
        for (PartitionView partition : partitions) {
            ShortPartitionInfo spi = new ShortPartitionInfo(partition.getPartitionId());
            for (int i = 0; i < 7; ++i) {
                Address address = partition.getReplicaAddress(i);
                if (address == null) {
                    spi.addressIndexes[i] = -1;
                    continue;
                }
                Integer knownIndex = addressIndexes.get(address);
                spi.addressIndexes[i] = knownIndex == null ? -1 : knownIndex;
            }
            this.partitionInfos.add(spi);
        }
    }

    public PartitionView[] getPartitions() {
        int size = this.partitionInfos.size();
        PartitionView[] partitions = new PartitionView[size];
        for (ShortPartitionInfo spi : this.partitionInfos) {
            PartitionImpl partition = new PartitionImpl(spi.partitionId, null);
            int[] addressIndexes = spi.addressIndexes;
            for (int c = 0; c < addressIndexes.length; ++c) {
                int index = addressIndexes[c];
                if (index == -1) continue;
                partition.setReplicaAddress(c, this.members.get(index).getAddress());
            }
            partitions[spi.partitionId] = partition;
        }
        return partitions;
    }

    public List<MemberInfo> getMembers() {
        return this.members;
    }

    public long getMasterTime() {
        return this.masterTime;
    }

    public Address getEndpoint() {
        return this.endpoint;
    }

    void setEndpoint(Address endpoint) {
        this.endpoint = endpoint;
    }

    public Collection<MigrationInfo> getCompletedMigrations() {
        return this.completedMigrations != null ? this.completedMigrations : Collections.emptyList();
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.masterTime = in.readLong();
        this.version = in.readInt();
        int size = in.readInt();
        HashMap<Address, Integer> addressIndexes = new HashMap<Address, Integer>(size);
        int memberIndex = 0;
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.addMemberInfo(memberInfo, addressIndexes, memberIndex);
            ++memberIndex;
        }
        int partitionCount = in.readInt();
        for (int i = 0; i < partitionCount; ++i) {
            ShortPartitionInfo spi = new ShortPartitionInfo();
            spi.readData(in);
            this.partitionInfos.add(spi);
        }
        int k = in.readInt();
        if (k > 0) {
            this.completedMigrations = new ArrayList<MigrationInfo>(k);
            for (int i = 0; i < k; ++i) {
                MigrationInfo cm = new MigrationInfo();
                cm.readData(in);
                this.completedMigrations.add(cm);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.masterTime);
        out.writeInt(this.version);
        int memberSize = this.members.size();
        out.writeInt(memberSize);
        for (MemberInfo memberInfo : this.members) {
            memberInfo.writeData(out);
        }
        out.writeInt(this.partitionInfos.size());
        for (ShortPartitionInfo spi : this.partitionInfos) {
            spi.writeData(out);
        }
        if (this.completedMigrations != null) {
            int k = this.completedMigrations.size();
            out.writeInt(k);
            for (MigrationInfo cm : this.completedMigrations) {
                cm.writeData(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionRuntimeState [" + this.version + "]{\n");
        for (MemberInfo address : this.members) {
            sb.append(address).append('\n');
        }
        sb.append(", completedMigrations=").append(this.completedMigrations);
        sb.append('}');
        return sb.toString();
    }

    public int getVersion() {
        return this.version;
    }

    private class ShortPartitionInfo
    implements DataSerializable {
        int partitionId;
        int[] addressIndexes = new int[7];

        ShortPartitionInfo(int partitionId) {
            this.partitionId = partitionId;
        }

        ShortPartitionInfo() {
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            for (int i = 0; i < 7; ++i) {
                out.writeInt(this.addressIndexes[i]);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.partitionId = in.readInt();
            for (int i = 0; i < 7; ++i) {
                this.addressIndexes[i] = in.readInt();
            }
        }
    }
}

