/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public final class DistributedObjectEventPacket
implements DataSerializable {
    private DistributedObjectEvent.EventType eventType;
    private String serviceName;
    private Object objectId;

    public DistributedObjectEventPacket() {
    }

    public DistributedObjectEventPacket(DistributedObjectEvent.EventType eventType, String serviceName, Object objectId) {
        this.eventType = eventType;
        this.serviceName = serviceName;
        this.objectId = objectId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public DistributedObjectEvent.EventType getEventType() {
        return this.eventType;
    }

    public Object getObjectId() {
        return this.objectId;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.eventType == DistributedObjectEvent.EventType.CREATED);
        out.writeUTF(this.serviceName);
        out.writeObject(this.objectId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventType = in.readBoolean() ? DistributedObjectEvent.EventType.CREATED : DistributedObjectEvent.EventType.DESTROYED;
        this.serviceName = in.readUTF();
        this.objectId = in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistributedObjectEvent");
        sb.append("{eventType=").append((Object)this.eventType);
        sb.append(", serviceName='").append(this.serviceName).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append('}');
        return sb.toString();
    }
}

