/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.ldap.ActiveDirectoryUserStoreConstants;
import org.wso2.carbon.user.core.ldap.LDAPConstants;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.JNDIUtil;

public class ActiveDirectoryUserStoreManager
extends ReadWriteLDAPUserStoreManager {
    private static Log logger = LogFactory.getLog(ActiveDirectoryUserStoreManager.class);
    private boolean isADLDSRole = false;
    private boolean isSSLConnection = false;
    private String userAccountControl = "512";

    public ActiveDirectoryUserStoreManager() {
    }

    public ActiveDirectoryUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId);
        this.checkRequiredUserStoreConfigurations();
    }

    public ActiveDirectoryUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
        this.checkRequiredUserStoreConfigurations();
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.addUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        boolean isUserBinded = false;
        this.doAddUserValidityChecks(userName, credential);
        DirContext dirContext = this.getSearchBaseDirectoryContext();
        BasicAttributes basicAttributes = this.getAddUserBasicAttributes(userName);
        if (!this.isADLDSRole) {
            BasicAttribute userAccountControl = new BasicAttribute("userAccountControl");
            userAccountControl.add(LDAPConstants.ACTIVE_DIRECTORY_DISABLED_NORMAL_ACCOUNT);
            basicAttributes.put(userAccountControl);
        }
        this.setUserClaims(claims, basicAttributes, userName);
        Name compoundName = null;
        try {
            NameParser ldapParser = dirContext.getNameParser("");
            compoundName = ldapParser.parse("cn=" + userName);
            dirContext.bind(compoundName, null, (Attributes)basicAttributes);
            isUserBinded = true;
            this.doUpdateRoleListOfUser(userName, null, roleList);
            if (!this.isSSLConnection) {
                logger.warn((Object)"Unsecured connection is being used. Enabling user account operation will fail");
            }
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword((String)credential))), this.isADLDSRole ? new ModificationItem(2, new BasicAttribute("msDS-UserAccountDisabled", "FALSE")) : new ModificationItem(2, new BasicAttribute("userAccountControl", this.userAccountControl))};
            dirContext.modifyAttributes(compoundName, mods);
        }
        catch (NamingException e) {
            String errorMessage = "Error while adding the user to the Active Directory";
            if (isUserBinded) {
                try {
                    dirContext.unbind(compoundName);
                }
                catch (NamingException e1) {
                    errorMessage = "Error while accessing the Active Directory";
                    throw new UserStoreException(errorMessage, e);
                }
                errorMessage = "Error while enabling the user account. Please check password policy at DC";
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    protected void setUserClaims(Map<String, String> claims, BasicAttributes basicAttributes, String userName) throws UserStoreException {
        if (claims != null) {
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                String claimURI;
                if ("".equals(entry.getValue()) || (claimURI = entry.getKey()).equals("profileConfiguration")) continue;
                String attributeName = null;
                try {
                    attributeName = this.getClaimAtrribute(claimURI, userName, null);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e);
                }
                BasicAttribute claim = new BasicAttribute(attributeName);
                claim.add(claims.get(entry.getKey()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AttributeName: " + attributeName + " AttributeValue: " + claims.get(entry.getKey())));
                }
                basicAttributes.put(claim);
            }
        }
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialsValidityChecks(userName, newCredential);
        DirContext dirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String searchFilter = "(&" + userListFilter + "(" + userNameAttribute + "=" + userName + "))";
        SearchControls searchControl = new SearchControls();
        String[] returningAttributes = new String[]{"CN"};
        searchControl.setReturningAttributes(returningAttributes);
        searchControl.setSearchScope(2);
        DirContext subDirContext = null;
        try {
            NamingEnumeration<SearchResult> searchResults = dirContext.search(searchBase, searchFilter, searchControl);
            SearchResult user = null;
            int count = 0;
            while (searchResults.hasMore()) {
                if (count > 0) {
                    throw new UserStoreException("There are more than one result in the user store for user: " + userName);
                }
                user = searchResults.next();
                ++count;
            }
            String userCNValue = null;
            if (user.getAttributes() != null) {
                Attribute cnAttribute = user.getAttributes().get("CN");
                if (cnAttribute != null) {
                    userCNValue = (String)cnAttribute.get();
                } else {
                    throw new UserStoreException("Can not update credential: CN attribute is null");
                }
            }
            ModificationItem[] mods = null;
            if (oldCredential != null && newCredential != null) {
                mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword((String)newCredential)))};
            }
            subDirContext = (DirContext)dirContext.lookup(searchBase);
            subDirContext.modifyAttributes("CN=" + userCNValue, mods);
        }
        catch (NamingException e) {
            try {
                String error = "Can not access the directory service";
                throw new UserStoreException(error, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        this.doUpdateCredentialsValidityChecks(userName, newCredential);
        DirContext dirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userListFilter = this.realmConfig.getUserStoreProperty("UserNameListFilter");
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String searchFilter = "(&" + userListFilter + "(" + userNameAttribute + "=" + userName + "))";
        SearchControls searchControl = new SearchControls();
        String[] returningAttributes = new String[]{"CN"};
        searchControl.setReturningAttributes(returningAttributes);
        searchControl.setSearchScope(2);
        DirContext subDirContext = null;
        try {
            NamingEnumeration<SearchResult> searchResults = dirContext.search(searchBase, searchFilter, searchControl);
            SearchResult user = null;
            int count = 0;
            while (searchResults.hasMore()) {
                if (count > 0) {
                    throw new UserStoreException("There are more than one result in the user store for user: " + userName);
                }
                user = searchResults.next();
                ++count;
            }
            String userCNValue = null;
            if (user.getAttributes() != null) {
                Attribute cnAttribute = user.getAttributes().get("CN");
                if (cnAttribute != null) {
                    userCNValue = (String)cnAttribute.get();
                } else {
                    throw new UserStoreException("Can not update credential: CN attribute is null");
                }
            }
            ModificationItem[] mods = null;
            if (newCredential != null) {
                mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword((String)newCredential)))};
                subDirContext = (DirContext)dirContext.lookup(searchBase);
                subDirContext.modifyAttributes("CN=" + userCNValue, mods);
            }
        }
        catch (NamingException e) {
            String error = "Can not access the directory service";
            throw new UserStoreException(error, e);
        }
        finally {
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    protected void doUpdateCredentialsValidityChecks(String userName, Object newCredential) throws UserStoreException {
        super.doUpdateCredentialsValidityChecks(userName, newCredential);
        if (!this.isSSLConnection) {
            logger.warn((Object)"Unsecured connection is being used. Password operations will fail");
        }
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        String connectionURL;
        String[] array;
        super.checkRequiredUserStoreConfigurations();
        String is_ADLDSRole = this.realmConfig.getUserStoreProperty("isADLDSRole");
        this.isADLDSRole = Boolean.parseBoolean(is_ADLDSRole);
        if (!this.isADLDSRole) {
            this.userAccountControl = this.realmConfig.getUserStoreProperty("userAccountControl");
            try {
                Integer.parseInt(this.userAccountControl);
            }
            catch (NumberFormatException e) {
                this.userAccountControl = "512";
            }
        }
        if ((array = (connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL")).split(":"))[0].equals("ldaps")) {
            this.isSSLConnection = true;
        } else {
            logger.warn((Object)"Connection to the Active Directory is not secure. Passowrd involved operations such as update credentials and adduser operations will fail");
        }
    }

    private byte[] createUnicodePassword(String password) {
        String newQuotedPassword = "\"" + password + "\"";
        byte[] encodedPwd = null;
        try {
            encodedPwd = newQuotedPassword.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error while encoding the given password", (Throwable)e);
        }
        return encodedPwd;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        String[] userNames = userName.split("/");
        if (userNames.length > 1) {
            userName = userNames[1];
        }
        userSearchFilter = userSearchFilter.replace("?", userName);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> returnedResultList = null;
        String returnedUserEntry = null;
        boolean cnModified = false;
        String cnValue = null;
        try {
            returnedResultList = dirContext.search(userSearchBase, userSearchFilter, searchControls);
            returnedUserEntry = returnedResultList.next().getName();
        }
        catch (NamingException e) {
            throw new UserStoreException("Results could not be retrieved from the directory context", e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(returnedResultList);
        }
        if (profileName == null) {
            profileName = "default";
        }
        if (claims.get("profileConfiguration") == null) {
            claims.put("profileConfiguration", "default");
        }
        try {
            BasicAttributes updatedAttributes = new BasicAttributes(true);
            String domainName = userName.indexOf("/") > -1 ? userName.split("/")[0] : this.realmConfig.getUserStoreProperty("DomainName");
            for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
                String claimURI = claimEntry.getKey();
                if (claimURI.equals("profileConfiguration")) continue;
                String attributeName = this.getClaimAtrribute(claimURI, userName, null);
                if ("CN".toLowerCase().equals(attributeName.toLowerCase())) {
                    cnModified = true;
                    cnValue = claimEntry.getValue();
                    continue;
                }
                BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                if ("".equals(claimEntry.getValue())) {
                    currentUpdatedAttribute.clear();
                } else if (claimEntry.getValue() != null && claimEntry.getValue().contains(",")) {
                    String[] values;
                    for (String newValue : values = claimEntry.getValue().split(",")) {
                        if (newValue == null || newValue.trim().length() <= 0) continue;
                        currentUpdatedAttribute.add(newValue.trim());
                    }
                } else {
                    currentUpdatedAttribute.add(claimEntry.getValue());
                }
                updatedAttributes.put(currentUpdatedAttribute);
            }
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
            if (cnModified && cnValue != null) {
                subDirContext.rename(returnedUserEntry, "CN=" + cnValue);
            }
        }
        catch (InvalidAttributeValueException e) {
            try {
                String errorMessage = "One or more attribute values provided are incompatible. Please check and try again.";
                throw new UserStoreException(errorMessage, e);
                catch (InvalidAttributeIdentifierException e2) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e2);
                }
                catch (NoSuchAttributeException e3) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e3);
                }
                catch (NamingException e4) {
                    errorMessage = "Profile information could not be updated in ApacheDS LDAP user store";
                    throw new UserStoreException(errorMessage, e4);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e5) {
                    errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e5);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String value, String profileName) throws UserStoreException {
        String attributeName;
        BasicAttributes updatedAttributes;
        String returnedUserEntry;
        String userSearchBase;
        DirContext subDirContext;
        DirContext dirContext;
        block20: {
            dirContext = this.connectionSource.getContext();
            subDirContext = null;
            userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            userSearchFilter = userSearchFilter.replace("?", userName);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(null);
            NamingEnumeration<SearchResult> returnedResultList = null;
            returnedUserEntry = null;
            try {
                returnedResultList = dirContext.search(userSearchBase, userSearchFilter, searchControls);
                returnedUserEntry = returnedResultList.next().getName();
            }
            catch (NamingException e) {
                throw new UserStoreException("Results could not be retrieved from the directory context", e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(returnedResultList);
            }
            updatedAttributes = new BasicAttributes(true);
            attributeName = this.getClaimAtrribute(claimURI, userName, null);
            if (!"CN".equals(attributeName)) break block20;
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.rename(returnedUserEntry, "CN=" + value);
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
            return;
        }
        try {
            BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
            if ("".equals(value)) {
                currentUpdatedAttribute.clear();
            } else if (value.contains(",")) {
                String[] values;
                for (String newValue : values = value.split(",")) {
                    if (newValue == null || newValue.trim().length() <= 0) continue;
                    currentUpdatedAttribute.add(newValue.trim());
                }
            } else {
                currentUpdatedAttribute.add(value);
            }
            updatedAttributes.put(currentUpdatedAttribute);
            subDirContext = (DirContext)dirContext.lookup(userSearchBase);
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
        }
        catch (InvalidAttributeValueException e) {
            try {
                String errorMessage = "One or more attribute values provided are incompatible. Please check and try again.";
                throw new UserStoreException(errorMessage, e);
                catch (InvalidAttributeIdentifierException e2) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e2);
                }
                catch (NoSuchAttributeException e3) {
                    errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP.";
                    throw new UserStoreException(errorMessage, e3);
                }
                catch (NamingException e4) {
                    errorMessage = "Profile information could not be updated in ApacheDS LDAP user store";
                    throw new UserStoreException(errorMessage, e4);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e5) {
                    errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e5);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
        return;
    }

    @Override
    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties(ActiveDirectoryUserStoreConstants.ACTIVE_DIRECTORY_UM_PROPERTIES.toArray(new Property[ActiveDirectoryUserStoreConstants.ACTIVE_DIRECTORY_UM_PROPERTIES.size()]));
        properties.setOptionalProperties(ActiveDirectoryUserStoreConstants.OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.toArray(new Property[ActiveDirectoryUserStoreConstants.OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.size()]));
        return properties;
    }
}

