/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator.v2;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Number;
import com.ibm.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xtq.xslt.translator.v2.XPath2Translator;
import com.ibm.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ExpandedTypeIDInstruction;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.builders.DynamicVariableBuilder;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.NamedType;

public class Number2Translator {
    final LetChainBuilder lcb;
    final DynamicVariableBuilder dvb;
    final XSLT2Translator xslt2Translator;
    private static final NamedType s_xdtType = new NamedType("XPath20Datum");

    public Number2Translator(LetChainBuilder letChainBuilder, DynamicVariableBuilder dynamicVariableBuilder, XSLT2Translator xSLT2Translator) {
        this.lcb = letChainBuilder;
        this.dvb = dynamicVariableBuilder;
        this.xslt2Translator = xSLT2Translator;
    }

    public Instruction compileNumber(Number number) {
        Instruction instruction = null;
        Instruction instruction2 = this.makeStringInstruction(number.getFormat(), "1");
        Instruction instruction3 = this.makeStringInstruction(number.getLang(), "en");
        Instruction instruction4 = this.makeStringInstruction(number.getLetterValue(), "alphabetic");
        Instruction instruction5 = this.makeStringInstruction(number.getOrdinal(), "no");
        Instruction instruction6 = this.makeStringInstruction(number.getGroupingSeparator(), "");
        Instruction instruction7 = this.makeStringInstruction(number.getGroupingSize(), "0");
        if (number.hasValue()) {
            Expr expr = number.getValueExpr();
            Instruction instruction8 = this.xslt2Translator.compileNode(this.dvb, this.lcb, expr);
            instruction = TranslatorUtilities.makeRuntimeLibraryFunctionCall(this.lcb, "xsl-number-value", new Instruction[]{instruction8, instruction2, instruction7, instruction6, instruction4, instruction3, instruction5});
        } else {
            Instruction instruction9 = this.makeStartNodeInstruction(number);
            if (number.getFrom() == null && number.getCount() == null) {
                if (number.getLevel() == 0) {
                    instruction = TranslatorUtilities.makeRuntimeLibraryFunctionCall(this.lcb, "xsl-number-default-single", new Instruction[]{instruction9, instruction2, instruction7, instruction6, instruction4, instruction3, instruction5});
                } else if (number.getLevel() == 2) {
                    instruction = TranslatorUtilities.makeRuntimeLibraryFunctionCall(this.lcb, "xsl-number-default-any", new Instruction[]{instruction9, instruction2, instruction7, instruction6, instruction4, instruction3, instruction5});
                }
            }
            if (instruction == null) {
                String string;
                int n = number.getLevel();
                switch (n) {
                    case 2: {
                        string = "xsl-number-any";
                        break;
                    }
                    case 1: {
                        string = "xsl-number-multiple";
                        break;
                    }
                    default: {
                        string = "xsl-number-single";
                    }
                }
                Expr expr = number.getCount();
                Instruction instruction10 = this.makeCountLambda(expr);
                Expr expr2 = number.getFrom();
                Instruction instruction11 = this.makeFromLambda(expr2);
                instruction = TranslatorUtilities.makeRuntimeLibraryFunctionCall(this.lcb, string, new Instruction[]{instruction9, instruction10, instruction11, instruction2, instruction7, instruction6, instruction4, instruction3, instruction5});
            }
        }
        return instruction;
    }

    private Instruction makeFromLambda(Expr expr) {
        Integer n = ReductionHelper.generateIntermediateIdentifier2();
        Object object = this.dvb.bind("__current__", n);
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        LambdaInstruction lambdaInstruction = expr != null ? new LambdaInstruction(letChainBuilder.packageUp(letChainBuilder.bind(this.xslt2Translator.compileNode(this.dvb, letChainBuilder, expr))), new Binding[]{new Binding((Object)n, s_xdtType)}, true) : new LambdaInstruction(letChainBuilder.packageUp(LiteralInstruction.booleanFalseLiteral()), new Binding[]{new Binding((Object)n, s_xdtType)}, true);
        this.dvb.bind("__current__", object);
        Instruction instruction = this.lcb.bind(lambdaInstruction);
        return instruction;
    }

    private Instruction makeCountLambda(Expr expr) {
        Instruction instruction;
        LambdaInstruction lambdaInstruction;
        Integer n = ReductionHelper.generateIntermediateIdentifier2();
        Object object = this.dvb.bind("__current__", n);
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        if (expr != null) {
            lambdaInstruction = new LambdaInstruction(letChainBuilder.packageUp(letChainBuilder.bind(this.xslt2Translator.compileNode(this.dvb, letChainBuilder, expr))), new Binding[]{new Binding((Object)n, s_xdtType)}, true);
        } else {
            instruction = new ExpandedTypeIDInstruction(XPath2Translator.makeStreamToCursorCall(letChainBuilder, letChainBuilder.bind(new StreamInstruction((Type)s_xdtType, new IdentifierInstruction(object)))));
            ExpandedTypeIDInstruction expandedTypeIDInstruction = new ExpandedTypeIDInstruction(XPath2Translator.makeStreamToCursorCall(letChainBuilder, letChainBuilder.bind(new StreamInstruction((Type)s_xdtType, new IdentifierInstruction(n)))));
            lambdaInstruction = new LambdaInstruction(letChainBuilder.packageUp(new EqualityInstruction(letChainBuilder.bind(instruction), letChainBuilder.bind(expandedTypeIDInstruction), false)), new Binding[]{new Binding((Object)n, s_xdtType)}, true);
        }
        this.dvb.bind("__current__", object);
        instruction = this.lcb.bind(lambdaInstruction);
        return instruction;
    }

    private Instruction makeStartNodeInstruction(Number number) {
        Instruction instruction;
        if (number.hasSelect()) {
            Expr expr = number.getSelect();
            Instruction instruction2 = this.xslt2Translator.compileNode(this.dvb, this.lcb, expr);
            Instruction[] instructionArray = new Instruction[]{instruction2};
            instruction = TranslatorUtilities.makeRuntimeLibraryFunctionCall(this.lcb, "extract-singleton", instructionArray);
        } else {
            instruction = new IdentifierInstruction(this.dvb.lookup("__current__"));
        }
        return instruction;
    }

    private Instruction makeStringInstruction(Expr expr, String string) {
        Instruction instruction = expr == null ? this.lcb.bind(StreamInstruction.charStreamLiteral(string)) : this.xslt2Translator.AVT2String(this.dvb, this.lcb, expr);
        return instruction;
    }
}

