/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xtq.xslt.runtime.Operators;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.interpreter.CursorStream;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.INumericalType;
import com.ibm.xylem.types.IntType;
import java.io.IOException;
import java.util.LinkedList;

public class ComparisonInstruction
extends BinaryPrimopInstruction {
    protected int m_operation;

    public ComparisonInstruction() {
    }

    public int getOperation() {
        return this.m_operation;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_operation = readObjectFileHelper.readInt();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_operation);
    }

    @Override
    public com.ibm.xylem.Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(BooleanType.s_booleanType);
    }

    @Override
    public com.ibm.xylem.Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return BooleanType.s_booleanType;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new ComparisonInstruction(this.m_operation, this.m_operand1.cloneWithoutTypeInformation(), this.m_operand2.cloneWithoutTypeInformation());
    }

    public ComparisonInstruction(int n, Instruction instruction, Instruction instruction2) {
        super(instruction, instruction2);
        this.m_operation = n;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        int n;
        int n2;
        int n3;
        com.ibm.xylem.Type type = codeGenerationTracker.resolveType(this.m_operand1);
        com.ibm.xylem.Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        switch (this.m_operation) {
            case 18: {
                String string2 = ">=";
                n3 = 4;
                n2 = 5;
                n = 6;
                break;
            }
            case 16: {
                String string3 = "<=";
                n2 = 4;
                n3 = 5;
                n = 8;
                break;
            }
            case 17: {
                String string4 = ">";
                n2 = 3;
                n3 = 2;
                n = 5;
                break;
            }
            case 15: {
                String string5 = "<";
                n2 = 2;
                n3 = 3;
                n = 7;
                break;
            }
            default: {
                throw new StaticError("ERR_SYSTEM", "ComparisonInstruction has bad operation: (" + this.m_operation + ")");
            }
        }
        if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            CursorType.generateWithCloneIfNeeded(this.m_operand1, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CharStreamToJavaStringInstruction.generateJavaString(bCELCodeGenerationHelper, codeGenerationTracker, this.m_operand2, instructionListBuilder);
            instructionListBuilder.appendConstant(n3);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.STRING, BasicType.INT});
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CharType.s_charType.getStreamType())) {
            CursorType.generateWithCloneIfNeeded(this.m_operand2, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CharStreamToJavaStringInstruction.generateJavaString(bCELCodeGenerationHelper, codeGenerationTracker, this.m_operand1, instructionListBuilder);
            instructionListBuilder.appendConstant(n2);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.STRING, BasicType.INT});
        } else if (type.equals(CursorType.s_cursorType) && type2 instanceof INumericalType) {
            CursorType.generateWithCloneIfNeeded(this.m_operand1, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            instructionListBuilder.appendConstant(n3);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.DOUBLE, BasicType.INT});
        } else if (type2.equals(CursorType.s_cursorType) && type instanceof INumericalType) {
            CursorType.generateWithCloneIfNeeded(this.m_operand2, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            instructionListBuilder.appendConstant(n2);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, BasicType.DOUBLE, BasicType.INT});
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CursorType.s_cursorType)) {
            CursorType.generateWithCloneIfNeeded(this.m_operand1, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            CursorType.generateWithCloneIfNeeded(this.m_operand2, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            instructionListBuilder.appendConstant(n3);
            instructionListBuilder.appendInvokeStatic(BasisLibrary.class.getName(), "compare", (Type)BasicType.BOOLEAN, new Type[]{CursorType.s_bcelType, CursorType.s_bcelType, BasicType.INT});
        } else if (type instanceof INumericalType || type2 instanceof INumericalType) {
            if (type.equals(type2)) {
                codeGenerationTracker.generateConventionally(this.m_operand1, bCELCodeGenerationHelper, null, instructionListBuilder);
                codeGenerationTracker.generateConventionally(this.m_operand2, bCELCodeGenerationHelper, null, instructionListBuilder);
                ((INumericalType)((Object)type)).generateCodeForOperation(instructionListBuilder, n);
            } else {
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
                DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, n);
            }
        } else if (type.equals(CharType.s_charType.getStreamType()) && type2.equals(CharType.s_charType.getStreamType())) {
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, n);
        } else if (type.equals(BooleanType.s_booleanType) || type2.equals(BooleanType.s_booleanType)) {
            if (type.equals(type2)) {
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, IntType.s_intType, codeGenerationTracker, instructionListBuilder);
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, IntType.s_intType, codeGenerationTracker, instructionListBuilder);
                IntType.s_intType.generateCodeForOperation(instructionListBuilder, n);
            } else {
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, BooleanType.s_booleanType, codeGenerationTracker, instructionListBuilder);
                CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, BooleanType.s_booleanType, codeGenerationTracker, instructionListBuilder);
                IntType.s_intType.generateCodeForOperation(instructionListBuilder, n);
            }
        } else {
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            CoerceInstruction.generateCoersion(bCELCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker, instructionListBuilder);
            DoubleType.s_doubleType.generateCodeForOperation(instructionListBuilder, n);
        }
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        int n;
        int n2;
        String string2;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        com.ibm.xylem.Type type = codeGenerationTracker.resolveType(this.m_operand1);
        com.ibm.xylem.Type type2 = codeGenerationTracker.resolveType(this.m_operand2);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        switch (this.m_operation) {
            case 18: {
                string2 = ">=";
                n2 = 4;
                n = 5;
                break;
            }
            case 16: {
                string2 = "<=";
                n = 4;
                n2 = 5;
                break;
            }
            case 17: {
                string2 = ">";
                n = 3;
                n2 = 2;
                break;
            }
            case 15: {
                string2 = "<";
                n = 2;
                n2 = 3;
                break;
            }
            default: {
                throw new StaticError("ERR_SYSTEM", "ComparisonInstruction has bad operation: (" + this.m_operation + ")");
            }
        }
        if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            String string4 = CursorType.generateStartOneTimeUse(this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
            String string5 = CharStreamToJavaStringInstruction.generateJavaString(dataFlowCodeGenerationHelper, codeGenerationTracker, this.m_operand2, null);
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string4 + ", " + string5 + ", " + n2 + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string4, this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CharType.s_charType.getStreamType())) {
            String string6 = CharStreamToJavaStringInstruction.generateJavaString(dataFlowCodeGenerationHelper, codeGenerationTracker, this.m_operand1, null);
            String string7 = CursorType.generateStartOneTimeUse(this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string7 + ", " + string6 + ", " + n + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string7, this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type.equals(CursorType.s_cursorType) && type2 instanceof INumericalType) {
            String string8 = CursorType.generateStartOneTimeUse(this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
            String string9 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string8 + ", (double) " + string9 + ", " + n2 + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string8, this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type2.equals(CursorType.s_cursorType) && type instanceof INumericalType) {
            String string10 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
            String string11 = CursorType.generateStartOneTimeUse(this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string11 + ", (double) " + string10 + ", " + n + ")", codeGenerationTracker);
            CursorType.generateEndOneTimeUse(string11, this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CursorType.s_cursorType)) {
            String string12 = CursorType.generateWithCloneIfNeeded(this.m_operand1, dataFlowCodeGenerationHelper, codeGenerationTracker);
            String string13 = CursorType.generateWithCloneIfNeeded(this.m_operand2, dataFlowCodeGenerationHelper, codeGenerationTracker);
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), BasisLibrary.class.getName() + ".compare(" + string12 + ", " + string13 + ", " + n2 + ")", codeGenerationTracker);
        } else {
            String string14;
            String string15;
            if (type.equals(CursorType.s_cursorType)) {
                string15 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
                String string16 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                dataFlowCodeGenerationHelper.appendAssignment(string16, BooleanType.s_booleanType, "!(" + string15 + ").isEmpty()", codeGenerationTracker);
                String string17 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                dataFlowCodeGenerationHelper.appendAssignment(string17, DoubleType.s_doubleType, string16 + " ? 1 : 0", codeGenerationTracker);
                string15 = string17;
                string14 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker);
            } else if (type2.equals(CursorType.s_cursorType)) {
                string14 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
                String string18 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                dataFlowCodeGenerationHelper.appendAssignment(string18, BooleanType.s_booleanType, "!(" + string14 + ").isEmpty()", codeGenerationTracker);
                String string19 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                dataFlowCodeGenerationHelper.appendAssignment(string19, DoubleType.s_doubleType, string18 + " ? 1 : 0", codeGenerationTracker);
                string14 = string19;
                string15 = CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker);
            } else {
                string15 = !(type instanceof INumericalType) ? CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand1, DoubleType.s_doubleType, codeGenerationTracker) : codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
                string14 = !(type2 instanceof INumericalType) ? CoerceInstruction.generateCoersion(dataFlowCodeGenerationHelper, this.m_operand2, DoubleType.s_doubleType, codeGenerationTracker) : codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
            }
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string15 + " " + string2 + " " + string14, codeGenerationTracker);
        }
        return string3;
    }

    @Override
    public String innerToString() {
        return "comparison " + this.m_operation;
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object object2;
        int n;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        switch (this.m_operation) {
            case 18: {
                n = 4;
                break;
            }
            case 16: {
                n = 5;
                break;
            }
            case 17: {
                n = 2;
                break;
            }
            case 15: {
                n = 3;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        com.ibm.xylem.Type type = this.m_operand1.evaluateType(function);
        com.ibm.xylem.Type type2 = this.m_operand2.evaluateType(function);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            object2 = ((CursorStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            object = ((Object)((IStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false))).toString();
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CharType.s_charType.getStreamType())) {
            object = ((Object)((IStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false))).toString();
            object2 = ((CursorStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            n = Operators.getReverseOp(n);
        } else if (type.equals(CursorType.s_cursorType) && type2 instanceof INumericalType) {
            object2 = ((CursorStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
        } else if (type2.equals(CursorType.s_cursorType) && type instanceof INumericalType) {
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object2 = ((CursorStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            n = Operators.getReverseOp(n);
        } else if (type.equals(CursorType.s_cursorType) && type2.equals(BooleanType.s_booleanType)) {
            object2 = CoerceInstruction.evaluateCoersion(environment, this.m_operand1, BooleanType.s_booleanType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
            object = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(BooleanType.s_booleanType)) {
            object2 = this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
            object = CoerceInstruction.evaluateCoersion(environment, this.m_operand2, BooleanType.s_booleanType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor);
        } else if (type2.equals(CursorType.s_cursorType) && type.equals(CursorType.s_cursorType)) {
            object2 = ((CursorStream)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
            object = ((CursorStream)this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor();
        } else {
            object2 = !(type instanceof INumericalType) ? CoerceInstruction.evaluateCoersion(environment, this.m_operand1, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor) : this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
            object = !(type2 instanceof INumericalType) ? CoerceInstruction.evaluateCoersion(environment, this.m_operand2, DoubleType.s_doubleType, function, this.evaluateBindingEnvironment(function), iDebuggerInterceptor) : this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        }
        Boolean bl2 = BasisLibrary.compare(object2, object, n) ? Boolean.TRUE : Boolean.FALSE;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, bl2);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ComparisonInstruction comparisonInstruction = (ComparisonInstruction)object;
        return this.m_operation == comparisonInstruction.m_operation;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new ComparisonInstruction(this.m_operation, instruction, instruction2);
    }
}

