/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ScopedPostOrderOptimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class OrderLetChains {
    private static final boolean m_debug = true;
    Function m_currentFunction;

    public void orderFunction(Function function) {
        this.m_currentFunction = function;
        this.orderInstruction(function.getBody(), null, -1);
    }

    private void orderInstruction(Instruction instruction, Instruction instruction2, int n) {
        if (instruction instanceof LetInstruction) {
            this.orderLetChain(instruction, instruction2, n);
        } else {
            this.orderChildren(instruction);
        }
    }

    private void orderChildren(Instruction instruction) {
        for (int i = 0; i < instruction.getChildInstructionCount(); ++i) {
            Instruction instruction2 = instruction.getChildInstruction(i);
            this.orderInstruction(instruction2, instruction, i);
        }
    }

    private void orderLetChain(Instruction instruction, Instruction instruction2, int n) {
        LinkedList<ArrayList> linkedList;
        Instruction instruction3;
        HashMap hashMap = new HashMap();
        int n2 = 0;
        while (instruction instanceof LetInstruction) {
            ++n2;
            instruction3 = (LetInstruction)instruction;
            this.orderInstruction(((LetBaseInstruction)instruction3).getValue(), instruction3, 0);
            linkedList = ((LetInstruction)instruction).getVariable();
            hashMap.put(linkedList, instruction3);
            instruction = ((LetBaseInstruction)instruction3).getBody();
        }
        this.orderInstruction(instruction, instruction2, n);
        if (n2 <= 1) {
            return;
        }
        instruction3 = instruction;
        linkedList = new LinkedList<ArrayList>();
        ArrayList arrayList = OrderedFreeVariables.findFreeVariables(instruction3);
        LetBaseInstruction letBaseInstruction = null;
        LetInstruction letInstruction = null;
        ArrayList arrayList2 = new ArrayList(hashMap.size());
        while (!arrayList.isEmpty()) {
            Object e = arrayList.get(0);
            LetInstruction letInstruction2 = (LetInstruction)hashMap.get(e);
            if (letInstruction2 != null) {
                ArrayList arrayList3 = OrderedFreeVariables.findFreeVariables(letInstruction2.getValue());
                if (arrayList3.isEmpty()) {
                    arrayList.remove(0);
                    hashMap.remove(e);
                    if (letBaseInstruction != null) {
                        letBaseInstruction.setBody(letInstruction2);
                    } else {
                        letInstruction = letInstruction2;
                    }
                    letBaseInstruction = letInstruction2;
                    arrayList2.add(e);
                } else {
                    linkedList.add(arrayList);
                    arrayList = arrayList3;
                }
            } else {
                arrayList.remove(0);
            }
            while (arrayList.isEmpty() && !linkedList.isEmpty()) {
                arrayList = (ArrayList)linkedList.removeLast();
                e = arrayList.remove(0);
                letInstruction2 = (LetInstruction)hashMap.remove(e);
                if (letBaseInstruction != null) {
                    letBaseInstruction.setBody(letInstruction2);
                } else {
                    letInstruction = letInstruction2;
                }
                letBaseInstruction = letInstruction2;
                arrayList2.add(e);
            }
        }
        if (letInstruction != null) {
            if (instruction2 == null) {
                this.m_currentFunction.setBody(letInstruction);
            } else {
                instruction2.setChildInstruction(n, letInstruction);
            }
        }
        if (letBaseInstruction != null) {
            letBaseInstruction.setBody(instruction3);
        }
    }

    public static class OrderedFreeVariables
    extends ScopedPostOrderOptimizer {
        private ArrayList m_freeVars = new ArrayList();
        private LinkedList m_freeVarsStack = new LinkedList();

        public static ArrayList findFreeVariables(Instruction instruction) {
            OrderedFreeVariables orderedFreeVariables = new OrderedFreeVariables();
            orderedFreeVariables.optimize(instruction);
            return orderedFreeVariables.getFreeVars();
        }

        public ArrayList getFreeVars() {
            return this.m_freeVars;
        }

        @Override
        protected void preOrderStep(Instruction instruction, Instruction instruction2, int n) {
            if (instruction2 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(n)) {
                this.m_freeVarsStack.add(this.m_freeVars);
                this.m_freeVars = new ArrayList();
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
            this.addVars(instruction, instruction2, n);
            this.removeVars(instruction, instruction2, n);
            return instruction;
        }

        @Override
        protected void endOptimize(Instruction instruction) {
            if (this.m_freeVarsStack.size() != 0) {
                throw new XylemError("ERR_SYSTEM", "!!!" + this.m_freeVarsStack.size());
            }
        }

        @Override
        protected void beginOptimize(Instruction instruction) {
            this.m_freeVars.clear();
            this.m_freeVarsStack.clear();
        }

        protected void addVars(Instruction instruction, Instruction instruction2, int n) {
            Object object;
            if (instruction instanceof IdentifierInstruction && !this.m_freeVars.contains(object = ((IdentifierInstruction)instruction).getVariable())) {
                this.m_freeVars.add(((IdentifierInstruction)instruction).getVariable());
            }
        }

        protected void removeVars(Instruction instruction, Instruction instruction2, int n) {
            if (instruction2 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction2)).isChildInstructionBody(n)) {
                IBinding[] iBindingArray = ((ISpecialForm)((Object)instruction2)).getChildInstructionBindings(n);
                if (iBindingArray == null) {
                    throw new XylemError("ERR_SYSTEM", "!" + n + " " + instruction);
                }
                this.m_freeVars.removeAll(Arrays.asList(Binding.getNames(iBindingArray)));
                ArrayList arrayList = (ArrayList)this.m_freeVarsStack.removeLast();
                for (int i = 0; i < this.m_freeVars.size(); ++i) {
                    Object e = this.m_freeVars.get(i);
                    if (arrayList.contains(e)) continue;
                    arrayList.add(e);
                }
                this.m_freeVars = arrayList;
            }
        }
    }
}

