/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.parser;

import com.ibm.xylem.Logger;
import com.ibm.xylem.parser.ParserException;
import com.ibm.xylem.parser.ParserSource;
import com.ibm.xylem.parser.SourceResolver;
import com.ibm.xylem.utils.XylemError;
import java.net.URL;

public class ClassLoaderSourceResolver
extends SourceResolver {
    protected ClassLoader m_classLoader;
    static final Logger s_logger = Logger.getInstance(ClassLoaderSourceResolver.class);

    public ClassLoaderSourceResolver() {
        this(null);
    }

    public ClassLoaderSourceResolver(ClassLoader classLoader) {
        this.m_classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    @Override
    public ParserSource resolve(ParserSource parserSource, String string) throws ParserException {
        URL uRL;
        s_logger.debug("resolving '" + string + "' cl=" + this.m_classLoader);
        if (null == this.m_classLoader) {
            uRL = this.getClass().getResource(string);
            if (null == uRL) {
                uRL = ClassLoader.getSystemResource(string);
            }
        } else {
            uRL = this.m_classLoader.getResource(string);
        }
        if (null == uRL) {
            s_logger.error("resource not found '" + string + "'");
            throw new XylemError("ERR_SYSTEM", "Resource not found '" + string + "'");
        }
        return new ParserSource(uRL);
    }
}

