/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ImmutableArrayList
extends AbstractList {
    private final Object[] fArray;
    private final int fLength;

    public ImmutableArrayList(Object[] objectArray, int n) {
        this.fArray = objectArray;
        this.fLength = n;
    }

    public boolean contains(Object object) {
        return object == null ? this.containsNull() : this.containsObject(object);
    }

    public Object get(int n) {
        if (n >= 0 && n < this.fLength) {
            return this.fArray[n];
        }
        throw new IndexOutOfBoundsException("Index: " + n);
    }

    public Iterator iterator() {
        return new ImmutableArrayListIterator();
    }

    public int size() {
        return this.fLength;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.fLength];
        if (this.fLength > 0) {
            System.arraycopy(this.fArray, 0, objectArray, 0, this.fLength);
        }
        return objectArray;
    }

    private boolean containsObject(Object object) {
        int n = this.fLength - 1;
        while (n >= 0) {
            if (object.equals(this.fArray[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean containsNull() {
        int n = this.fLength - 1;
        while (n >= 0) {
            if (this.fArray[n] == null) {
                return true;
            }
            --n;
        }
        return false;
    }

    private final class ImmutableArrayListIterator
    implements Iterator {
        int index = 0;

        private ImmutableArrayListIterator() {
        }

        public boolean hasNext() {
            return this.index < ImmutableArrayList.this.fLength;
        }

        public Object next() {
            if (this.index < ImmutableArrayList.this.fLength) {
                return ImmutableArrayList.this.fArray[this.index++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

