/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.ConstantPushInstruction;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.Visitor;
import com.ibm.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class BIPUSH
extends Instruction
implements ConstantPushInstruction {
    private byte b;

    BIPUSH() {
    }

    public BIPUSH(byte b) {
        super((short)16, (short)2);
        this.b = b;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        out.writeByte(this.b);
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.b;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)2;
        this.b = bytes.readByte();
    }

    public Number getValue() {
        return new Integer(this.b);
    }

    public Type getType(ConstantPoolGen cp) {
        return Type.BYTE;
    }

    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitBIPUSH(this);
    }
}

