/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Logger;
import com.ibm.xylem.SecuritySupport;
import java.io.File;
import java.net.URL;

public class LogManager {
    public static final void initializeLogger() {
        try {
            Object object;
            File file;
            String string = SecuritySupport.getSystemProperty("xylemlog.configuration");
            if (string != null && string.length() > 0) {
                file = new File(string);
            } else {
                object = SecuritySupport.getSystemProperty("user.home");
                if (object == null) {
                    object = ".";
                }
                file = new File((String)object, "xylemlog.properties");
            }
            if (SecuritySupport.getFileExists(file) && SecuritySupport.getFileCanRead(file)) {
                LogManager.configure(SecuritySupport.fileToURL(file));
            } else {
                object = SecuritySupport.getResource(LogManager.class, "xylemlog.properties");
                if (object != null) {
                    LogManager.configure((URL)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void configure(URL uRL) throws Exception {
        Logger.s_properties.load(SecuritySupport.openURLStream(uRL));
        String string = Logger.s_properties.getProperty("xylemlog.rootLogger", "INFO");
        for (int i = 0; i < Logger.getLevelSize(); ++i) {
            if (!string.startsWith(Logger.getLevel(i))) continue;
            Logger.s_defaultLevel = i;
            break;
        }
    }
}

