/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.types.BigIntegerType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.LongType;
import com.ibm.xylem.utils.XylemError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public class NegateInstruction
extends UnaryPrimopInstruction {
    public NegateInstruction() {
    }

    public NegateInstruction(Instruction instruction) {
        super(instruction);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new NegateInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new NegateInstruction(instruction);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)) instanceof Long) {
            Long l = new Long(-((Long)object).longValue());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, l);
        }
        if (object instanceof Integer) {
            Integer n = new Integer(-((Integer)object).intValue());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, n);
        }
        if (object instanceof Double) {
            Double d = new Double(-((Double)object).doubleValue());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, d);
        }
        if (object instanceof Float) {
            Float f = new Float(-((Float)object).floatValue());
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, f);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)object).negate();
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, bigDecimal);
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = ((BigInteger)object).negate();
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, bigInteger);
        }
        throw new XylemError("ERR_SYSTEM", "The negate operation is only supported on numerical types.");
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = codeGenerationTracker.resolveType(this);
        if (type.equals(IntType.s_intType) || type.equals(FloatType.s_floatType) || type.equals(DoubleType.s_doubleType) || type.equals(LongType.s_longType)) {
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "-(" + string2 + ")", codeGenerationTracker);
        } else if (type.equals(BigIntegerType.s_bigIntegerType) || type.equals(DecimalType.s_decimalType)) {
            dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "(" + string2 + ").negate()", codeGenerationTracker);
        } else {
            throw new XylemError("ERR_SYSTEM", "The negate operation is only supported on numerical types.");
        }
        return string3;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        Type type = codeGenerationTracker.resolveType(this);
        if (type.equals(IntType.s_intType)) {
            instructionListBuilder.appendINeg();
        } else if (type.equals(DoubleType.s_doubleType)) {
            instructionListBuilder.appendDNeg();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_operand.getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public String innerToString() {
        return "negate";
    }
}

