/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IdentifierConsolidator;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xylem.optimizers.FlattenStreamOptimizer;
import com.ibm.xylem.optimizers.partialeval.DefaultEvaluator;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartialInformationCollector {
    static final Logger s_logger = Logger.getInstance(PartialInformationCollector.class);
    protected Map m_evaluators;
    protected PartialEvaluator m_defaultEvaluator;
    protected Instruction m_baseInstruction;
    protected DeadLetEliminatorOptimizer m_deadLetEliminator;
    protected FlattenStreamOptimizer m_fso;
    protected LetChainManager m_baseLetChainManager;
    public LinkedList m_callStack;
    public HashSet m_completedFunctions;
    protected HashSet m_overflowFunctions;
    protected Function m_currentFunction;
    protected IdentifierConsolidator m_identifierConsolidator = null;
    protected int m_evaluationStackDepth = 0;
    protected int m_evaluationStackLimit = 250;
    public boolean m_allowFunctionRecursion = true;
    public boolean m_requestRedo = false;
    static final int s_retryLimit = 10;
    private LinkedList m_emptyLinkedList = new LinkedList();

    public PartialInformationCollector(Instruction instruction, Map map, Function function) {
        this(instruction, map, new DefaultEvaluator(), function);
    }

    public PartialInformationCollector(Instruction instruction, Map map, PartialEvaluator partialEvaluator, Function function) {
        this(instruction, map, partialEvaluator, function, new DeadLetEliminatorOptimizer(), new FlattenStreamOptimizer(), new HashSet());
    }

    protected PartialInformationCollector(Instruction instruction, Map map, PartialEvaluator partialEvaluator, Function function, DeadLetEliminatorOptimizer deadLetEliminatorOptimizer, FlattenStreamOptimizer flattenStreamOptimizer, HashSet hashSet) {
        this.m_evaluators = map;
        this.m_defaultEvaluator = partialEvaluator;
        this.m_baseInstruction = instruction;
        this.m_baseLetChainManager = new LetChainManager(instruction, function);
        this.m_callStack = new LinkedList();
        this.m_completedFunctions = new HashSet();
        this.m_currentFunction = function;
        this.m_deadLetEliminator = deadLetEliminatorOptimizer;
        this.m_fso = flattenStreamOptimizer;
        this.m_overflowFunctions = hashSet;
    }

    public PartialInformationCollector getFunctionSubcollector(Function function) {
        PartialInformationCollector partialInformationCollector = this.createSubcollector(function);
        this.shareState(partialInformationCollector);
        return partialInformationCollector;
    }

    public PartialInformationCollector createSubcollector(Function function) {
        return new PartialInformationCollector(function.getBody(), this.m_evaluators, this.m_defaultEvaluator, function, this.m_deadLetEliminator, this.m_fso, this.m_overflowFunctions);
    }

    public void shareState(PartialInformationCollector partialInformationCollector) {
        partialInformationCollector.m_identifierConsolidator = this.m_identifierConsolidator;
        partialInformationCollector.m_callStack = this.m_callStack;
        partialInformationCollector.m_completedFunctions = this.m_completedFunctions;
        partialInformationCollector.m_evaluationStackDepth = this.m_evaluationStackDepth;
    }

    public void partiallyEvaluateFunction(Function function) {
        String string = function.getName();
        if (this.m_completedFunctions.contains(string)) {
            return;
        }
        if (this.m_callStack.contains(string)) {
            return;
        }
        if (this.m_evaluationStackDepth > this.m_evaluationStackLimit) {
            if (this.m_callStack.size() == 1) {
                s_logger.debug("warning: function " + this.m_currentFunction.getName() + " is too big for stack limit, even when being evaluated alone; requesting called function " + string + " be evaluated separately");
                this.m_overflowFunctions.add(function);
            } else {
                s_logger.debug("preventing stack overflow in partial evaluator by postponing " + string);
                this.m_overflowFunctions.add(this.m_currentFunction);
            }
        } else {
            PartialEvaluationResult partialEvaluationResult;
            Object object;
            try {
                while (true) {
                    this.m_callStack.addLast(string);
                    object = this.getFunctionSubcollector(function);
                    partialEvaluationResult = ((PartialInformationCollector)object).doPartialEvaluationInternal();
                    Instruction instruction = partialEvaluationResult.getReplacement();
                    if (instruction == null) {
                        instruction = function.getBody();
                    } else {
                        instruction = this.m_deadLetEliminator.optimize(instruction, function);
                        instruction = instruction.removeAliases(new HashMap());
                    }
                    function.setBody(instruction);
                    this.m_fso.optimizeFunction(function);
                    this.m_deadLetEliminator.optimizeFunction(function);
                    if (this.m_identifierConsolidator != null) {
                        this.m_identifierConsolidator.processFunction(function);
                    }
                    this.m_callStack.removeLast();
                    this.m_completedFunctions.add(string);
                    if (((PartialInformationCollector)object).m_evaluationStackDepth != this.m_evaluationStackDepth) {
                        System.err.println(">> hmm..." + ((PartialInformationCollector)object).m_evaluationStackDepth + " from " + this.m_evaluationStackDepth);
                    }
                    if (((PartialInformationCollector)object).m_requestRedo) {
                        System.out.println(">> redoing function " + function.getName());
                        continue;
                    }
                    break;
                }
            }
            catch (PartialEvaluationStackOverflow partialEvaluationStackOverflow) {
                if (partialEvaluationStackOverflow.m_depth / 2 > this.m_evaluationStackDepth) {
                    s_logger.warn("StackOverflow during optimization of '" + partialEvaluationStackOverflow.m_fName + "' at depth " + partialEvaluationStackOverflow.m_depth + "\n" + "\tpostponing evaluation of tree starting with " + string + " at depth " + this.m_evaluationStackDepth);
                    this.m_overflowFunctions.add(this.m_currentFunction);
                    return;
                }
                throw partialEvaluationStackOverflow;
            }
            catch (StackOverflowError stackOverflowError) {
                throw new PartialEvaluationStackOverflow(this.m_evaluationStackDepth, string);
            }
            object = function.getTypeEnvironment().getModule();
            ((Module)object).setPartialInformation(function.getName(), partialEvaluationResult.getPartialInformation());
        }
    }

    public PartialEvaluationResult runEvaluators(Instruction object, LetInstruction letInstruction, LetChainManager letChainManager) {
        Object object2;
        Object object3;
        Object object4;
        PartialEvaluationResult partialEvaluationResult;
        ++this.m_evaluationStackDepth;
        Object object5 = null;
        int n = 0;
        while (true) {
            if (object == null || object instanceof IdentifierInstruction || object instanceof LiteralInstruction) {
                throw new IllegalArgumentException("argument " + object);
            }
            if (this.m_allowFunctionRecursion && object instanceof FunctionCallInstruction) {
                this.partiallyEvaluateFunction(this.m_currentFunction.getTypeEnvironment().getModule().getFunction(((FunctionCallInstruction)object).getFunction()));
            }
            Collection collection = this.getEvaluators(object.getClass());
            partialEvaluationResult = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && (partialEvaluationResult = ((PartialEvaluator)(object4 = (PartialEvaluator)iterator.next())).extractPartialInformation((Instruction)object, this, letInstruction, letChainManager)).getReplacement() == null) {
            }
            object4 = partialEvaluationResult.getReplacement();
            if (object4 instanceof LetInstruction) {
                throw new UnsupportedOperationException();
            }
            if (object4 != null) {
                this.typeCheckReplacement((Instruction)object, (Instruction)object4, letChainManager, letInstruction);
            }
            if (!partialEvaluationResult.isIncremental()) break;
            ++n;
            object5 = object4;
            if (object4 instanceof IdentifierInstruction) {
                object3 = letChainManager.lookupBinding((Instruction)object4);
                if (object3 == null) {
                    --this.m_evaluationStackDepth;
                    return partialEvaluationResult;
                }
                object2 = letChainManager.findBinding(((IdentifierInstruction)object4).getVariable()).getLet();
                if (object2 != null && object2.m_partialInformation != null) {
                    --this.m_evaluationStackDepth;
                    return partialEvaluationResult;
                }
                object4 = object3;
            }
            if (object4 instanceof LiteralInstruction) {
                --this.m_evaluationStackDepth;
                return partialEvaluationResult;
            }
            if (n == 10) {
                s_logger.debug("warning: retry limit hit; stopping: " + object4);
                --this.m_evaluationStackDepth;
                return partialEvaluationResult;
            }
            object = object4;
        }
        object3 = new Boolean(object4 != null);
        object2 = new Instruction[]{object5};
        if (object2[0] != null && !((Boolean)object3).booleanValue()) {
            partialEvaluationResult = new PartialEvaluationResult((Instruction)object5, false, partialEvaluationResult.getPartialInformation());
        }
        --this.m_evaluationStackDepth;
        return partialEvaluationResult;
    }

    public Collection getEvaluators(Class clazz) {
        ArrayList<PartialEvaluator> arrayList = this.getInstalledEvaluators(clazz);
        if (arrayList == null || arrayList.size() == 0) {
            arrayList = new ArrayList<PartialEvaluator>();
            arrayList.add(this.m_defaultEvaluator);
        }
        return arrayList;
    }

    public Collection getInstalledEvaluators(Class clazz) {
        Collection collection = (Collection)this.m_evaluators.get(clazz);
        return collection;
    }

    public PartialEvaluationResult runDefaultEvaluator(Instruction instruction, LetInstruction letInstruction, LetChainManager letChainManager) {
        return this.m_defaultEvaluator.extractPartialInformation(instruction, this, letInstruction, letChainManager);
    }

    public void doPartialEvaluationFromFunction(Function function) {
        this.partiallyEvaluateFunction(function);
        this.processOverflowFunctions();
    }

    protected void processOverflowFunctions() {
        while (!this.m_overflowFunctions.isEmpty()) {
            for (Function function : this.m_overflowFunctions) {
                this.m_completedFunctions.remove(function.getName());
            }
            Iterator iterator = this.m_overflowFunctions.iterator();
            this.m_overflowFunctions = new HashSet();
            while (iterator.hasNext()) {
                Function function;
                function = (Function)iterator.next();
                s_logger.debug("partially evaluating overflow function " + function.getName());
                this.partiallyEvaluateFunction(function);
            }
        }
    }

    public PartialEvaluationResult doPartialEvaluation() {
        PartialEvaluationResult partialEvaluationResult = this.doPartialEvaluationInternal();
        this.processOverflowFunctions();
        return partialEvaluationResult;
    }

    protected PartialEvaluationResult doPartialEvaluationInternal() {
        if (this.m_baseLetChainManager.m_targetInstruction instanceof LiteralInstruction) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (this.m_baseLetChainManager.m_targetInstruction instanceof IdentifierInstruction) {
            this.partiallyEvaluate(this.m_baseLetChainManager.m_targetInstruction, this.m_baseLetChainManager);
            LetInstruction letInstruction = this.m_baseLetChainManager.m_outerLet == null ? null : this.m_baseLetChainManager.m_outerLet;
            return new PartialEvaluationResult(letInstruction);
        }
        PartialEvaluationResult partialEvaluationResult = this.runEvaluators(this.m_baseLetChainManager.m_targetInstruction, null, this.m_baseLetChainManager);
        Instruction instruction = partialEvaluationResult.getReplacement();
        if (instruction instanceof LiteralInstruction) {
            return partialEvaluationResult;
        }
        return new PartialEvaluationResult(this.m_baseLetChainManager.graftFinalBody(instruction), partialEvaluationResult.isIncremental(), partialEvaluationResult.getPartialInformation());
    }

    private static String arrayToString(Object[] objectArray) {
        String string = "[";
        if (objectArray.length > 0) {
            string = null == objectArray[0] ? string + "null" : string + objectArray[0].toString();
        }
        for (int i = 1; i < objectArray.length; ++i) {
            string = null == objectArray[i] ? string + ", null" : string + ", " + objectArray[i].toString();
        }
        string = string + "]";
        return string;
    }

    public static HashMap setupDeconstructionBindingReplacement(Instruction[] instructionArray, IBinding[] iBindingArray, Instruction instruction, LetChainManager letChainManager, LetInstruction letInstruction) {
        if (instructionArray.length > iBindingArray.length) {
            System.out.println("replaceDeconstructionBindings(" + PartialInformationCollector.arrayToString(instructionArray) + ", " + PartialInformationCollector.arrayToString(iBindingArray) + ")");
            new Exception().printStackTrace();
        }
        HashMap<Object, Instruction> hashMap = new HashMap<Object, Instruction>();
        for (int i = 0; i < instructionArray.length; ++i) {
            Instruction instruction2 = instructionArray[i];
            if (instruction2 == null) continue;
            hashMap.put(iBindingArray[i].getName(), instruction2);
        }
        return hashMap;
    }

    public PartialEvaluationResult partiallyEvaluateBody(Instruction instruction, Instruction instruction2, int n, LetChainManager letChainManager) {
        LetChainManager letChainManager2 = new LetChainManager(instruction, letChainManager, letChainManager.m_currentFunction, instruction2, n);
        Instruction instruction3 = instruction;
        instruction = letChainManager2.m_targetInstruction;
        if (instruction instanceof IdentifierInstruction) {
            Instruction instruction4;
            Set set = this.partiallyEvaluate(instruction, letChainManager2);
            Instruction instruction5 = instruction4 = letChainManager2.m_outerLet == null ? instruction3 : letChainManager2.m_outerLet;
            if (instruction4 != instruction3) {
                return new PartialEvaluationResult(instruction4, set);
            }
            return new PartialEvaluationResult(set);
        }
        if (instruction instanceof LiteralInstruction) {
            return PartialEvaluationResult.s_emptyResult;
        }
        PartialEvaluationResult partialEvaluationResult = this.runEvaluators(letChainManager2.m_targetInstruction, null, letChainManager2);
        Instruction instruction6 = partialEvaluationResult.getReplacement();
        if (instruction6 instanceof LiteralInstruction) {
            return new PartialEvaluationResult(instruction6, partialEvaluationResult.getPartialInformation());
        }
        return new PartialEvaluationResult(letChainManager2.graftFinalBody(instruction6), partialEvaluationResult.getPartialInformation());
    }

    public Set partiallyEvaluate(Instruction instruction, LetChainManager letChainManager) {
        if (!(instruction instanceof IdentifierInstruction)) {
            if (instruction instanceof LiteralInstruction) {
                return Collections.EMPTY_SET;
            }
            throw new IllegalArgumentException("Should not occur in reduced code: (" + instruction.getClass() + ")" + instruction);
        }
        IBinding iBinding = letChainManager.findBinding(((IdentifierInstruction)instruction).getVariable());
        if (iBinding == null) {
            System.err.println(">> binding " + instruction);
            System.err.println(letChainManager.getCurrentFunction());
            throw new RuntimeException();
        }
        if (iBinding.getLet() == null) {
            return Collections.EMPTY_SET;
        }
        LetInstruction letInstruction = iBinding.getLet();
        Set set = letInstruction.m_partialInformation;
        if (set != null) {
            return set;
        }
        Instruction instruction2 = letInstruction.getValue();
        if (instruction2 instanceof LiteralInstruction) {
            return Collections.EMPTY_SET;
        }
        if (instruction2 instanceof IdentifierInstruction) {
            set = this.partiallyEvaluate(instruction2, letChainManager);
            return set;
        }
        if (instruction2 == null) {
            throw new XylemError("ERR_SYSTEM", "null value for binding " + iBinding + " " + letChainManager.getCurrentFunction());
        }
        PartialEvaluationResult partialEvaluationResult = this.runEvaluators(instruction2, letInstruction, letChainManager);
        letInstruction.m_partialInformation = set = partialEvaluationResult.getPartialInformation();
        Instruction instruction3 = partialEvaluationResult.getReplacement();
        if (instruction3 != null) {
            this.replaceLetValue(iBinding.getLet(), instruction3);
            if (instruction3 instanceof IdentifierInstruction && (set == null || set.isEmpty())) {
                letInstruction.m_partialInformation = set = this.partiallyEvaluate(instruction3, letChainManager);
            }
        }
        return set;
    }

    protected void replaceLetValue(LetInstruction letInstruction, Instruction instruction) {
        letInstruction.setValue(instruction);
    }

    protected void typeCheckReplacement(Instruction instruction, Instruction instruction2, LetChainManager letChainManager, LetInstruction letInstruction) {
        instruction2.typeCheckReduced(this.getCurrentTypeEnvironment(), this.getCurrentBindingEnvironment(), this.m_emptyLinkedList);
    }

    public Type resolveType(Instruction instruction) {
        BindingEnvironment bindingEnvironment;
        TypeEnvironment typeEnvironment = this.m_currentFunction.getTypeEnvironment();
        Type type = instruction.getType(typeEnvironment, bindingEnvironment = this.m_currentFunction.getBindingEnvironment());
        if (type == null) {
            throw new RuntimeException();
        }
        return type.resolveType(typeEnvironment);
    }

    public Module getCurrentModule() {
        return this.m_currentFunction.getTypeEnvironment().getModule();
    }

    public TypeEnvironment getCurrentTypeEnvironment() {
        return this.m_currentFunction.getTypeEnvironment();
    }

    public BindingEnvironment getCurrentBindingEnvironment() {
        return this.m_currentFunction.getBindingEnvironment();
    }

    public void setIdentifierConsolidator(IdentifierConsolidator identifierConsolidator) {
        this.m_identifierConsolidator = identifierConsolidator;
    }

    public LetChainManager getBaseLetChainManager() {
        return this.m_baseLetChainManager;
    }

    private static class PartialEvaluationStackOverflow
    extends RuntimeException {
        int m_depth;
        String m_fName;

        PartialEvaluationStackOverflow(int n, String string) {
            this.m_depth = n;
            this.m_fName = string;
        }
    }
}

