/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.tools.rumen.CDFRandomGenerator;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;

public class CDFPiecewiseLinearRandomGenerator
extends CDFRandomGenerator {
    public CDFPiecewiseLinearRandomGenerator(LoggedDiscreteCDF cdf) {
        super(cdf);
    }

    public CDFPiecewiseLinearRandomGenerator(LoggedDiscreteCDF cdf, long seed) {
        super(cdf, seed);
    }

    @Override
    public long valueAt(double probability) {
        int rangeFloor = this.floorIndex(probability);
        double segmentProbMin = this.getRankingAt(rangeFloor);
        double segmentProbMax = this.getRankingAt(rangeFloor + 1);
        long segmentMinValue = this.getDatumAt(rangeFloor);
        long segmentMaxValue = this.getDatumAt(rangeFloor + 1);
        double segmentProbRange = segmentProbMax - segmentProbMin;
        long segmentDatumRange = segmentMaxValue - segmentMinValue;
        long result = (long)((probability - segmentProbMin) / segmentProbRange * (double)segmentDatumRange) + segmentMinValue;
        return result;
    }
}

