/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentDescription;
import org.apache.axis2.jaxws.description.AttachmentType;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.Attachment;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocLitBareMinimalMethodMarshaller
implements MethodMarshaller {
    private static Log log = LogFactory.getLog(DocLitBareMinimalMethodMarshaller.class);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object demarshalResponse(Message message, Object[] signatureArgs, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            void var10_16;
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            Class returnType = operationDesc.getResultActualType();
            Object var10_11 = null;
            boolean hasReturnInBody = false;
            if (returnType != Void.TYPE) {
                void var10_14;
                AttachmentDescription attachmentDesc = operationDesc.getResultAttachmentDescription();
                if (attachmentDesc != null) {
                    if (attachmentDesc.getAttachmentType() != AttachmentType.SWA) throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"pdElementErr"));
                    String cid = message.getAttachmentID(0);
                    DataHandler dataHandler = message.getDataHandler(cid);
                } else {
                    Class byJavaType = null;
                    if (MethodMarshallerUtils.isNotJAXBRootElement(returnType, marshalDesc)) {
                        byJavaType = returnType;
                    }
                    Element returnElement = null;
                    if (operationDesc.isResultHeader()) {
                        returnElement = MethodMarshallerUtils.getReturnElement(packages, message, byJavaType, operationDesc.isListType(), true, operationDesc.getResultTargetNamespace(), operationDesc.getResultName(), MethodMarshallerUtils.numOutputBodyParams(pds) > 0);
                    } else {
                        returnElement = MethodMarshallerUtils.getReturnElement(packages, message, byJavaType, operationDesc.isListType(), false, null, null, MethodMarshallerUtils.numOutputBodyParams(pds) > 0);
                        hasReturnInBody = true;
                    }
                    Object object = returnElement.getTypeValue();
                }
                if (ConvertUtils.isConvertable(var10_14, returnType)) {
                    Object object = ConvertUtils.convert(var10_14, returnType);
                }
            }
            Class[] javaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                Class type = pd.getParameterActualType();
                if (!MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                javaTypes[i] = type;
            }
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(pds, message, packages, false, hasReturnInBody, javaTypes);
            MethodMarshallerUtils.updateResponseSignatureArgs(pds, pvList, signatureArgs);
            return var10_16;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Object[] demarshalRequest(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            Class[] javaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                Class type = pd.getParameterActualType();
                if (!MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                javaTypes[i] = type;
            }
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(pds, message, packages, true, false, javaTypes);
            Object[] sigArguments = MethodMarshallerUtils.createRequestSignatureArgs(pds, pvList);
            return sigArguments;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Message marshalResponse(Object returnObject, Object[] signatureArgs, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            Class returnType = operationDesc.getResultActualType();
            if (returnType != Void.TYPE) {
                AttachmentDescription attachmentDesc = operationDesc.getResultAttachmentDescription();
                if (attachmentDesc != null) {
                    if (attachmentDesc.getAttachmentType() != AttachmentType.SWA) throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"pdElementErr"));
                    Attachment attachment = new Attachment(returnObject, returnType, attachmentDesc, operationDesc.getResultPartName());
                    m.addDataHandler(attachment.getDataHandler(), attachment.getContentID());
                    m.setDoingSWA(true);
                } else {
                    Class byJavaType = null;
                    if (MethodMarshallerUtils.isNotJAXBRootElement(returnType, marshalDesc)) {
                        byJavaType = returnType;
                    }
                    Element returnElement = null;
                    QName returnQName = new QName(operationDesc.getResultTargetNamespace(), operationDesc.getResultName());
                    returnElement = marshalDesc.getAnnotationDesc(returnType).hasXmlRootElement() ? new Element(returnObject, returnQName) : new Element(returnObject, returnQName, returnType);
                    MethodMarshallerUtils.toMessage(returnElement, returnType, operationDesc.isListType(), marshalDesc, m, byJavaType, operationDesc.isResultHeader());
                }
            }
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArgs, false, false, false);
            for (PDElement pde : pdeList) {
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                if (!MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages, null);
            if (!operationDesc.hasResponseSwaRefAttachments()) return m;
            m.setDoingSWA(true);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Message marshalRequest(Object[] signatureArguments, OperationDescription operationDesc, Map<String, Object> requestContext) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        Protocol protocol = Protocol.getProtocolForBinding(endpointDesc.getClientBindingID());
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArguments, true, false, false);
            for (PDElement pde : pdeList) {
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                if (!MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages, requestContext);
            if (operationDesc.hasRequestSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Message marshalFaultResponse(Throwable throwable, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            MethodMarshallerUtils.marshalFaultResponse(throwable, marshalDesc, operationDesc, m);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public Throwable demarshalFaultResponse(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        try {
            Throwable t = MethodMarshallerUtils.demarshalFaultResponse(operationDesc, marshalDesc, message);
            return t;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }
}

