/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.IExtensibleWriter;
import org.jibx.runtime.impl.XMLWriterNamespaceBase;

public abstract class XMLWriterBase
extends XMLWriterNamespaceBase
implements IExtensibleWriter {
    private boolean m_textSeen;
    private boolean m_contentSeen = true;
    private boolean m_afterFirst;

    public XMLWriterBase(String[] uris) {
        super(uris);
    }

    public XMLWriterBase(XMLWriterBase base, String[] uris) {
        super(base, uris);
        this.m_afterFirst = base.m_afterFirst;
    }

    protected abstract void writeMarkup(String var1) throws IOException;

    protected abstract void writeMarkup(char var1) throws IOException;

    protected abstract void writePrefix(int var1) throws IOException;

    protected abstract void writeAttributeText(String var1) throws IOException;

    protected abstract void indent(int var1) throws IOException;

    protected final void flagContent() throws IOException {
        if (!this.m_contentSeen) {
            this.writeMarkup('>');
            this.incrementNesting();
            this.m_contentSeen = true;
        }
    }

    protected final void flagTextContent() throws IOException {
        this.flagContent();
        this.m_textSeen = true;
    }

    @Override
    public void init() {
    }

    @Override
    public void writeXMLDecl(String version, String encoding, String standalone) throws IOException {
        if (this.m_afterFirst) {
            throw new IllegalStateException("XML declaration must be written before any other output");
        }
        this.writeMarkup("<?xml version=\"");
        this.writeAttributeText(version);
        if (encoding != null) {
            this.writeMarkup("\" encoding=\"");
            this.writeAttributeText(encoding);
        }
        if (standalone != null) {
            this.writeMarkup("\" standalone=\"");
            this.writeAttributeText(standalone);
        }
        this.writeMarkup("\"?>");
        this.m_afterFirst = true;
    }

    @Override
    public void startTagOpen(int index, String name) throws IOException {
        this.flagContent();
        this.indentAfterFirst();
        this.writeMarkup('<');
        this.writePrefix(index);
        this.writeMarkup(name);
        this.m_contentSeen = false;
        this.m_textSeen = false;
    }

    @Override
    public void startTagNamespaces(int index, String name, int[] nums, String[] prefs) throws IOException {
        this.flagContent();
        int[] deltas = this.openNamespaces(nums, prefs);
        this.startTagOpen(index, name);
        for (int i = 0; i < deltas.length; ++i) {
            int slot = deltas[i];
            String prefix = this.internalNamespacePrefix(slot);
            if (prefix != null && prefix.length() > 0) {
                this.writeMarkup(" xmlns:");
                this.writeMarkup(prefix);
                this.writeMarkup("=\"");
            } else {
                this.writeMarkup(" xmlns=\"");
            }
            this.writeAttributeText(this.internalNamespaceUri(slot));
            this.writeMarkup('\"');
        }
    }

    @Override
    public void addAttribute(int index, String name, String value) throws IOException {
        this.writeMarkup(' ');
        this.writePrefix(index);
        this.writeMarkup(name);
        this.writeMarkup("=\"");
        this.writeAttributeText(value);
        this.writeMarkup('\"');
    }

    @Override
    public void closeStartTag() throws IOException {
    }

    @Override
    public void closeEmptyTag() throws IOException {
        this.writeMarkup("/>");
        this.incrementNesting();
        this.decrementNesting();
        this.m_contentSeen = true;
    }

    private void indentAfterFirst() throws IOException {
        if (this.m_afterFirst) {
            this.indent(0);
        } else {
            this.m_afterFirst = true;
        }
    }

    @Override
    public void startTagClosed(int index, String name) throws IOException {
        this.flagContent();
        this.indentAfterFirst();
        this.writeMarkup('<');
        this.writePrefix(index);
        this.writeMarkup(name);
        this.m_contentSeen = false;
        this.m_textSeen = false;
    }

    @Override
    public void endTag(int index, String name) throws IOException {
        if (this.m_contentSeen && !this.m_textSeen) {
            this.indent(-1);
        }
        if (this.m_contentSeen) {
            this.writeMarkup("</");
            this.writePrefix(index);
            this.writeMarkup(name);
            this.writeMarkup('>');
        } else {
            this.writeMarkup("/>");
            this.incrementNesting();
        }
        this.decrementNesting();
        this.m_textSeen = false;
        this.m_contentSeen = true;
    }

    @Override
    public void writeComment(String text) throws IOException {
        this.flagContent();
        this.writeMarkup("<!--");
        this.writeMarkup(text);
        this.writeMarkup("-->");
    }

    @Override
    public void writeEntityRef(String name) throws IOException {
        this.flagContent();
        this.writeMarkup('&');
        this.writeMarkup(name);
        this.writeMarkup(';');
    }

    @Override
    public void writeDocType(String name, String sys, String pub, String subset) throws IOException {
        this.indentAfterFirst();
        this.writeMarkup("<!DOCTYPE ");
        this.writeMarkup(name);
        this.writeMarkup(' ');
        if (sys != null) {
            if (pub == null) {
                this.writeMarkup("SYSTEM \"");
                this.writeMarkup(sys);
            } else {
                this.writeMarkup("PUBLIC \"");
                this.writeMarkup(pub);
                this.writeMarkup("\" \"");
                this.writeMarkup(sys);
            }
            this.writeMarkup('\"');
        }
        if (subset != null) {
            this.writeMarkup('[');
            this.writeMarkup(subset);
            this.writeMarkup(']');
        }
        this.writeMarkup('>');
    }

    @Override
    public void writePI(String target, String data) throws IOException {
        this.flagContent();
        this.indentAfterFirst();
        this.writeMarkup("<?");
        this.writeMarkup(target);
        this.writeMarkup(' ');
        this.writeMarkup(data);
        this.writeMarkup("?>");
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public void reset() {
        this.m_textSeen = false;
        this.m_contentSeen = true;
        this.m_afterFirst = false;
        super.reset();
    }
}

