/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.HashSet;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.DefinitionContext;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.InputElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.ModelVisitor;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.NestingElementBase;
import org.jibx.binding.model.OutputElement;
import org.jibx.binding.model.PrecompiledMappingElement;
import org.jibx.binding.model.SplitElement;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.TemplateElement;
import org.jibx.binding.model.ValueElement;
import org.jibx.binding.util.ObjectStack;
import org.jibx.util.IClass;
import org.jibx.util.IClassLocator;

public class TreeContext {
    private DefinitionContext m_globalContext;
    private BindingElement m_bindingRoot;
    private ObjectStack m_treeHierarchy;
    private IClassLocator m_locator;
    private HashSet m_skipSet;

    private TreeContext() {
    }

    public TreeContext(IClassLocator iloc) {
        this.m_treeHierarchy = new ObjectStack();
        this.m_locator = iloc;
        this.m_skipSet = new HashSet();
    }

    public TreeContext getChildContext() {
        TreeContext child = new TreeContext();
        child.m_bindingRoot = this.m_bindingRoot;
        child.m_globalContext = this.m_globalContext;
        child.m_locator = this.m_locator;
        child.m_skipSet = this.m_skipSet;
        child.m_treeHierarchy = new ObjectStack(this.m_treeHierarchy);
        return child;
    }

    public void setGlobalDefinitions(DefinitionContext dctx) {
        this.m_globalContext = dctx;
    }

    public void tourTree(BindingElement root, ModelVisitor visitor) {
        BindingElement hold = this.m_bindingRoot;
        this.m_bindingRoot = root;
        this.tourTree((ElementBase)root, visitor);
        this.m_bindingRoot = hold;
    }

    public void tourTree(ElementBase root, ModelVisitor visitor) {
        if (this.m_skipSet.contains(root)) {
            return;
        }
        boolean expand = false;
        this.m_treeHierarchy.push(root);
        switch (root.type()) {
            case 0: {
                expand = visitor.visit((BindingElement)root);
                break;
            }
            case 1: {
                expand = visitor.visit((CollectionElement)root);
                break;
            }
            case 2: {
                visitor.visit((FormatElement)root);
                break;
            }
            case 8: {
                expand = visitor.visit((IncludeElement)root);
                break;
            }
            case 10: {
                expand = visitor.visit((InputElement)root);
                break;
            }
            case 3: {
                if (root instanceof MappingElement) {
                    expand = visitor.visit((MappingElement)root);
                    break;
                }
                expand = visitor.visit((PrecompiledMappingElement)root);
                break;
            }
            case 4: {
                visitor.visit((NamespaceElement)root);
                break;
            }
            case 11: {
                expand = visitor.visit((OutputElement)root);
                break;
            }
            case 9: {
                expand = visitor.visit((SplitElement)root);
                break;
            }
            case 5: {
                expand = visitor.visit((StructureElement)root);
                break;
            }
            case 6: {
                expand = visitor.visit((TemplateElement)root);
                break;
            }
            case 7: {
                visitor.visit((ValueElement)root);
                break;
            }
            default: {
                throw new IllegalStateException("Internal error: unknown element type");
            }
        }
        if (expand && !this.m_skipSet.contains(root)) {
            if (root instanceof IncludeElement) {
                BindingElement binding = ((IncludeElement)root).getBinding();
                if (binding != null) {
                    this.m_treeHierarchy.pop();
                    this.tourTree((ElementBase)binding, visitor);
                    this.m_treeHierarchy.push(root);
                }
            } else if (root instanceof NestingElementBase) {
                int i;
                ArrayList childs = null;
                if (root instanceof MappingElement) {
                    childs = ((MappingElementBase)root).topChildren();
                    for (i = 0; i < childs.size(); ++i) {
                        this.tourTree((ElementBase)childs.get(i), visitor);
                    }
                }
                childs = root instanceof BindingElement ? ((BindingElement)root).topChildren() : ((NestingElementBase)root).children();
                for (i = 0; i < childs.size(); ++i) {
                    this.tourTree((ElementBase)childs.get(i), visitor);
                }
            }
        }
        switch (root.type()) {
            case 0: {
                visitor.exit((BindingElement)root);
                break;
            }
            case 1: {
                visitor.exit((CollectionElement)root);
                break;
            }
            case 8: {
                visitor.exit((IncludeElement)root);
                break;
            }
            case 10: {
                visitor.exit((InputElement)root);
                break;
            }
            case 3: {
                if (root instanceof MappingElement) {
                    visitor.exit((MappingElement)root);
                    break;
                }
                visitor.exit((PrecompiledMappingElement)root);
                break;
            }
            case 11: {
                visitor.exit((OutputElement)root);
                break;
            }
            case 9: {
                visitor.exit((SplitElement)root);
                break;
            }
            case 5: {
                visitor.exit((StructureElement)root);
                break;
            }
            case 6: {
                visitor.exit((TemplateElement)root);
                break;
            }
            case 7: {
                visitor.exit((ValueElement)root);
                break;
            }
        }
        this.m_treeHierarchy.pop();
    }

    public int getNestingDepth() {
        return this.m_treeHierarchy.size();
    }

    protected ElementBase peekElement() {
        return (ElementBase)this.m_treeHierarchy.peek();
    }

    public boolean isSkipped(Object obj) {
        return this.m_skipSet.contains(obj);
    }

    protected void addSkip(Object skip) {
        if (skip instanceof ElementBase) {
            this.m_skipSet.add(skip);
        }
    }

    public BindingElement getBindingRoot() {
        if (this.m_bindingRoot == null) {
            throw new IllegalStateException("No binding root defined");
        }
        return this.m_bindingRoot;
    }

    public void setBindingRoot(BindingElement root) {
        this.m_bindingRoot = root;
    }

    public NestingElementBase getParentElement() {
        if (this.m_treeHierarchy.size() > 1) {
            return (NestingElementBase)this.m_treeHierarchy.peek(1);
        }
        return null;
    }

    public ElementBase getParentElement(int level) {
        return (ElementBase)this.m_treeHierarchy.peek(level);
    }

    public ContainerElementBase getParentContainer() {
        int index = 1;
        while (index < this.m_treeHierarchy.size()) {
            NestingElementBase nest;
            if (!((nest = (NestingElementBase)this.m_treeHierarchy.peek(index++)) instanceof ContainerElementBase)) continue;
            return (ContainerElementBase)nest;
        }
        throw new IllegalStateException("Internal error: no container");
    }

    public ContainerElementBase getContextObject() {
        int index = 1;
        while (index < this.m_treeHierarchy.size()) {
            ContainerElementBase contain;
            NestingElementBase nest;
            if (!((nest = (NestingElementBase)this.m_treeHierarchy.peek(index++)) instanceof ContainerElementBase) || !(contain = (ContainerElementBase)nest).hasObject()) continue;
            return contain;
        }
        throw new IllegalStateException("Internal error: no context object");
    }

    public boolean isInBinding() {
        return this.m_bindingRoot == null ? true : this.m_bindingRoot.isInBinding();
    }

    public boolean isOutBinding() {
        return this.m_bindingRoot == null ? true : this.m_bindingRoot.isOutBinding();
    }

    public DefinitionContext getDefinitions() {
        int index = 1;
        while (index < this.m_treeHierarchy.size()) {
            NestingElementBase nest;
            if ((nest = (NestingElementBase)this.m_treeHierarchy.peek(index++)).getDefinitions() == null) continue;
            return nest.getDefinitions();
        }
        if (this.m_globalContext == null) {
            throw new IllegalStateException("Internal error: no definition context");
        }
        return this.m_globalContext;
    }

    public DefinitionContext getCurrentDefinitions() {
        NestingElementBase parent = this.getParentElement();
        DefinitionContext dctx = parent.getDefinitions();
        if (dctx == null) {
            dctx = new DefinitionContext(this.getDefinitions());
            parent.setDefinitions(dctx);
        }
        return dctx;
    }

    public DefinitionContext getFormatDefinitions() {
        NestingElementBase parent = this.getParentElement();
        DefinitionContext dctx = parent.getDefinitions();
        if (dctx == null) {
            NestingElementBase nest;
            int index = 1;
            DefinitionContext pctx = null;
            while (++index < this.m_treeHierarchy.size() && (pctx = (nest = (NestingElementBase)this.m_treeHierarchy.peek(index)).getDefinitions()) == null) {
            }
            while (index >= 2) {
                dctx = new DefinitionContext(pctx);
                nest = (NestingElementBase)this.m_treeHierarchy.peek(--index);
                nest.setDefinitions(dctx);
                pctx = dctx;
            }
        }
        return dctx;
    }

    public boolean isLookupSupported() {
        return this.m_locator.isLookupSupported();
    }

    public IClass getClassInfo(String name) {
        return this.m_locator.getClassInfo(name);
    }

    public IClass getRequiredClassInfo(String name) {
        IClass iclas = this.m_locator.getClassInfo(name);
        if (iclas == null) {
            throw new IllegalStateException("Internal error: class " + name + " cannot be found");
        }
        return iclas;
    }

    public void pushNode(ElementBase node) {
        this.m_treeHierarchy.push(node);
    }

    public ElementBase popNode() {
        return (ElementBase)this.m_treeHierarchy.pop();
    }
}

