/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.ServiceTaskManager;

public class ServiceTaskManagerFactory {
    private ServiceTaskManagerFactory() {
    }

    public static ServiceTaskManager createTaskManagerForService(JMSConnectionFactory jcf, AxisService service, WorkerPool workerPool) {
        Double dValue;
        String name = service.getName();
        Map<String, String> svc = ServiceTaskManagerFactory.getServiceStringParameters(service.getParameters());
        Hashtable<String, String> cf = jcf.getParameters();
        ServiceTaskManager stm = new ServiceTaskManager();
        stm.setServiceName(name);
        stm.addJmsProperties(cf);
        stm.addJmsProperties(svc);
        stm.setConnFactoryJNDIName(ServiceTaskManagerFactory.getRqdStringProperty("transport.jms.ConnectionFactoryJNDIName", svc, cf));
        String destName = ServiceTaskManagerFactory.getOptionalStringProperty("transport.jms.Destination", svc, cf);
        if (destName == null) {
            destName = service.getName();
        }
        stm.setDestinationJNDIName(destName);
        stm.setDestinationType(ServiceTaskManagerFactory.getDestinationType(svc, cf));
        stm.setJmsSpec11(ServiceTaskManagerFactory.getJMSSpecVersion(svc, cf));
        stm.setTransactionality(ServiceTaskManagerFactory.getTransactionality(svc, cf));
        stm.setCacheUserTransaction(ServiceTaskManagerFactory.getOptionalBooleanProperty("transport.CacheUserTxn", svc, cf));
        stm.setUserTransactionJNDIName(ServiceTaskManagerFactory.getOptionalStringProperty("transport.UserTxnJNDIName", svc, cf));
        stm.setSessionTransacted(ServiceTaskManagerFactory.getOptionalBooleanProperty("transport.jms.SessionTransacted", svc, cf));
        stm.setSessionAckMode(ServiceTaskManagerFactory.getSessionAck(svc, cf));
        stm.setMessageSelector(ServiceTaskManagerFactory.getOptionalStringProperty("transport.jms.MessageSelector", svc, cf));
        stm.setSubscriptionDurable(ServiceTaskManagerFactory.getOptionalBooleanProperty("transport.jms.SubscriptionDurable", svc, cf));
        stm.setDurableSubscriberName(ServiceTaskManagerFactory.getOptionalStringProperty("transport.jms.DurableSubscriberName", svc, cf));
        stm.setCacheLevel(ServiceTaskManagerFactory.getCacheLevel(svc, cf));
        stm.setPubSubNoLocal(ServiceTaskManagerFactory.getOptionalBooleanProperty("transport.jms.PubSubNoLocal", svc, cf));
        Integer value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.ReceiveTimeout", svc, cf);
        if (value != null) {
            stm.setReceiveTimeout(value);
        }
        if ((value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.ConcurrentConsumers", svc, cf)) != null) {
            stm.setConcurrentConsumers(value);
        }
        if ((value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.MaxConcurrentConsumers", svc, cf)) != null) {
            stm.setMaxConcurrentConsumers(value);
        }
        if ((value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.IdleTaskLimit", svc, cf)) != null) {
            stm.setIdleTaskExecutionLimit(value);
        }
        if ((value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.MaxMessagesPerTask", svc, cf)) != null) {
            stm.setMaxMessagesPerTask(value);
        }
        if ((value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.InitialReconnectDuration", svc, cf)) != null) {
            stm.setInitialReconnectDuration(value);
        }
        if ((value = ServiceTaskManagerFactory.getOptionalIntProperty("transport.jms.MaxReconnectDuration", svc, cf)) != null) {
            stm.setMaxReconnectDuration(value.intValue());
        }
        if ((dValue = ServiceTaskManagerFactory.getOptionalDoubleProperty("transport.jms.ReconnectProgressFactor", svc, cf)) != null) {
            stm.setReconnectionProgressionFactor(dValue);
        }
        stm.setWorkerPool(workerPool);
        stm.removeJmsProperties("transport.jms.ConnectionFactoryJNDIName");
        stm.removeJmsProperties("transport.jms.Destination");
        stm.removeJmsProperties("transport.jms.JMSSpecVersion");
        stm.removeJmsProperties("transport.Transactionality");
        stm.removeJmsProperties("transport.CacheUserTxn");
        stm.removeJmsProperties("transport.UserTxnJNDIName");
        stm.removeJmsProperties("transport.jms.SessionTransacted");
        stm.removeJmsProperties("transport.jms.MessageSelector");
        stm.removeJmsProperties("transport.jms.SubscriptionDurable");
        stm.removeJmsProperties("transport.jms.DurableSubscriberName");
        stm.removeJmsProperties("transport.jms.CacheLevel");
        stm.removeJmsProperties("transport.jms.PubSubNoLocal");
        stm.removeJmsProperties("transport.jms.ReceiveTimeout");
        stm.removeJmsProperties("transport.jms.ConcurrentConsumers");
        stm.removeJmsProperties("transport.jms.MaxConcurrentConsumers");
        stm.removeJmsProperties("transport.jms.IdleTaskLimit");
        stm.removeJmsProperties("transport.jms.MaxMessagesPerTask");
        stm.removeJmsProperties("transport.jms.InitialReconnectDuration");
        stm.removeJmsProperties("transport.jms.MaxReconnectDuration");
        stm.removeJmsProperties("transport.jms.ReconnectProgressFactor");
        return stm;
    }

    private static Map<String, String> getServiceStringParameters(List<Parameter> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter p : list) {
            if (!(p.getValue() instanceof String)) continue;
            map.put(p.getName(), (String)p.getValue());
        }
        return map;
    }

    private static String getRqdStringProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value == null) {
            throw new AxisJMSException("Service/connection factory property : " + key);
        }
        return value;
    }

    private static String getOptionalStringProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        return value;
    }

    private static Boolean getOptionalBooleanProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private static Integer getOptionalIntProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new AxisJMSException("Invalid value : " + value + " for " + key);
            }
        }
        return null;
    }

    private static Double getOptionalDoubleProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new AxisJMSException("Invalid value : " + value + " for " + key);
            }
        }
        return null;
    }

    private static int getTransactionality(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.Transactionality";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if (val == null) {
            return 0;
        }
        if ("jta".equalsIgnoreCase(val)) {
            return 2;
        }
        if ("local".equalsIgnoreCase(val)) {
            return 1;
        }
        throw new AxisJMSException("Invalid option : " + val + " for parameter : jta");
    }

    private static int getDestinationType(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.DestinationType";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if ("topic".equalsIgnoreCase(val)) {
            return 2;
        }
        return 1;
    }

    private static int getSessionAck(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.SessionAcknowledgement";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if (val == null || "AUTO_ACKNOWLEDGE".equalsIgnoreCase(val)) {
            return 1;
        }
        if ("CLIENT_ACKNOWLEDGE".equalsIgnoreCase(val)) {
            return 2;
        }
        if ("DUPS_OK_ACKNOWLEDGE".equals(val)) {
            return 3;
        }
        if ("SESSION_TRANSACTED".equals(val)) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ignore) {
            throw new AxisJMSException("Invalid session acknowledgement mode : " + val);
        }
    }

    private static int getCacheLevel(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.CacheLevel";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if ("none".equalsIgnoreCase(val)) {
            return 0;
        }
        if ("connection".equalsIgnoreCase(val)) {
            return 1;
        }
        if ("session".equals(val)) {
            return 2;
        }
        if ("consumer".equals(val)) {
            return 3;
        }
        if ("producer".equals(val)) {
            return 4;
        }
        if (val != null) {
            throw new AxisJMSException("Invalid cache level : " + val);
        }
        return 5;
    }

    private static boolean getJMSSpecVersion(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.JMSSpecVersion";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        return val == null || "1.1".equals(val);
    }
}

