/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.AnnotationDescImpl;
import org.apache.axis2.jaxws.utility.PropertyDescriptorPlus;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarshalServiceRuntimeDescriptionImpl
implements MarshalServiceRuntimeDescription {
    private static final Log log = LogFactory.getLog(MarshalServiceRuntimeDescriptionImpl.class);
    private ServiceDescription serviceDesc;
    private String key;
    private TreeSet<String> packages;
    private String packagesKey;
    private Map<String, AnnotationDesc> annotationMap = null;
    private Map<Class, Map<String, PropertyDescriptorPlus>> pdMapCache = null;
    private Map<OperationDescription, String> requestWrapperMap = null;
    private Map<OperationDescription, String> responseWrapperMap = null;
    private Map<FaultDescription, FaultBeanDesc> faultBeanDescMap = null;
    private Map<OperationDescription, Method> methodMap = null;
    private MessageFactory messageFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);

    protected MarshalServiceRuntimeDescriptionImpl(String key, ServiceDescription serviceDesc) {
        if (log.isDebugEnabled()) {
            QName qName = serviceDesc == null ? null : serviceDesc.getServiceQName();
            log.debug((Object)("Create MarshalServiceRuntimeDescriptionImpl for " + String.valueOf(serviceDesc)));
        }
        this.serviceDesc = serviceDesc;
        this.key = key;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDesc;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public TreeSet<String> getPackages() {
        return this.packages;
    }

    @Override
    public String getPackagesKey() {
        return this.packagesKey;
    }

    void setPackages(TreeSet<String> packages) {
        this.packages = packages;
        this.packagesKey = MarshalServiceRuntimeDescriptionImpl.getObjectIdentity(packages);
    }

    @Override
    public AnnotationDesc getAnnotationDesc(Class cls) {
        String className;
        AnnotationDesc aDesc;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAnnotationDesc for class " + String.valueOf(cls)));
        }
        if ((aDesc = this.annotationMap.get(className = cls.getCanonicalName())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"creating AnnotationDesc");
            }
            aDesc = AnnotationDescImpl.create(cls);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAnnotationDesc is " + String.valueOf(aDesc)));
        }
        return aDesc;
    }

    @Override
    public AnnotationDesc getAnnotationDesc(String clsName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAnnotationDesc for " + clsName));
        }
        AnnotationDesc aDesc = this.annotationMap.get(clsName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAnnotationDesc is " + String.valueOf(aDesc)));
        }
        return aDesc;
    }

    void setAnnotationMap(Map<String, AnnotationDesc> map) {
        this.annotationMap = map;
    }

    @Override
    public Map<String, PropertyDescriptorPlus> getPropertyDescriptorMap(Class cls) {
        Map<String, PropertyDescriptorPlus> pdMap = this.pdMapCache.get(cls);
        if (pdMap != null) {
            return pdMap;
        }
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(cls);
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException((Throwable)t);
        }
        return pdMap;
    }

    void setPropertyDescriptorMapCache(Map<Class, Map<String, PropertyDescriptorPlus>> cache) {
        this.pdMapCache = cache;
    }

    @Override
    public String getRequestWrapperClassName(OperationDescription operationDesc) {
        return this.requestWrapperMap.get(operationDesc);
    }

    void setRequestWrapperMap(Map<OperationDescription, String> map) {
        this.requestWrapperMap = map;
    }

    @Override
    public String getResponseWrapperClassName(OperationDescription operationDesc) {
        return this.responseWrapperMap.get(operationDesc);
    }

    void setResponseWrapperMap(Map<OperationDescription, String> map) {
        this.responseWrapperMap = map;
    }

    @Override
    public FaultBeanDesc getFaultBeanDesc(FaultDescription faultDesc) {
        return this.faultBeanDescMap.get(faultDesc);
    }

    void setFaultBeanDescMap(Map<FaultDescription, FaultBeanDesc> map) {
        this.faultBeanDescMap = map;
    }

    @Override
    public Method getMethod(OperationDescription operationDesc) {
        return this.methodMap.get(operationDesc);
    }

    void setMethodMap(Map<OperationDescription, Method> map) {
        this.methodMap = map;
    }

    public String toString() {
        try {
            String newline = "\n";
            String sameline = " ";
            StringBuffer string = new StringBuffer();
            string.append("\n");
            string.append("  MarshalServiceRuntime:" + this.getKey());
            string.append("\n");
            String pkgs = this.getPackages() == null ? "none" : this.getPackages().toString();
            string.append("    Packages = " + pkgs);
            for (Map.Entry<String, AnnotationDesc> entry : this.annotationMap.entrySet()) {
                string.append("\n");
                string.append("    AnnotationDesc cached for:" + entry.getKey());
                string.append(entry.getValue().toString());
            }
            for (Map.Entry<Object, Object> entry : this.pdMapCache.entrySet()) {
                string.append("\n");
                string.append("    PropertyDescriptorPlus Map cached for:" + ((Class)entry.getKey()).getCanonicalName());
                for (PropertyDescriptorPlus pdp : ((Map)entry.getValue()).values()) {
                    string.append("\n");
                    string.append("      propertyName   =" + pdp.getPropertyName());
                    string.append("\n");
                    string.append("        xmlName      =" + pdp.getXmlName());
                    string.append("\n");
                    string.append("        propertyType =" + pdp.getPropertyType().getCanonicalName());
                    string.append("\n");
                }
            }
            string.append("    RequestWrappers");
            for (Map.Entry<Object, Object> entry : this.requestWrapperMap.entrySet()) {
                string.append("\n");
                string.append("    Operation:" + ((OperationDescription)entry.getKey()).getJavaMethodName() + " RequestWrapper:" + (String)entry.getValue());
            }
            string.append("    ResponseWrappers");
            for (Map.Entry<Object, Object> entry : this.responseWrapperMap.entrySet()) {
                string.append("\n");
                string.append("    Operation:" + ((OperationDescription)entry.getKey()).getJavaMethodName() + " ResponseWrapper:" + (String)entry.getValue());
            }
            string.append("    FaultBeanDesc");
            for (Map.Entry<Object, Object> entry : this.faultBeanDescMap.entrySet()) {
                string.append("\n");
                string.append("    FaultException:" + ((FaultDescription)entry.getKey()).getExceptionClassName());
                string.append("\n");
                string.append(((FaultBeanDesc)entry.getValue()).toString());
            }
            string.append("    Methods");
            for (Map.Entry<Object, Object> entry : this.methodMap.entrySet()) {
                string.append("\n");
                string.append("    Method Name:" + ((OperationDescription)entry.getKey()).getJavaMethodName() + " Method:" + ((Method)entry.getValue()).toString());
            }
            return string.toString();
        }
        catch (Throwable t) {
            return "An error occured while dumping the debug contents of MarshalServiceRuntimeDescriptionImpl:" + t.toString();
        }
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    private static String getObjectIdentity(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }
}

