/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIndexedSet<T>
extends AbstractSet<T>
implements Set<T> {
    private HashSet<T> set = new HashSet();
    private HashMap<Class<? extends T>, T> index = new HashMap();

    @Override
    public boolean add(T o) {
        return this.add(o, false);
    }

    public boolean add(T o, boolean replace) throws NullPointerException, IllegalArgumentException {
        if (o == null) {
            throw new NullPointerException("Null elements are not allowed");
        }
        boolean replacing = false;
        Class<T> indexClass = this.getIndexClass(o);
        T existing = this.get(indexClass);
        if (existing != null) {
            replacing = true;
            if (replace) {
                this.remove(existing);
            } else {
                throw new IllegalArgumentException("Set already contains a member of index class " + indexClass.getName());
            }
        }
        this.index.put(indexClass, o);
        this.set.add(o);
        return replacing;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.index.clear();
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.contains(o)) {
            this.removeFromIndex(o);
            this.set.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new ClassIndexedSetIterator(this, this.set.iterator());
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public boolean contains(Class<? extends T> clazz) {
        return this.get(clazz) != null;
    }

    public <X extends T> X get(Class<X> clazz) {
        return (X)this.index.get(clazz);
    }

    protected Class<? extends T> getIndexClass(Object o) {
        return o.getClass();
    }

    private void removeFromIndex(T o) {
        this.index.remove(this.getIndexClass(o));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassIndexedSetIterator
    implements Iterator<T> {
        private ClassIndexedSet<T> set;
        private Iterator<T> iterator;
        private boolean nextCalled;
        private boolean removeStateValid;
        private T current;

        protected ClassIndexedSetIterator(ClassIndexedSet<T> parentSet, Iterator<T> parentIterator) {
            this.set = parentSet;
            this.iterator = parentIterator;
            this.current = null;
            this.nextCalled = false;
            this.removeStateValid = false;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.current = this.iterator.next();
            this.nextCalled = true;
            this.removeStateValid = true;
            return this.current;
        }

        @Override
        public void remove() {
            if (!this.nextCalled) {
                throw new IllegalStateException("remove() was called before calling next()");
            }
            if (!this.removeStateValid) {
                throw new IllegalStateException("remove() has already been called since the last call to next()");
            }
            this.iterator.remove();
            this.set.removeFromIndex(this.current);
            this.removeStateValid = false;
        }
    }
}

