/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.callback.CallbackLookup;
import org.apache.wss4j.dom.callback.DOMCallbackLookup;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.soap.wssecurity.KeyIdentifier;
import org.opensaml.soap.wssecurity.impl.SecurityTokenReferenceBuilder;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommonUtil {
    private static Log log = LogFactory.getLog(CommonUtil.class);

    public static Document getOMDOMDocument() throws TrustException {
        DOMMetaFactory metaFactory = (DOMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom");
        DocumentBuilderFactory dbf = metaFactory.newDocumentBuilderFactory();
        try {
            return dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new TrustException("Error creating Axiom compatible DOM Document", e);
        }
    }

    public static java.security.cert.X509Certificate getCertificateByAlias(Crypto crypto, String alias) throws TrustException {
        java.security.cert.X509Certificate[] certificates = CommonUtil.getCertificatesByAlias(crypto, alias);
        if (certificates == null) {
            log.error((Object)("Unable to retrieve certificate for alias " + alias));
            throw new TrustException("issuerCertificateNotFound");
        }
        return certificates[0];
    }

    public static java.security.cert.X509Certificate[] getCertificatesByAlias(Crypto crypto, String alias) throws TrustException {
        CryptoType type = new CryptoType(CryptoType.TYPE.ALIAS);
        type.setAlias(alias);
        try {
            java.security.cert.X509Certificate[] certificates = crypto.getX509Certificates(type);
            if (certificates == null) {
                log.debug((Object)("Unable to retrieve certificate for alias " + alias));
                return new java.security.cert.X509Certificate[0];
            }
            return certificates;
        }
        catch (WSSecurityException e) {
            log.error((Object)("Unable to retrieve certificate for alias " + alias), (Throwable)e);
            throw new TrustException("issuerCertificateNotFound", e);
        }
    }

    public static byte[] getDecryptedBytes(CallbackHandler callbackHandler, Crypto crypto, Node encryptedKeyElement, RequestData requestData) throws WSSecurityException {
        EncryptedKeyProcessor encryptedKeyProcessor = new EncryptedKeyProcessor();
        requestData.setCallbackHandler(callbackHandler);
        requestData.setDecCrypto(crypto);
        WSSConfig cfg = WSSConfig.getNewInstance();
        requestData.setWssConfig(cfg);
        WSDocInfo docInfo = new WSDocInfo(encryptedKeyElement.getOwnerDocument());
        docInfo.setCallbackLookup((CallbackLookup)new DOMCallbackLookup(encryptedKeyElement.getOwnerDocument()));
        requestData.setWsDocInfo(docInfo);
        List resultList = encryptedKeyProcessor.handleToken((Element)encryptedKeyElement, requestData);
        WSSecurityEngineResult wsSecurityEngineResult = (WSSecurityEngineResult)resultList.get(0);
        return (byte[])wsSecurityEngineResult.get((Object)"secret");
    }

    @Deprecated
    public static byte[] getDecryptedBytes(CallbackHandler callbackHandler, Crypto crypto, Node encryptedKeyElement) throws WSSecurityException {
        EncryptedKeyProcessor encryptedKeyProcessor = new EncryptedKeyProcessor();
        RequestData requestData = new RequestData();
        requestData.setCallbackHandler(callbackHandler);
        requestData.setDecCrypto(crypto);
        WSSConfig cfg = WSSConfig.getNewInstance();
        requestData.setWssConfig(cfg);
        WSDocInfo docInfo = new WSDocInfo(encryptedKeyElement.getOwnerDocument());
        docInfo.setCallbackLookup((CallbackLookup)new DOMCallbackLookup(encryptedKeyElement.getOwnerDocument()));
        requestData.setWsDocInfo(docInfo);
        List resultList = encryptedKeyProcessor.handleToken((Element)encryptedKeyElement, requestData);
        WSSecurityEngineResult wsSecurityEngineResult = (WSSecurityEngineResult)resultList.get(0);
        return (byte[])wsSecurityEngineResult.get((Object)"secret");
    }

    public static Crypto getCrypto(Properties properties, ClassLoader classLoader) throws TrustException {
        try {
            return CryptoFactory.getInstance((Properties)properties, (ClassLoader)classLoader, null);
        }
        catch (WSSecurityException e) {
            log.error((Object)"An error occurred while loading crypto properties", (Throwable)e);
            throw new TrustException("errorLoadingCryptoProperties", e);
        }
    }

    public static Crypto getCrypto(String propertiesFile, ClassLoader classLoader) throws TrustException {
        try {
            return CryptoFactory.getInstance((String)propertiesFile, (ClassLoader)classLoader);
        }
        catch (WSSecurityException e) {
            log.error((Object)("An error occurred while loading crypto properties with property file " + propertiesFile), (Throwable)e);
            throw new TrustException("errorLoadingCryptoProperties", new Object[]{propertiesFile}, e);
        }
    }

    public static SAMLTokenIssuerConfig getTokenIssuerConfiguration(OMElement configElement, String configFile, Parameter messageContextParameter) throws TrustException {
        SAMLTokenIssuerConfig tokenIssuerConfiguration = CommonUtil.createTokenIssuerConfiguration(configElement);
        if (tokenIssuerConfiguration == null) {
            tokenIssuerConfiguration = CommonUtil.createTokenIssuerConfiguration(configFile);
            if (tokenIssuerConfiguration == null) {
                if (messageContextParameter != null) {
                    tokenIssuerConfiguration = CommonUtil.createTokenIssuerConfiguration(messageContextParameter);
                }
                return tokenIssuerConfiguration;
            }
            return tokenIssuerConfiguration;
        }
        return tokenIssuerConfiguration;
    }

    protected static SAMLTokenIssuerConfig createTokenIssuerConfiguration(OMElement configElement) throws TrustException {
        if (configElement != null) {
            log.debug((Object)"Creating token issuer configuration using OMElement");
            return new SAMLTokenIssuerConfig(configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        return null;
    }

    protected static SAMLTokenIssuerConfig createTokenIssuerConfiguration(String configFile) throws TrustException {
        if (configFile != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating token issuer configuration using file " + configFile));
            }
            return new SAMLTokenIssuerConfig(configFile);
        }
        return null;
    }

    protected static SAMLTokenIssuerConfig createTokenIssuerConfiguration(Parameter messageContextParameter) throws TrustException {
        if (messageContextParameter != null && messageContextParameter.getParameterElement() != null) {
            log.debug((Object)"Creating token issuer configuration using the config parameter");
            return new SAMLTokenIssuerConfig(messageContextParameter.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        return null;
    }

    public static XMLObject buildXMLObject(QName objectQName) throws TrustException {
        XMLObjectBuilder builder;
        log.debug((Object)("buildXMLObject() is starting on QName: " + objectQName));
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        if (builderFactory.getBuilder(objectQName) == null) {
            if (KeyIdentifier.ELEMENT_NAME == objectQName) {
                builderFactory.registerBuilder(KeyIdentifier.ELEMENT_NAME, (XMLObjectBuilder)new SecurityTokenReferenceBuilder());
                log.warn((Object)("An opensaml SecurityTokenReferenceBuilder was added to the opensaml registry for QName key: " + KeyIdentifier.ELEMENT_NAME));
            } else {
                log.error((Object)("No opensaml builders found for QName key: " + objectQName));
            }
        }
        if ((builder = builderFactory.getBuilderOrThrow(objectQName)) == null) {
            log.error((Object)("Unable to find OpenSAML builder for object " + objectQName));
            throw new TrustException("builderNotFound", new Object[]{objectQName});
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static KeyInfo getSymmetricKeyBasedKeyInfo(Document doc, RahasData data, java.security.cert.X509Certificate serviceCert, int keySize, Crypto crypto, int keyComputation) throws WSSecurityException, TrustException {
        byte[] ephemeralKey = TokenIssuerUtil.getSharedSecret(data, keyComputation, keySize);
        WSSecEncryptedKey encryptedKey = CommonUtil.getSymmetricKeyBasedKeyInfoContent(doc, ephemeralKey, serviceCert, crypto);
        byte[] tempKey = new byte[keySize / 8];
        System.arraycopy(ephemeralKey, 0, tempKey, 0, keySize / 8);
        data.setEphmeralKey(tempKey);
        EncryptedKey samlEncryptedKey = SAMLUtils.createEncryptedKey(serviceCert, encryptedKey);
        return SAMLUtils.createKeyInfo(samlEncryptedKey);
    }

    static WSSecEncryptedKey getSymmetricKeyBasedKeyInfoContent(Document doc, byte[] ephemeralKey, java.security.cert.X509Certificate serviceCert, Crypto crypto) throws WSSecurityException, TrustException {
        WSSecEncryptedKey encryptedKeyBuilder = new WSSecEncryptedKey(doc);
        encryptedKeyBuilder.setKeyIdentifierType(2);
        encryptedKeyBuilder.setUseThisCert(serviceCert);
        encryptedKeyBuilder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encryptedKeyBuilder.prepare(crypto, symmetricKey);
        return encryptedKeyBuilder;
    }

    public static KeyInfo getCertificateBasedKeyInfo(java.security.cert.X509Certificate certificate) throws TrustException {
        X509Data x509Data = CommonUtil.createX509Data(certificate);
        return SAMLUtils.createKeyInfo(x509Data);
    }

    static X509Data createX509Data(java.security.cert.X509Certificate clientCert) throws TrustException {
        byte[] clientCertBytes;
        try {
            clientCertBytes = clientCert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            log.error((Object)"An error occurred while encoding certificate.", (Throwable)e);
            throw new TrustException("An error occurred while encoding certificate.", e);
        }
        String base64Cert = new String(Base64.getEncoder().encode(clientCertBytes));
        X509Certificate x509Certificate = (X509Certificate)CommonUtil.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        x509Certificate.setValue(base64Cert);
        X509Data x509Data = (X509Data)CommonUtil.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
        x509Data.getX509Certificates().add(x509Certificate);
        return x509Data;
    }

    public static SAMLCallbackHandler getSAMLCallbackHandler(SAMLTokenIssuerConfig tokenIssuerConfiguration, RahasData data) throws TrustException {
        if (tokenIssuerConfiguration.getCallbackHandler() != null) {
            return tokenIssuerConfiguration.getCallbackHandler();
        }
        if (tokenIssuerConfiguration.getCallbackHandlerName() != null && tokenIssuerConfiguration.getCallbackHandlerName().trim().length() > 0) {
            SAMLCallbackHandler handler;
            Class cbClass;
            MessageContext msgContext = data.getInMessageContext();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)tokenIssuerConfiguration.getCallbackHandlerName());
            }
            catch (ClassNotFoundException e) {
                throw new TrustException("cannotLoadPWCBClass", new String[]{tokenIssuerConfiguration.getCallbackHandlerName()}, e);
            }
            try {
                handler = (SAMLCallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new TrustException("cannotCreatePWCBInstance", new String[]{tokenIssuerConfiguration.getCallbackHandlerName()}, e);
            }
            return handler;
        }
        return null;
    }
}

