/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.AbstractContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.util.LoggingControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class InMemoryBeanMgr<T extends RMBean> {
    private static final Log log = LogFactory.getLog(InMemoryBeanMgr.class);
    protected ConcurrentHashMap<String, T> table;
    protected InMemoryStorageManager mgr;

    protected InMemoryBeanMgr(InMemoryStorageManager mgr, AbstractContext context, String key) {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " <innit> " + mgr + ", " + context + ", " + key));
        }
        this.mgr = mgr;
        Object obj = context.getProperty(key);
        if (obj != null) {
            this.table = (ConcurrentHashMap)obj;
        } else {
            this.table = new ConcurrentHashMap();
            context.setProperty(key, this.table);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " <init> " + this));
        }
    }

    protected boolean insert(String key, T bean) throws SandeshaStorageException {
        boolean wasInserted;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " insert " + key + ", " + bean));
        }
        this.mgr.enlistBean((RMBean)bean);
        T oldValue = this.table.putIfAbsent(key, bean);
        boolean bl = wasInserted = oldValue == null;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " insert " + wasInserted));
        }
        return wasInserted;
    }

    protected T delete(Object key) throws SandeshaStorageException {
        RMBean bean;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " delete " + key));
        }
        if ((bean = (RMBean)this.table.remove(key)) != null) {
            this.mgr.enlistBean(bean);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " delete " + bean));
        }
        return (T)bean;
    }

    protected T retrieve(Object key) throws SandeshaStorageException {
        RMBean bean;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " retrieve " + key));
        }
        if ((bean = (RMBean)this.table.get(key)) != null) {
            this.mgr.enlistBean(bean);
            bean = (RMBean)this.table.get(key);
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " retrieve " + bean));
        }
        return (T)bean;
    }

    protected boolean update(String key, T bean) throws SandeshaStorageException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " update " + key + ", " + bean));
        }
        this.mgr.enlistBean((RMBean)bean);
        RMBean oldBean = (RMBean)this.table.put(key, bean);
        if (oldBean == null) {
            return false;
        }
        this.mgr.enlistBean(oldBean);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " update " + true));
        }
        return true;
    }

    protected List<T> find(T matchInfo) throws SandeshaStorageException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " find " + matchInfo));
        }
        ArrayList<Object> beans = new ArrayList<Object>();
        if (matchInfo == null) {
            beans.addAll(this.table.values());
        } else {
            for (Map.Entry<String, T> e : this.table.entrySet()) {
                RMBean candidate = (RMBean)e.getValue();
                if (!candidate.match((RMBean)matchInfo)) continue;
                this.mgr.enlistBean(candidate);
                if (!candidate.equals(this.table.get(e.getKey()))) continue;
                beans.add(candidate);
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " find " + beans));
        }
        return beans;
    }

    protected List<T> findNoLock(T matchInfo) throws SandeshaStorageException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " find " + matchInfo));
        }
        ArrayList<Object> beans = new ArrayList<Object>();
        if (matchInfo == null) {
            beans.addAll(this.table.values());
        } else {
            for (Map.Entry<String, T> e : this.table.entrySet()) {
                RMBean candidate = (RMBean)e.getValue();
                if (!candidate.match((RMBean)matchInfo)) continue;
                beans.add(candidate);
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " find " + beans));
        }
        return beans;
    }

    protected T findUnique(T matchInfo) throws SandeshaStorageException {
        T result;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryBeanMgr " + this.getClass() + " findUnique " + matchInfo));
        }
        if ((result = this.findUniqueNoLock((RMBean)matchInfo)) != null) {
            this.mgr.enlistBean((RMBean)result);
            if (!this.table.containsValue(result)) {
                result = null;
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryBeanMgr " + this.getClass() + " findUnique " + result));
        }
        return result;
    }

    protected T findUniqueNoLock(RMBean matchInfo) throws SandeshaStorageException {
        RMBean result = null;
        for (RMBean candidate : this.table.values()) {
            if (!candidate.match(matchInfo)) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), candidate.toString());
            SandeshaStorageException e = new SandeshaStorageException(message);
            log.error((Object)message, (Throwable)((Object)e));
            throw e;
        }
        return (T)result;
    }
}

