/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.RMHeaderPart;

public class AckRequested
implements RMHeaderPart {
    private Identifier identifier;
    private String namespaceValue = null;
    private boolean mustUnderstand = false;
    private OMNamespace omNamespace = null;
    private OMElement originalAckRequestedElement;

    public AckRequested(String namespaceValue) {
        this.namespaceValue = namespaceValue;
        this.omNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceValue) ? Sandesha2Constants.SPEC_2005_02.OM_NS_URI : Sandesha2Constants.SPEC_2007_02.OM_NS_URI;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromHeaderBlock(SOAPHeaderBlock ackReqElement) throws OMException, SandeshaException {
        this.originalAckRequestedElement = ackReqElement;
        this.identifier = new Identifier(this.namespaceValue);
        OMElement identifierPart = ackReqElement.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
        if (identifierPart != null) {
            this.identifier.fromOMElement(identifierPart);
        }
        ackReqElement.setProcessed();
        return this;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public OMElement getOriginalAckRequestedElement() {
        return this.originalAckRequestedElement;
    }

    public void toHeader(SOAPHeader header) {
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("ackRequestNullID"));
        }
        SOAPHeaderBlock ackReqHdrBlock = header.addHeaderBlock("AckRequested", this.omNamespace);
        ackReqHdrBlock.setMustUnderstand(this.isMustUnderstand());
        this.identifier.toOMElement((OMElement)ackReqHdrBlock, this.omNamespace);
    }
}

