/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.metadata;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.bookkeeper.api.kv.options.Options;
import org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.Bytes;
import org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.bookkeeper.stream.proto.NamespaceMetadata;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamName;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.CreateNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.CreateNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.GetStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;
import org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.bookkeeper.stream.storage.api.metadata.RootRangeStore;
import org.apache.bookkeeper.stream.storage.impl.metadata.CreateNamespaceProcessor;
import org.apache.bookkeeper.stream.storage.impl.metadata.DeleteNamespaceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootRangeStoreImpl
implements RootRangeStore {
    private static final Logger log = LoggerFactory.getLogger(RootRangeStoreImpl.class);
    private static final byte SYSTEM_TAG = -1;
    private static final byte NS_NAME_TAG = 1;
    private static final byte NS_ID_TAG = 2;
    private static final byte NS_STREAM_NAME_SEP = 3;
    private static final byte NS_STREAM_ID_SEP = 4;
    private static final byte STREAM_ID_TAG = 5;
    private static final byte NS_END_SEP = -1;
    static final byte[] NS_ID_KEY = new byte[]{-1, 110, 115, 105, 100};
    static final byte[] STREAM_ID_KEY = new byte[]{-1, 115, 116, 114, 101, 97, 109, 105, 100};
    private final MVCCAsyncStore<byte[], byte[]> store;
    private final StorageContainerPlacementPolicy placementPolicy;
    private final ScheduledExecutorService executor;

    static final byte[] getNamespaceNameKey(String nsName) {
        byte[] nsNameBytes = nsName.getBytes(StandardCharsets.UTF_8);
        byte[] nsNameKey = new byte[nsNameBytes.length + 1];
        System.arraycopy(nsNameBytes, 0, nsNameKey, 1, nsNameBytes.length);
        nsNameKey[0] = 1;
        return nsNameKey;
    }

    static final byte[] getNamespaceIdKey(long nsId) {
        byte[] nsIdBytes = new byte[9];
        nsIdBytes[0] = 2;
        Bytes.toBytes((long)nsId, (byte[])nsIdBytes, (int)1);
        return nsIdBytes;
    }

    static final byte[] getNamespaceIdEndKey(long nsId) {
        byte[] nsIdBytes = new byte[10];
        nsIdBytes[0] = 2;
        Bytes.toBytes((long)nsId, (byte[])nsIdBytes, (int)1);
        nsIdBytes[9] = -1;
        return nsIdBytes;
    }

    static final byte[] getStreamNameKey(long nsId, String streamName) {
        byte[] streamNameBytes = streamName.getBytes(StandardCharsets.UTF_8);
        byte[] streamNameKey = new byte[streamNameBytes.length + 8 + 2];
        streamNameKey[0] = 2;
        Bytes.toBytes((long)nsId, (byte[])streamNameKey, (int)1);
        streamNameKey[9] = 3;
        System.arraycopy(streamNameBytes, 0, streamNameKey, 10, streamNameBytes.length);
        return streamNameKey;
    }

    static final byte[] getStreamIdKey(long nsId, long streamId) {
        byte[] streamIdBytes = new byte[18];
        streamIdBytes[0] = 2;
        Bytes.toBytes((long)nsId, (byte[])streamIdBytes, (int)1);
        streamIdBytes[9] = 4;
        Bytes.toBytes((long)streamId, (byte[])streamIdBytes, (int)10);
        return streamIdBytes;
    }

    static final byte[] getStreamIdKey(long streamId) {
        byte[] streamIdBytes = new byte[9];
        streamIdBytes[0] = 5;
        Bytes.toBytes((long)streamId, (byte[])streamIdBytes, (int)1);
        return streamIdBytes;
    }

    public RootRangeStoreImpl(MVCCAsyncStore<byte[], byte[]> store, StorageContainerPlacementPolicy placementPolicy, ScheduledExecutorService executor) {
        this.store = store;
        this.placementPolicy = placementPolicy;
        this.executor = executor;
    }

    CompletableFuture<KeyValue<byte[], byte[]>> getValue(byte[] key) {
        RangeOp op = this.store.getOpFactory().newRange((Object)key, Options.get());
        return ((CompletableFuture)this.store.range(op).thenApplyAsync(kvs -> {
            try {
                if (kvs.count() <= 0L) {
                    KeyValue keyValue = null;
                    return keyValue;
                }
                KeyValue keyValue = (KeyValue)kvs.getKvsAndClear().get(0);
                return keyValue;
            }
            finally {
                kvs.close();
            }
        })).whenComplete((kv, cause) -> op.close());
    }

    public CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest request) {
        if (log.isTraceEnabled()) {
            log.trace("Received CreateNamespace request : {}", (Object)request);
        }
        return CreateNamespaceProcessor.of().process(this, request, this.executor);
    }

    StatusCode verifyCreateNamespaceRequest(CreateNamespaceRequest request) {
        String colName = request.getName();
        StatusCode code = StatusCode.SUCCESS;
        if (!ProtoUtils.validateNamespaceName((String)colName)) {
            log.error("Failed to create namespace due to invalid namespace name {}", (Object)colName);
            code = StatusCode.INVALID_NAMESPACE_NAME;
        }
        return code;
    }

    CompletableFuture<CreateNamespaceResponse> doProcessCreateNamespaceRequest(CreateNamespaceRequest request) {
        return this.getValue(NS_ID_KEY).thenCompose(nsIdKv -> {
            long currentNsIdRev;
            long currentNsId;
            if (null == nsIdKv) {
                currentNsId = -1L;
                currentNsIdRev = -1L;
            } else {
                currentNsId = Bytes.toLong((byte[])((byte[])nsIdKv.value()), (int)0);
                currentNsIdRev = nsIdKv.modifiedRevision();
                nsIdKv.close();
            }
            return this.executeCreateNamespaceTxn(currentNsId, currentNsIdRev, request);
        });
    }

    private CompletableFuture<CreateNamespaceResponse> executeCreateNamespaceTxn(long currentNsId, long currentNsIdRev, CreateNamespaceRequest request) {
        long namespaceId = currentNsId + 1L;
        String nsName = request.getName();
        NamespaceMetadata metadata = NamespaceMetadata.newBuilder().setProps(NamespaceProperties.newBuilder().setNamespaceId(namespaceId).setNamespaceName(nsName).setDefaultStreamConf(request.getNsConf().getDefaultStreamConf())).build();
        byte[] nsNameKey = RootRangeStoreImpl.getNamespaceNameKey(nsName);
        byte[] nsNameVal = Bytes.toBytes((long)namespaceId);
        byte[] nsIdKey = RootRangeStoreImpl.getNamespaceIdKey(namespaceId);
        byte[] nsIdVal = metadata.toByteArray();
        TxnOp txn = this.store.newTxn().If(new CompareOp[]{this.store.newCompareValue(CompareResult.EQUAL, (Object)nsNameKey, null), currentNsIdRev < 0L ? this.store.newCompareValue(CompareResult.EQUAL, (Object)NS_ID_KEY, null) : this.store.newCompareModRevision(CompareResult.EQUAL, (Object)NS_ID_KEY, currentNsIdRev)}).Then(new Op[]{this.store.newPut((Object)nsNameKey, (Object)nsNameVal), this.store.newPut((Object)nsIdKey, (Object)nsIdVal), this.store.newPut((Object)NS_ID_KEY, (Object)Bytes.toBytes((long)namespaceId))}).build();
        return ((CompletableFuture)this.store.txn(txn).thenApply(txnResult -> {
            try {
                CreateNamespaceResponse.Builder respBuilder = CreateNamespaceResponse.newBuilder();
                if (txnResult.isSuccess()) {
                    respBuilder.setCode(StatusCode.SUCCESS);
                    respBuilder.setNsProps(metadata.getProps());
                } else {
                    respBuilder.setCode(StatusCode.INTERNAL_SERVER_ERROR);
                }
                CreateNamespaceResponse createNamespaceResponse = respBuilder.build();
                return createNamespaceResponse;
            }
            finally {
                txnResult.close();
            }
        })).whenComplete((resp, cause) -> txn.close());
    }

    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest request) {
        return DeleteNamespaceProcessor.of().process(this, request, this.executor);
    }

    StatusCode verifyDeleteNamespaceRequest(DeleteNamespaceRequest request) {
        String colName = request.getName();
        StatusCode code = StatusCode.SUCCESS;
        if (!ProtoUtils.validateNamespaceName((String)colName)) {
            log.error("Failed to delete namespace due to invalid namespace name {}", (Object)colName);
            code = StatusCode.INVALID_NAMESPACE_NAME;
        }
        return code;
    }

    CompletableFuture<DeleteNamespaceResponse> doProcessDeleteNamespaceRequest(DeleteNamespaceRequest request) {
        String nsName = request.getName();
        return this.getNamespace(nsName).thenCompose(nsMetadata -> this.deleteNamespace(nsName, (NamespaceMetadata)nsMetadata));
    }

    CompletableFuture<DeleteNamespaceResponse> deleteNamespace(String nsName, NamespaceMetadata nsMetadata) {
        if (null == nsMetadata) {
            return FutureUtils.value((Object)DeleteNamespaceResponse.newBuilder().setCode(StatusCode.NAMESPACE_NOT_FOUND).build());
        }
        byte[] nsNameKey = RootRangeStoreImpl.getNamespaceNameKey(nsName);
        byte[] nsIdKey = RootRangeStoreImpl.getNamespaceIdKey(nsMetadata.getProps().getNamespaceId());
        byte[] nsIdEndKey = RootRangeStoreImpl.getNamespaceIdEndKey(nsMetadata.getProps().getNamespaceId());
        TxnOp txnOp = this.store.newTxn().If(new CompareOp[]{this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)nsNameKey, null), this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)nsIdKey, null)}).Then(new Op[]{this.store.newDelete((Object)nsNameKey), this.store.newDeleteRange((Object)nsIdKey, (Object)nsIdEndKey)}).build();
        return ((CompletableFuture)this.store.txn(txnOp).thenApply(txnResult -> {
            try {
                DeleteNamespaceResponse.Builder respBuilder = DeleteNamespaceResponse.newBuilder();
                if (txnResult.isSuccess()) {
                    respBuilder.setCode(StatusCode.SUCCESS);
                } else {
                    respBuilder.setCode(StatusCode.INTERNAL_SERVER_ERROR);
                }
                DeleteNamespaceResponse deleteNamespaceResponse = respBuilder.build();
                return deleteNamespaceResponse;
            }
            finally {
                txnResult.close();
            }
        })).whenComplete((resp, cause) -> txnOp.close());
    }

    public CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest request) {
        String nsName = request.getName();
        if (!ProtoUtils.validateNamespaceName((String)nsName)) {
            log.error("Failed to get namespace due to invalid namespace name {}", (Object)nsName);
            return FutureUtils.value((Object)GetNamespaceResponse.newBuilder().setCode(StatusCode.INVALID_NAMESPACE_NAME).build());
        }
        return this.getNamespace(request.getName()).thenApply(nsMetadata -> {
            GetNamespaceResponse.Builder nsRespBuilder = GetNamespaceResponse.newBuilder();
            if (null == nsMetadata) {
                nsRespBuilder.setCode(StatusCode.NAMESPACE_NOT_FOUND);
            } else {
                nsRespBuilder.setCode(StatusCode.SUCCESS);
                nsRespBuilder.setNsProps(nsMetadata.getProps());
            }
            return nsRespBuilder.build();
        });
    }

    private CompletableFuture<NamespaceMetadata> getNamespace(long nsId) {
        byte[] nsIdKey = RootRangeStoreImpl.getNamespaceIdKey(nsId);
        return this.store.get((Object)nsIdKey).thenCompose(nsIdVal -> {
            try {
                return FutureUtils.value((Object)(null != nsIdVal ? NamespaceMetadata.parseFrom((byte[])nsIdVal) : null));
            }
            catch (InvalidProtocolBufferException e) {
                return FutureUtils.exception((Throwable)e);
            }
        });
    }

    private CompletableFuture<NamespaceMetadata> getNamespace(String nsName) {
        byte[] nsNameKey = RootRangeStoreImpl.getNamespaceNameKey(nsName);
        return this.store.get((Object)nsNameKey).thenCompose(nsIdBytes -> {
            if (null == nsIdBytes) {
                return FutureUtils.value(null);
            }
            long nsId = Bytes.toLong((byte[])nsIdBytes, (int)0);
            return this.getNamespace(nsId);
        });
    }

    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest request) {
        String streamName = request.getName();
        String nsName = request.getNsName();
        StatusCode code = this.verifyStreamRequest(nsName, streamName);
        if (StatusCode.SUCCESS != code) {
            return FutureUtils.value((Object)CreateStreamResponse.newBuilder().setCode(code).build());
        }
        return this.createStream(nsName, streamName, request.getStreamConf());
    }

    StatusCode verifyStreamRequest(String nsName, String streamName) {
        StatusCode code = StatusCode.SUCCESS;
        if (!ProtoUtils.validateNamespaceName((String)nsName)) {
            log.error("Invalid namespace name {}", (Object)nsName);
            code = StatusCode.INVALID_NAMESPACE_NAME;
        } else if (!ProtoUtils.validateStreamName((String)streamName)) {
            log.error("Invalid stream name {}", (Object)streamName);
            code = StatusCode.INVALID_STREAM_NAME;
        }
        return code;
    }

    private CompletableFuture<CreateStreamResponse> createStream(String nsName, String streamName, StreamConfiguration streamConf) {
        return ((CompletableFuture)this.getNamespace(nsName).thenCompose(nsMetadata -> this.createStream((NamespaceMetadata)nsMetadata, streamName, streamConf))).exceptionally(cause -> CreateStreamResponse.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).build());
    }

    private CompletableFuture<CreateStreamResponse> createStream(NamespaceMetadata nsMetadata, String streamName, StreamConfiguration streamConf) {
        if (null == nsMetadata) {
            return FutureUtils.value((Object)CreateStreamResponse.newBuilder().setCode(StatusCode.NAMESPACE_NOT_FOUND).build());
        }
        return this.getValue(STREAM_ID_KEY).thenCompose(streamIdKv -> {
            long currentStreamId = -1L;
            long currentStreamIdRev = -1L;
            if (null != streamIdKv) {
                currentStreamId = Bytes.toLong((byte[])((byte[])streamIdKv.value()), (int)0);
                currentStreamIdRev = streamIdKv.modifiedRevision();
                streamIdKv.close();
            }
            return this.executeCreateStreamTxn(nsMetadata.getProps().getNamespaceId(), streamName, streamConf, currentStreamId, currentStreamIdRev);
        });
    }

    private CompletableFuture<CreateStreamResponse> executeCreateStreamTxn(long nsId, String streamName, StreamConfiguration streamConf, long currentStreamId, long currentStreamIdRev) {
        long streamId = currentStreamId < 0L ? 1024L : currentStreamId + 1L;
        long scId = this.placementPolicy.placeStreamRange(streamId, 0L);
        StreamProperties streamProps = StreamProperties.newBuilder().setStreamId(streamId).setStreamName(streamName).setStorageContainerId(scId).setStreamConf(streamConf).build();
        byte[] nsIdKey = RootRangeStoreImpl.getNamespaceIdKey(nsId);
        byte[] streamNameKey = RootRangeStoreImpl.getStreamNameKey(nsId, streamName);
        byte[] streamNameVal = Bytes.toBytes((long)streamId);
        byte[] streamIdKey = RootRangeStoreImpl.getStreamIdKey(nsId, streamId);
        byte[] streamIdVal = streamProps.toByteArray();
        byte[] streamReverseIndexKey = RootRangeStoreImpl.getStreamIdKey(streamId);
        byte[] streamReverseIndexValue = Bytes.toBytes((long)nsId);
        TxnOp txn = this.store.newTxn().If(new CompareOp[]{this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)nsIdKey, null), currentStreamIdRev < 0L ? this.store.newCompareValue(CompareResult.EQUAL, (Object)STREAM_ID_KEY, null) : this.store.newCompareModRevision(CompareResult.EQUAL, (Object)STREAM_ID_KEY, currentStreamIdRev), this.store.newCompareValue(CompareResult.EQUAL, (Object)streamNameKey, null)}).Then(new Op[]{this.store.newPut((Object)streamNameKey, (Object)streamNameVal), this.store.newPut((Object)streamIdKey, (Object)streamIdVal), this.store.newPut((Object)streamReverseIndexKey, (Object)streamReverseIndexValue), this.store.newPut((Object)STREAM_ID_KEY, (Object)Bytes.toBytes((long)streamId))}).build();
        return ((CompletableFuture)this.store.txn(txn).thenApply(txnResult -> {
            try {
                CreateStreamResponse.Builder respBuilder = CreateStreamResponse.newBuilder();
                if (txnResult.isSuccess()) {
                    respBuilder.setCode(StatusCode.SUCCESS);
                    respBuilder.setStreamProps(streamProps);
                } else {
                    respBuilder.setCode(StatusCode.INTERNAL_SERVER_ERROR);
                }
                CreateStreamResponse createStreamResponse = respBuilder.build();
                return createStreamResponse;
            }
            finally {
                txnResult.close();
                txn.close();
            }
        })).exceptionally(cause -> {
            txn.close();
            return CreateStreamResponse.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).build();
        });
    }

    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest request) {
        String streamName = request.getName();
        String nsName = request.getNsName();
        StatusCode code = this.verifyStreamRequest(nsName, streamName);
        if (StatusCode.SUCCESS != code) {
            return FutureUtils.value((Object)DeleteStreamResponse.newBuilder().setCode(code).build());
        }
        return this.deleteStream(nsName, streamName);
    }

    private CompletableFuture<DeleteStreamResponse> deleteStream(String nsName, String streamName) {
        return this.getNamespace(nsName).thenCompose(nsMetadata -> this.deleteStream((NamespaceMetadata)nsMetadata, streamName));
    }

    private CompletableFuture<DeleteStreamResponse> deleteStream(NamespaceMetadata nsMetadata, String streamName) {
        if (null == nsMetadata) {
            return FutureUtils.value((Object)DeleteStreamResponse.newBuilder().setCode(StatusCode.NAMESPACE_NOT_FOUND).build());
        }
        long nsId = nsMetadata.getProps().getNamespaceId();
        byte[] streamNameKey = RootRangeStoreImpl.getStreamNameKey(nsId, streamName);
        return this.store.get((Object)streamNameKey).thenCompose(streamIdBytes -> {
            if (null == streamIdBytes) {
                return FutureUtils.value((Object)DeleteStreamResponse.newBuilder().setCode(StatusCode.STREAM_NOT_FOUND).build());
            }
            long streamId = Bytes.toLong((byte[])streamIdBytes, (int)0);
            return this.deleteStream(nsId, streamId, streamName);
        });
    }

    private CompletableFuture<DeleteStreamResponse> deleteStream(long nsId, long streamId, String streamName) {
        byte[] nsIdKey = RootRangeStoreImpl.getNamespaceIdKey(nsId);
        byte[] streamNameKey = RootRangeStoreImpl.getStreamNameKey(nsId, streamName);
        byte[] streamIdKey = RootRangeStoreImpl.getStreamIdKey(nsId, streamId);
        byte[] streamReverseIndexKey = RootRangeStoreImpl.getStreamIdKey(streamId);
        TxnOp txnOp = this.store.newTxn().If(new CompareOp[]{this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)nsIdKey, null), this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)streamNameKey, null), this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)streamIdKey, null), this.store.newCompareValue(CompareResult.NOT_EQUAL, (Object)streamReverseIndexKey, null)}).Then(new Op[]{this.store.newDelete((Object)streamIdKey), this.store.newDelete((Object)streamNameKey), this.store.newDelete((Object)streamReverseIndexKey)}).build();
        return ((CompletableFuture)this.store.txn(txnOp).thenApply(txnResult -> {
            try {
                DeleteStreamResponse.Builder respBuilder = DeleteStreamResponse.newBuilder();
                if (txnResult.isSuccess()) {
                    respBuilder.setCode(StatusCode.SUCCESS);
                } else {
                    respBuilder.setCode(StatusCode.INTERNAL_SERVER_ERROR);
                }
                DeleteStreamResponse deleteStreamResponse = respBuilder.build();
                return deleteStreamResponse;
            }
            finally {
                txnResult.close();
            }
        })).whenComplete((resp, cause) -> txnOp.close());
    }

    private CompletableFuture<GetStreamResponse> streamPropertiesToResponse(CompletableFuture<StreamProperties> propsFuture) {
        GetStreamResponse.Builder respBuilder = GetStreamResponse.newBuilder();
        return ((CompletableFuture)propsFuture.thenCompose(streamProps -> {
            if (null == streamProps) {
                return FutureUtils.value((Object)respBuilder.setCode(StatusCode.STREAM_NOT_FOUND).build());
            }
            return FutureUtils.value((Object)respBuilder.setCode(StatusCode.SUCCESS).setStreamProps(streamProps).build());
        })).exceptionally(cause -> respBuilder.setCode(StatusCode.INTERNAL_SERVER_ERROR).build());
    }

    public CompletableFuture<GetStreamResponse> getStream(GetStreamRequest request) {
        if (GetStreamRequest.IdCase.STREAM_ID == request.getIdCase()) {
            return this.streamPropertiesToResponse(this.getStreamProps(request.getStreamId()));
        }
        if (GetStreamRequest.IdCase.STREAM_NAME == request.getIdCase()) {
            return this.getStreamProps(request.getStreamName());
        }
        return FutureUtils.value((Object)GetStreamResponse.newBuilder().setCode(StatusCode.ILLEGAL_OP).build());
    }

    CompletableFuture<StreamProperties> getStreamProps(long streamId) {
        byte[] streamReverseIndexKey = RootRangeStoreImpl.getStreamIdKey(streamId);
        return this.store.get((Object)streamReverseIndexKey).thenCompose(nsIdBytes -> {
            if (null == nsIdBytes) {
                return FutureUtils.value(null);
            }
            long nsId = Bytes.toLong((byte[])nsIdBytes, (int)0);
            return this.getStreamProps(nsId, streamId);
        });
    }

    CompletableFuture<GetStreamResponse> getStreamProps(StreamName streamName) {
        StatusCode code = this.verifyStreamRequest(streamName.getNamespaceName(), streamName.getStreamName());
        if (StatusCode.SUCCESS != code) {
            return FutureUtils.value((Object)GetStreamResponse.newBuilder().setCode(code).build());
        }
        byte[] nsNameKey = RootRangeStoreImpl.getNamespaceNameKey(streamName.getNamespaceName());
        return this.store.get((Object)nsNameKey).thenCompose(nsIdBytes -> {
            if (null == nsIdBytes) {
                return FutureUtils.value((Object)GetStreamResponse.newBuilder().setCode(StatusCode.NAMESPACE_NOT_FOUND).build());
            }
            long nsId = Bytes.toLong((byte[])nsIdBytes, (int)0);
            return this.streamPropertiesToResponse(this.getStreamProps(nsId, streamName.getStreamName()));
        });
    }

    CompletableFuture<StreamProperties> getStreamProps(long nsId, String streamName) {
        byte[] streamNameKey = RootRangeStoreImpl.getStreamNameKey(nsId, streamName);
        return this.store.get((Object)streamNameKey).thenCompose(streamIdBytes -> {
            if (null == streamIdBytes) {
                return FutureUtils.value(null);
            }
            long streamId = Bytes.toLong((byte[])streamIdBytes, (int)0);
            return this.getStreamProps(nsId, streamId);
        });
    }

    CompletableFuture<StreamProperties> getStreamProps(long nsId, long streamId) {
        byte[] streamIdKey = RootRangeStoreImpl.getStreamIdKey(nsId, streamId);
        return this.store.get((Object)streamIdKey).thenCompose(streamPropBytes -> {
            if (null == streamPropBytes) {
                return FutureUtils.value(null);
            }
            try {
                return FutureUtils.value((Object)StreamProperties.parseFrom((byte[])streamPropBytes));
            }
            catch (InvalidProtocolBufferException e) {
                return FutureUtils.exception((Throwable)e);
            }
        });
    }
}

