/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.xds.CdsLoadBalancerProvider;
import io.grpc.xds.EdsLoadBalancerProvider;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import io.grpc.xds.internal.sds.TlsContextManager;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

final class CdsLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final LoadBalancerRegistry lbRegistry;
    private final TlsContextManager tlsContextManager;
    private boolean enableXdsSecurity;
    private static final String XDS_SECURITY_ENV_VAR = "GRPC_XDS_EXPERIMENTAL_SECURITY_SUPPORT";
    private String clusterName;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private CdsLbState cdsLbState;
    private LoadBalancer.ResolvedAddresses resolvedAddresses;

    CdsLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), TlsContextManagerImpl.getInstance());
    }

    @VisibleForTesting
    CdsLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, TlsContextManager tlsContextManager) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = lbRegistry;
        this.tlsContextManager = tlsContextManager;
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cds-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.clusterName != null) {
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        this.resolvedAddresses = resolvedAddresses;
        this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
        Preconditions.checkNotNull(this.xdsClientPool, (Object)"missing xDS client pool");
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)lbConfig, (Object)"missing CDS lb config");
        CdsLoadBalancerProvider.CdsConfig newCdsConfig = (CdsLoadBalancerProvider.CdsConfig)lbConfig;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received CDS lb config: cluster={0}", newCdsConfig.name);
        this.clusterName = newCdsConfig.name;
        this.cdsLbState = new CdsLbState();
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.cdsLbState != null) {
            this.cdsLbState.propagateError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.cdsLbState != null) {
            this.cdsLbState.shutdown();
        }
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private boolean isXdsSecurityEnabled() {
        return this.enableXdsSecurity || Boolean.valueOf(System.getenv(XDS_SECURITY_ENV_VAR)) != false;
    }

    @VisibleForTesting
    void setXdsSecurity(boolean enable) {
        this.enableXdsSecurity = enable;
    }

    private final class CdsLbState
    implements XdsClient.CdsResourceWatcher {
        private final ChannelSecurityLbHelper lbHelper;
        @Nullable
        LoadBalancer edsBalancer;

        private CdsLbState() {
            this.lbHelper = new ChannelSecurityLbHelper();
            CdsLoadBalancer.this.xdsClient.watchCdsResource(CdsLoadBalancer.this.clusterName, this);
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Started watcher for cluster {0} with xDS client {1}", CdsLoadBalancer.this.clusterName, CdsLoadBalancer.this.xdsClient);
        }

        @Override
        public void onChanged(XdsClient.CdsUpdate newUpdate) {
            if (CdsLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster update from xDS client {0}: cluster_name={1}, eds_service_name={2}, lb_policy={3}, report_load={4}", CdsLoadBalancer.this.xdsClient, newUpdate.getClusterName(), newUpdate.getEdsServiceName(), newUpdate.getLbPolicy(), newUpdate.getLrsServerName() != null);
            }
            Preconditions.checkArgument((boolean)newUpdate.getLbPolicy().equals("round_robin"), (Object)"can only support round_robin policy");
            LoadBalancerProvider endpointPickingPolicyProvider = CdsLoadBalancer.this.lbRegistry.getProvider(newUpdate.getLbPolicy());
            LoadBalancerProvider localityPickingPolicyProvider = CdsLoadBalancer.this.lbRegistry.getProvider("weighted_target_experimental");
            EdsLoadBalancerProvider.EdsConfig edsConfig = new EdsLoadBalancerProvider.EdsConfig(newUpdate.getClusterName(), newUpdate.getEdsServiceName(), newUpdate.getLrsServerName(), new ServiceConfigUtil.PolicySelection(localityPickingPolicyProvider, null), new ServiceConfigUtil.PolicySelection(endpointPickingPolicyProvider, null));
            if (CdsLoadBalancer.this.isXdsSecurityEnabled()) {
                this.updateSslContextProviderSupplier(newUpdate.getUpstreamTlsContext());
            }
            if (this.edsBalancer == null) {
                this.edsBalancer = CdsLoadBalancer.this.lbRegistry.getProvider("eds_experimental").newLoadBalancer((LoadBalancer.Helper)this.lbHelper);
            }
            this.edsBalancer.handleResolvedAddresses(CdsLoadBalancer.this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)edsConfig).build());
        }

        private void updateSslContextProviderSupplier(EnvoyServerProtoData.UpstreamTlsContext newUpstreamTlsContext) {
            SslContextProviderSupplier oldSslContextProviderSupplier = this.lbHelper.sslContextProviderSupplier;
            if (oldSslContextProviderSupplier != null) {
                EnvoyServerProtoData.UpstreamTlsContext oldUpstreamTlsContext = oldSslContextProviderSupplier.getUpstreamTlsContext();
                if (oldUpstreamTlsContext.equals(newUpstreamTlsContext)) {
                    return;
                }
                oldSslContextProviderSupplier.close();
            }
            if (newUpstreamTlsContext != null) {
                this.lbHelper.sslContextProviderSupplier = new SslContextProviderSupplier(newUpstreamTlsContext, CdsLoadBalancer.this.tlsContextManager);
            } else {
                this.lbHelper.sslContextProviderSupplier = null;
            }
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
            if (this.edsBalancer != null) {
                this.edsBalancer.shutdown();
                this.edsBalancer = null;
            }
            CdsLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Resource " + resourceName + " is unavailable")));
        }

        @Override
        public void onError(Status error) {
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}: {2}", CdsLoadBalancer.this.xdsClient, error.getCode(), error.getDescription());
            if (this.edsBalancer == null) {
                CdsLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }

        void shutdown() {
            CdsLoadBalancer.this.xdsClient.cancelCdsResourceWatch(CdsLoadBalancer.this.clusterName, this);
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled watcher for cluster {0} with xDS client {1}", CdsLoadBalancer.this.clusterName, CdsLoadBalancer.this.xdsClient);
            if (this.edsBalancer != null) {
                this.edsBalancer.shutdown();
            }
        }

        void propagateError(Status error) {
            if (this.edsBalancer != null) {
                this.edsBalancer.handleNameResolutionError(error);
            } else {
                CdsLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }
        }
    }

    private final class ChannelSecurityLbHelper
    extends ForwardingLoadBalancerHelper {
        @Nullable
        private SslContextProviderSupplier sslContextProviderSupplier;

        private ChannelSecurityLbHelper() {
        }

        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs createSubchannelArgs) {
            if (this.sslContextProviderSupplier != null) {
                createSubchannelArgs = createSubchannelArgs.toBuilder().setAddresses(this.addSslContextProviderSupplier(createSubchannelArgs.getAddresses(), this.sslContextProviderSupplier)).build();
            }
            return this.delegate().createSubchannel(createSubchannelArgs);
        }

        private List<EquivalentAddressGroup> addSslContextProviderSupplier(List<EquivalentAddressGroup> addresses, SslContextProviderSupplier supplier) {
            if (supplier == null || addresses == null) {
                return addresses;
            }
            ArrayList<EquivalentAddressGroup> copyList = new ArrayList<EquivalentAddressGroup>(addresses.size());
            for (EquivalentAddressGroup eag : addresses) {
                EquivalentAddressGroup eagCopy = new EquivalentAddressGroup(eag.getAddresses(), eag.getAttributes().toBuilder().set(XdsAttributes.ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER, (Object)supplier).build());
                copyList.add(eagCopy);
            }
            return copyList;
        }

        protected LoadBalancer.Helper delegate() {
            return CdsLoadBalancer.this.helper;
        }
    }
}

