/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.EdsLoadBalancerProvider;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.LrsLoadBalancerProvider;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class EdsLoadBalancer2
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancerRegistry lbRegistry;
    private final ThreadSafeRandom random;
    private final GracefulSwitchLoadBalancer switchingLoadBalancer;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private String cluster;
    private EdsLbState edsLbState;

    EdsLoadBalancer2(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    EdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, ThreadSafeRandom random) {
        this.lbRegistry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)lbRegistry, (Object)"lbRegistry");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.switchingLoadBalancer = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper"));
        InternalLogId logId = InternalLogId.allocate((String)"eds-lb", (String)helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received EDS lb config: cluster={0}, eds_service_name={1}, endpoint_picking_policy={2}, report_load={3}", config.clusterName, config.edsServiceName, config.endpointPickingPolicy.getProvider().getPolicyName(), config.lrsServerName != null);
        }
        if (this.cluster == null) {
            this.cluster = config.clusterName;
        }
        if (this.edsLbState == null || !Objects.equals(this.edsLbState.edsServiceName, config.edsServiceName)) {
            this.edsLbState = new EdsLbState(config.edsServiceName, config.lrsServerName);
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)this.edsLbState);
        }
        this.switchingLoadBalancer.handleResolvedAddresses(resolvedAddresses);
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchingLoadBalancer.handleNameResolutionError(error);
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.switchingLoadBalancer.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    @VisibleForTesting
    static PriorityLoadBalancerProvider.PriorityLbConfig generatePriorityLbConfig(String cluster, String edsServiceName, String lrsServerName, ServiceConfigUtil.PolicySelection localityPickingPolicy, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<Integer, Map<EnvoyProtoData.Locality, Integer>> prioritizedLocalityWeights) {
        HashMap<String, ServiceConfigUtil.PolicySelection> childPolicies = new HashMap<String, ServiceConfigUtil.PolicySelection>();
        ArrayList<String> priorities = new ArrayList<String>();
        for (Integer priority : prioritizedLocalityWeights.keySet()) {
            WeightedTargetLoadBalancerProvider.WeightedTargetConfig childConfig = EdsLoadBalancer2.generateWeightedTargetLbConfig(cluster, edsServiceName, lrsServerName, endpointPickingPolicy, lbRegistry, prioritizedLocalityWeights.get(priority));
            ServiceConfigUtil.PolicySelection childPolicySelection = new ServiceConfigUtil.PolicySelection(localityPickingPolicy.getProvider(), (Object)childConfig);
            String childName = EdsLoadBalancer2.priorityName(priority);
            childPolicies.put(childName, childPolicySelection);
            priorities.add(childName);
        }
        Collections.sort(priorities);
        return new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(childPolicies), Collections.unmodifiableList(priorities));
    }

    @VisibleForTesting
    static WeightedTargetLoadBalancerProvider.WeightedTargetConfig generateWeightedTargetLbConfig(String cluster, String edsServiceName, String lrsServerName, ServiceConfigUtil.PolicySelection endpointPickingPolicy, LoadBalancerRegistry lbRegistry, Map<EnvoyProtoData.Locality, Integer> localityWeights) {
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (EnvoyProtoData.Locality locality : localityWeights.keySet()) {
            ServiceConfigUtil.PolicySelection childPolicy;
            int weight = localityWeights.get(locality);
            if (lrsServerName != null) {
                LrsLoadBalancerProvider.LrsConfig childConfig = new LrsLoadBalancerProvider.LrsConfig(cluster, edsServiceName, lrsServerName, locality, endpointPickingPolicy);
                LoadBalancerProvider childPolicyProvider = lbRegistry.getProvider("lrs_experimental");
                childPolicy = new ServiceConfigUtil.PolicySelection(childPolicyProvider, (Object)childConfig);
            } else {
                childPolicy = endpointPickingPolicy;
            }
            targets.put(EdsLoadBalancer2.localityName(locality), new WeightedTargetLoadBalancerProvider.WeightedPolicySelection(weight, childPolicy));
        }
        return new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(Collections.unmodifiableMap(targets));
    }

    private static String priorityName(int priority) {
        return "priority" + priority;
    }

    private static String localityName(EnvoyProtoData.Locality locality) {
        return locality.toString();
    }

    private final class EdsLbState
    extends LoadBalancer.Factory {
        @Nullable
        private final String edsServiceName;
        @Nullable
        private final String lrsServerName;
        private final String resourceName;

        private EdsLbState(@Nullable String edsServiceName, String lrsServerName) {
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.resourceName = edsServiceName == null ? EdsLoadBalancer2.this.cluster : edsServiceName;
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ChildLbState(helper);
        }

        private final class ChildLbState
        extends LoadBalancer
        implements XdsClient.EdsResourceWatcher {
            @Nullable
            private final LoadStatsManager.LoadStatsStore loadStatsStore;
            private final DropHandlingLbHelper lbHelper;
            private List<EquivalentAddressGroup> endpointAddresses = Collections.emptyList();
            private Map<Integer, Map<EnvoyProtoData.Locality, Integer>> prioritizedLocalityWeights = Collections.emptyMap();
            private LoadBalancer.ResolvedAddresses resolvedAddresses;
            private ServiceConfigUtil.PolicySelection localityPickingPolicy;
            private ServiceConfigUtil.PolicySelection endpointPickingPolicy;
            @Nullable
            private LoadBalancer lb;

            private ChildLbState(LoadBalancer.Helper helper) {
                if (EdsLbState.this.lrsServerName != null) {
                    this.loadStatsStore = EdsLoadBalancer2.this.xdsClient.addClientStats(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName);
                    EdsLoadBalancer2.this.xdsClient.reportClientStats();
                } else {
                    this.loadStatsStore = null;
                }
                this.lbHelper = new DropHandlingLbHelper(helper);
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start endpoint watcher on {0} with xDS client {1}", EdsLbState.this.resourceName, EdsLoadBalancer2.this.xdsClient);
                EdsLoadBalancer2.this.xdsClient.watchEdsResource(EdsLbState.this.resourceName, this);
            }

            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                this.resolvedAddresses = resolvedAddresses;
                EdsLoadBalancerProvider.EdsConfig config = (EdsLoadBalancerProvider.EdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
                if (!(this.lb == null || config.localityPickingPolicy.equals((Object)this.localityPickingPolicy) && config.endpointPickingPolicy.equals((Object)this.endpointPickingPolicy))) {
                    PriorityLoadBalancerProvider.PriorityLbConfig childConfig = EdsLoadBalancer2.generatePriorityLbConfig(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName, EdsLbState.this.lrsServerName, config.localityPickingPolicy, config.endpointPickingPolicy, EdsLoadBalancer2.this.lbRegistry, this.prioritizedLocalityWeights);
                    Attributes attributes = EdsLbState.this.lrsServerName != null ? resolvedAddresses.getAttributes().toBuilder().set(XdsAttributes.ATTR_CLUSTER_SERVICE_LOAD_STATS_STORE, (Object)this.loadStatsStore).build() : resolvedAddresses.getAttributes();
                    this.lb.handleResolvedAddresses(resolvedAddresses.toBuilder().setAddresses(this.endpointAddresses).setAttributes(attributes).setLoadBalancingPolicyConfig((Object)childConfig).build());
                }
                this.localityPickingPolicy = config.localityPickingPolicy;
                this.endpointPickingPolicy = config.endpointPickingPolicy;
            }

            public void handleNameResolutionError(Status error) {
                if (this.lb != null) {
                    this.lb.handleNameResolutionError(error);
                } else {
                    this.lbHelper.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }

            public void shutdown() {
                if (EdsLbState.this.lrsServerName != null) {
                    EdsLoadBalancer2.this.xdsClient.cancelClientStatsReport();
                    EdsLoadBalancer2.this.xdsClient.removeClientStats(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName);
                }
                EdsLoadBalancer2.this.xdsClient.cancelEdsResourceWatch(EdsLbState.this.resourceName, this);
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled endpoint watcher on {0} with xDS client {1}", EdsLbState.this.resourceName, EdsLoadBalancer2.this.xdsClient);
                if (this.lb != null) {
                    this.lb.shutdown();
                }
            }

            public boolean canHandleEmptyAddressListFromNameResolution() {
                return true;
            }

            @Override
            public void onChanged(XdsClient.EdsUpdate update) {
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update from xDS client {0}: {1}", EdsLoadBalancer2.this.xdsClient, update);
                if (EdsLoadBalancer2.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                    EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received endpoint update: cluster_name={0}, {1} localities, {2} drop categories", update.getClusterName(), update.getLocalityLbEndpointsMap().size(), update.getDropPolicies().size());
                }
                this.lbHelper.updateDropPolicies(update.getDropPolicies());
                Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpoints = update.getLocalityLbEndpointsMap();
                this.endpointAddresses = new ArrayList<EquivalentAddressGroup>();
                this.prioritizedLocalityWeights = new HashMap<Integer, Map<EnvoyProtoData.Locality, Integer>>();
                for (EnvoyProtoData.Locality locality : localityLbEndpoints.keySet()) {
                    EnvoyProtoData.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                    int priority = localityLbInfo.getPriority();
                    boolean discard = true;
                    for (EnvoyProtoData.LbEndpoint endpoint : localityLbInfo.getEndpoints()) {
                        if (!endpoint.isHealthy()) continue;
                        discard = false;
                        EquivalentAddressGroup eag = AddressFilter.setPathFilter(endpoint.getAddress(), Arrays.asList(EdsLoadBalancer2.priorityName(priority), EdsLoadBalancer2.localityName(locality)));
                        this.endpointAddresses.add(eag);
                    }
                    if (discard) {
                        EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints");
                        continue;
                    }
                    if (!this.prioritizedLocalityWeights.containsKey(priority)) {
                        this.prioritizedLocalityWeights.put(priority, new HashMap());
                    }
                    this.prioritizedLocalityWeights.get(priority).put(locality, localityLbInfo.getLocalityWeight());
                }
                if (this.prioritizedLocalityWeights.isEmpty()) {
                    this.propagateResourceError(Status.UNAVAILABLE.withDescription("No usable priority/locality/endpoint"));
                    return;
                }
                if (this.lb == null) {
                    this.lb = EdsLoadBalancer2.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer((LoadBalancer.Helper)this.lbHelper);
                }
                if (this.localityPickingPolicy != null && this.endpointPickingPolicy != null) {
                    PriorityLoadBalancerProvider.PriorityLbConfig config = EdsLoadBalancer2.generatePriorityLbConfig(EdsLoadBalancer2.this.cluster, EdsLbState.this.edsServiceName, EdsLbState.this.lrsServerName, this.localityPickingPolicy, this.endpointPickingPolicy, EdsLoadBalancer2.this.lbRegistry, this.prioritizedLocalityWeights);
                    Attributes attributes = EdsLbState.this.lrsServerName != null ? this.resolvedAddresses.getAttributes().toBuilder().set(XdsAttributes.ATTR_CLUSTER_SERVICE_LOAD_STATS_STORE, (Object)this.loadStatsStore).build() : this.resolvedAddresses.getAttributes();
                    this.lb.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setAddresses(this.endpointAddresses).setAttributes(attributes).setLoadBalancingPolicyConfig((Object)config).build());
                }
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} is unavailable", resourceName);
                this.propagateResourceError(Status.UNAVAILABLE.withDescription("Resource " + resourceName + " is unavailable"));
            }

            @Override
            public void onError(Status error) {
                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", EdsLoadBalancer2.this.xdsClient, error);
                if (this.lb == null) {
                    this.lbHelper.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                }
            }

            private void propagateResourceError(Status error) {
                if (this.lb != null) {
                    this.lb.shutdown();
                    this.lb = null;
                }
                this.lbHelper.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
            }

            private final class DropHandlingLbHelper
            extends ForwardingLoadBalancerHelper {
                private final LoadBalancer.Helper helper;
                private List<EnvoyProtoData.DropOverload> dropPolicies = Collections.emptyList();

                private DropHandlingLbHelper(LoadBalancer.Helper helper) {
                    this.helper = helper;
                }

                public void updateBalancingState(ConnectivityState newState, final LoadBalancer.SubchannelPicker newPicker) {
                    LoadBalancer.SubchannelPicker picker = new LoadBalancer.SubchannelPicker(){
                        List<EnvoyProtoData.DropOverload> dropOverloads;
                        {
                            this.dropOverloads = DropHandlingLbHelper.this.dropPolicies;
                        }

                        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                            for (EnvoyProtoData.DropOverload dropOverload : this.dropOverloads) {
                                int rand = EdsLoadBalancer2.this.random.nextInt(1000000);
                                if (rand >= dropOverload.getDropsPerMillion()) continue;
                                EdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Drop request with category: {0}", dropOverload.getCategory());
                                if (ChildLbState.this.loadStatsStore != null) {
                                    ChildLbState.this.loadStatsStore.recordDroppedRequest(dropOverload.getCategory());
                                }
                                return LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped: " + dropOverload.getCategory()));
                            }
                            return newPicker.pickSubchannel(args);
                        }
                    };
                    this.delegate().updateBalancingState(newState, picker);
                }

                protected LoadBalancer.Helper delegate() {
                    return this.helper;
                }

                private void updateDropPolicies(List<EnvoyProtoData.DropOverload> dropOverloads) {
                    this.dropPolicies = dropOverloads;
                }
            }
        }
    }
}

