/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.ClientLoadCounter;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.LrsLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.Objects;
import javax.annotation.CheckForNull;

final class LrsLoadBalancer
extends LoadBalancer {
    private final LoadBalancer.Helper helper;
    @CheckForNull
    private GracefulSwitchLoadBalancer switchingLoadBalancer;
    private LoadStatsManager.LoadStatsStore loadStatsStore;
    private String clusterName;
    private String edsServiceName;
    private EnvoyProtoData.Locality locality;
    private String childPolicyName;

    LrsLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        String updatedChildPolicyName;
        LrsLoadBalancerProvider.LrsConfig config = (LrsLoadBalancerProvider.LrsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        LoadStatsManager.LoadStatsStore store = (LoadStatsManager.LoadStatsStore)resolvedAddresses.getAttributes().get(XdsAttributes.ATTR_CLUSTER_SERVICE_LOAD_STATS_STORE);
        Preconditions.checkNotNull((Object)config, (Object)"missing LRS lb config");
        Preconditions.checkNotNull((Object)store, (Object)"missing cluster service stats object");
        this.checkAndSetUp(config, store);
        if (this.switchingLoadBalancer == null) {
            final ClientLoadCounter counter = this.loadStatsStore.addLocality(config.locality);
            ForwardingLoadBalancerHelper loadRecordingHelper = new ForwardingLoadBalancerHelper(){

                protected LoadBalancer.Helper delegate() {
                    return LrsLoadBalancer.this.helper;
                }

                public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                    ClientLoadCounter.LoadRecordingSubchannelPicker loadRecordingPicker = new ClientLoadCounter.LoadRecordingSubchannelPicker(counter, newPicker);
                    super.updateBalancingState(newState, (LoadBalancer.SubchannelPicker)loadRecordingPicker);
                }
            };
            this.switchingLoadBalancer = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)loadRecordingHelper);
        }
        if (!Objects.equals(this.childPolicyName, updatedChildPolicyName = config.childPolicy.getProvider().getPolicyName())) {
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)config.childPolicy.getProvider());
            this.childPolicyName = updatedChildPolicyName;
        }
        LoadBalancer.ResolvedAddresses downStreamResult = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config.childPolicy.getConfig()).build();
        this.switchingLoadBalancer.handleResolvedAddresses(downStreamResult);
    }

    public void handleNameResolutionError(Status error) {
        if (this.switchingLoadBalancer != null) {
            this.switchingLoadBalancer.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    public void shutdown() {
        if (this.switchingLoadBalancer != null) {
            this.loadStatsStore.removeLocality(this.locality);
            this.switchingLoadBalancer.shutdown();
        }
    }

    private void checkAndSetUp(LrsLoadBalancerProvider.LrsConfig config, LoadStatsManager.LoadStatsStore store) {
        Preconditions.checkState((this.clusterName == null || this.clusterName.equals(config.clusterName) ? 1 : 0) != 0, (Object)"cluster name should not change");
        Preconditions.checkState((this.edsServiceName == null || this.edsServiceName.equals(config.edsServiceName) ? 1 : 0) != 0, (Object)"edsServiceName should not change");
        Preconditions.checkState((this.locality == null || this.locality.equals(config.locality) ? 1 : 0) != 0, (Object)"locality should not change");
        Preconditions.checkState((this.loadStatsStore == null || this.loadStatsStore.equals(store) ? 1 : 0) != 0, (Object)"loadStatsStore should not change");
        this.clusterName = config.clusterName;
        this.edsServiceName = config.edsServiceName;
        this.locality = config.locality;
        this.loadStatsStore = store;
    }
}

