/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.routing;

import io.grpc.Channel;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.stream.storage.impl.routing.StorageContainerProxyChannelManager;

public class StorageContainerProxyChannelManagerImpl
implements StorageContainerProxyChannelManager {
    private final StorageServerClientManager ssClientManager;

    public StorageContainerProxyChannelManagerImpl(StorageServerClientManager clientManager) {
        this.ssClientManager = clientManager;
    }

    @Override
    public Channel getStorageContainerChannel(long scId) {
        StorageContainerChannel channel = this.ssClientManager.getStorageContainerChannel(scId);
        CompletableFuture serverChannelFuture = channel.getStorageContainerChannelFuture();
        if (null != serverChannelFuture && serverChannelFuture.isDone()) {
            StorageServerChannel serverChannel = (StorageServerChannel)serverChannelFuture.join();
            if (serverChannel != null) {
                return serverChannel.getGrpcChannel();
            }
            return null;
        }
        return null;
    }
}

