/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageProducer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;

public class MessageProducerImpl<T>
implements MessageProducer<T> {
    public static final String CREDIT_ADDRESS_HEADER_NAME = "__vertx.credit";
    private final Vertx vertx;
    private final EventBus bus;
    private final boolean send;
    private final String address;
    private final Queue<T> pending = new ArrayDeque<T>();
    private final MessageConsumer<Integer> creditConsumer;
    private DeliveryOptions options;
    private int maxSize = 1000;
    private int credits = 1000;
    private Handler<Void> drainHandler;

    public MessageProducerImpl(Vertx vertx, String address, boolean send, DeliveryOptions options) {
        this.vertx = vertx;
        this.bus = vertx.eventBus();
        this.address = address;
        this.send = send;
        this.options = options;
        if (send) {
            String creditAddress = UUID.randomUUID().toString() + "-credit";
            this.creditConsumer = this.bus.consumer(creditAddress, msg -> this.doReceiveCredit((Integer)msg.body()));
            options.addHeader(CREDIT_ADDRESS_HEADER_NAME, creditAddress);
        } else {
            this.creditConsumer = null;
        }
    }

    @Override
    public synchronized MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        if (this.creditConsumer != null) {
            options = new DeliveryOptions(options);
            options.addHeader(CREDIT_ADDRESS_HEADER_NAME, this.options.getHeaders().get(CREDIT_ADDRESS_HEADER_NAME));
        }
        this.options = options;
        return this;
    }

    @Override
    public MessageProducer<T> send(T message) {
        this.doSend(message, null);
        return this;
    }

    @Override
    public <R> MessageProducer<T> send(T message, Handler<AsyncResult<Message<R>>> replyHandler) {
        this.doSend(message, replyHandler);
        return this;
    }

    @Override
    public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    @Override
    public synchronized MessageProducer<T> setWriteQueueMaxSize(int s) {
        int delta = s - this.maxSize;
        this.maxSize = s;
        this.credits += delta;
        return this;
    }

    @Override
    public synchronized MessageProducer<T> write(T data) {
        if (this.send) {
            this.doSend(data, null);
        } else {
            this.bus.publish(this.address, data, this.options);
        }
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        return this.credits == 0;
    }

    @Override
    public synchronized MessageProducer<T> drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        if (handler != null) {
            this.checkDrained();
        }
        return this;
    }

    private void checkDrained() {
        Handler<Void> handler = this.drainHandler;
        if (handler != null && this.credits >= this.maxSize / 2) {
            this.drainHandler = null;
            this.vertx.runOnContext(v -> handler.handle(null));
        }
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public void end() {
        this.close();
    }

    @Override
    public void close() {
        if (this.creditConsumer != null) {
            this.creditConsumer.unregister();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private synchronized <R> void doSend(T data, Handler<AsyncResult<Message<R>>> replyHandler) {
        if (this.credits > 0) {
            --this.credits;
            if (replyHandler == null) {
                this.bus.send(this.address, data, this.options);
            } else {
                this.bus.send(this.address, data, this.options, replyHandler);
            }
        } else {
            this.pending.add(data);
        }
    }

    private synchronized void doReceiveCredit(int credit) {
        T data;
        this.credits += credit;
        while (this.credits > 0 && (data = this.pending.poll()) != null) {
            --this.credits;
            this.bus.send(this.address, data, this.options);
        }
        this.checkDrained();
    }
}

