/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.grpc.netty.AbstractHttp2Headers;
import io.grpc.netty.Utils;
import io.netty.handler.codec.CharSequenceValueConverter;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GrpcHttp2HeadersUtils {
    GrpcHttp2HeadersUtils() {
    }

    static final class GrpcHttp2ResponseHeaders
    extends GrpcHttp2InboundHeaders {
        GrpcHttp2ResponseHeaders(int numHeadersGuess) {
            super(numHeadersGuess);
        }

        @Override
        public Http2Headers add(CharSequence csName, CharSequence csValue) {
            AsciiString name = this.validateName(GrpcHttp2ResponseHeaders.requireAsciiString(csName));
            AsciiString value = GrpcHttp2ResponseHeaders.requireAsciiString(csValue);
            return this.add(name, value);
        }

        @Override
        public CharSequence get(CharSequence csName) {
            AsciiString name = GrpcHttp2ResponseHeaders.requireAsciiString(csName);
            return this.get(name);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
            builder.append(this.namesAndValuesToString()).append(']');
            return builder.toString();
        }
    }

    static final class GrpcHttp2RequestHeaders
    extends GrpcHttp2InboundHeaders {
        private static final AsciiString PATH_HEADER = AsciiString.of((CharSequence)":path");
        private static final AsciiString AUTHORITY_HEADER = AsciiString.of((CharSequence)":authority");
        private static final AsciiString METHOD_HEADER = AsciiString.of((CharSequence)":method");
        private static final AsciiString SCHEME_HEADER = AsciiString.of((CharSequence)":scheme");
        private AsciiString path;
        private AsciiString authority;
        private AsciiString method;
        private AsciiString scheme;
        private AsciiString te;

        GrpcHttp2RequestHeaders(int numHeadersGuess) {
            super(numHeadersGuess);
        }

        @Override
        public Http2Headers add(CharSequence csName, CharSequence csValue) {
            AsciiString name = this.validateName(GrpcHttp2RequestHeaders.requireAsciiString(csName));
            AsciiString value = GrpcHttp2RequestHeaders.requireAsciiString(csValue);
            if (GrpcHttp2RequestHeaders.isPseudoHeader(name)) {
                this.addPseudoHeader((CharSequence)name, (CharSequence)value);
                return this;
            }
            if (GrpcHttp2RequestHeaders.equals(Utils.TE_HEADER, name)) {
                this.te = value;
                return this;
            }
            return this.add(name, value);
        }

        @Override
        public CharSequence get(CharSequence csName) {
            AsciiString name = GrpcHttp2RequestHeaders.requireAsciiString(csName);
            Preconditions.checkArgument((!GrpcHttp2RequestHeaders.isPseudoHeader(name) ? 1 : 0) != 0, (Object)"Use direct accessor methods for pseudo headers.");
            if (GrpcHttp2RequestHeaders.equals(Utils.TE_HEADER, name)) {
                return this.te;
            }
            return this.get(name);
        }

        private void addPseudoHeader(CharSequence csName, CharSequence csValue) {
            AsciiString name = GrpcHttp2RequestHeaders.requireAsciiString(csName);
            AsciiString value = GrpcHttp2RequestHeaders.requireAsciiString(csValue);
            if (GrpcHttp2RequestHeaders.equals(PATH_HEADER, name)) {
                if (this.path != null) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Duplicate :path header", (Object[])new Object[0]));
                }
                this.path = value;
            } else if (GrpcHttp2RequestHeaders.equals(AUTHORITY_HEADER, name)) {
                if (this.authority != null) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Duplicate :authority header", (Object[])new Object[0]));
                }
                this.authority = value;
            } else if (GrpcHttp2RequestHeaders.equals(METHOD_HEADER, name)) {
                if (this.method != null) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Duplicate :method header", (Object[])new Object[0]));
                }
                this.method = value;
            } else if (GrpcHttp2RequestHeaders.equals(SCHEME_HEADER, name)) {
                if (this.scheme != null) {
                    PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Duplicate :scheme header", (Object[])new Object[0]));
                }
                this.scheme = value;
            } else {
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"Illegal pseudo-header '%s' in request.", (Object[])new Object[]{name}));
            }
        }

        @Override
        public CharSequence path() {
            return this.path;
        }

        @Override
        public CharSequence authority() {
            return this.authority;
        }

        @Override
        public CharSequence method() {
            return this.method;
        }

        @Override
        public CharSequence scheme() {
            return this.scheme;
        }

        @Override
        public List<CharSequence> getAll(CharSequence csName) {
            AsciiString name = GrpcHttp2RequestHeaders.requireAsciiString(csName);
            if (GrpcHttp2RequestHeaders.isPseudoHeader(name)) {
                throw new IllegalArgumentException("Use direct accessor methods for pseudo headers.");
            }
            if (GrpcHttp2RequestHeaders.equals(Utils.TE_HEADER, name)) {
                return Collections.singletonList(this.te);
            }
            return super.getAll(csName);
        }

        @Override
        public boolean remove(CharSequence csName) {
            AsciiString name = GrpcHttp2RequestHeaders.requireAsciiString(csName);
            if (GrpcHttp2RequestHeaders.isPseudoHeader(name)) {
                throw new IllegalArgumentException("Use direct accessor methods for pseudo headers.");
            }
            if (GrpcHttp2RequestHeaders.equals(Utils.TE_HEADER, name)) {
                boolean wasPresent = this.te != null;
                this.te = null;
                return wasPresent;
            }
            return super.remove((CharSequence)name);
        }

        @Override
        public int size() {
            int size = 0;
            if (this.path != null) {
                ++size;
            }
            if (this.authority != null) {
                ++size;
            }
            if (this.method != null) {
                ++size;
            }
            if (this.scheme != null) {
                ++size;
            }
            if (this.te != null) {
                ++size;
            }
            return size += super.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('[');
            boolean prependSeparator = false;
            if (this.path != null) {
                GrpcHttp2RequestHeaders.appendNameAndValue(builder, (CharSequence)PATH_HEADER, (CharSequence)this.path, prependSeparator);
                prependSeparator = true;
            }
            if (this.authority != null) {
                GrpcHttp2RequestHeaders.appendNameAndValue(builder, (CharSequence)AUTHORITY_HEADER, (CharSequence)this.authority, prependSeparator);
                prependSeparator = true;
            }
            if (this.method != null) {
                GrpcHttp2RequestHeaders.appendNameAndValue(builder, (CharSequence)METHOD_HEADER, (CharSequence)this.method, prependSeparator);
                prependSeparator = true;
            }
            if (this.scheme != null) {
                GrpcHttp2RequestHeaders.appendNameAndValue(builder, (CharSequence)SCHEME_HEADER, (CharSequence)this.scheme, prependSeparator);
                prependSeparator = true;
            }
            if (this.te != null) {
                GrpcHttp2RequestHeaders.appendNameAndValue(builder, (CharSequence)Utils.TE_HEADER, (CharSequence)this.te, prependSeparator);
            }
            String namesAndValues = this.namesAndValuesToString();
            if (builder.length() > 0 && namesAndValues.length() > 0) {
                builder.append(", ");
            }
            builder.append(namesAndValues);
            builder.append(']');
            return builder.toString();
        }
    }

    static abstract class GrpcHttp2InboundHeaders
    extends AbstractHttp2Headers {
        private static final AsciiString binaryHeaderSuffix = new AsciiString("-bin".getBytes(Charsets.US_ASCII));
        private byte[][] namesAndValues;
        private AsciiString[] values;
        private int namesAndValuesIdx;

        GrpcHttp2InboundHeaders(int numHeadersGuess) {
            Preconditions.checkArgument((numHeadersGuess > 0 ? 1 : 0) != 0, (String)"numHeadersGuess needs to be positive: %s", (int)numHeadersGuess);
            this.namesAndValues = new byte[numHeadersGuess * 2][];
            this.values = new AsciiString[numHeadersGuess];
        }

        protected Http2Headers add(AsciiString name, AsciiString value) {
            byte[] nameBytes = GrpcHttp2InboundHeaders.bytes(name);
            if (!name.endsWith((CharSequence)binaryHeaderSuffix)) {
                byte[] valueBytes = GrpcHttp2InboundHeaders.bytes(value);
                this.addHeader(value, nameBytes, valueBytes);
                return this;
            }
            int startPos = 0;
            int endPos = -1;
            while (endPos < value.length()) {
                int indexOfComma = value.indexOf(',', startPos);
                endPos = indexOfComma == -1 ? value.length() : indexOfComma;
                AsciiString curVal = value.subSequence(startPos, endPos, false);
                byte[] valueBytes = BaseEncoding.base64().decode((CharSequence)curVal);
                startPos = indexOfComma + 1;
                this.addHeader(curVal, nameBytes, valueBytes);
            }
            return this;
        }

        private void addHeader(AsciiString value, byte[] nameBytes, byte[] valueBytes) {
            if (this.namesAndValuesIdx == this.namesAndValues.length) {
                this.expandHeadersAndValues();
            }
            this.values[this.namesAndValuesIdx / 2] = value;
            this.namesAndValues[this.namesAndValuesIdx] = nameBytes;
            ++this.namesAndValuesIdx;
            this.namesAndValues[this.namesAndValuesIdx] = valueBytes;
            ++this.namesAndValuesIdx;
        }

        protected CharSequence get(AsciiString name) {
            for (int i = 0; i < this.namesAndValuesIdx; i += 2) {
                if (!GrpcHttp2InboundHeaders.equals(name, this.namesAndValues[i])) continue;
                return this.values[i / 2];
            }
            return null;
        }

        @Override
        public boolean contains(CharSequence name) {
            return this.get(name) != null;
        }

        @Override
        public CharSequence status() {
            return this.get(Http2Headers.PseudoHeaderName.STATUS.value());
        }

        @Override
        public List<CharSequence> getAll(CharSequence csName) {
            AsciiString name = GrpcHttp2InboundHeaders.requireAsciiString(csName);
            ArrayList<CharSequence> returnValues = new ArrayList<CharSequence>(4);
            for (int i = 0; i < this.namesAndValuesIdx; i += 2) {
                if (!GrpcHttp2InboundHeaders.equals(name, this.namesAndValues[i])) continue;
                returnValues.add((CharSequence)this.values[i / 2]);
            }
            return returnValues;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean remove(CharSequence csName) {
            int i;
            AsciiString name = GrpcHttp2InboundHeaders.requireAsciiString(csName);
            for (i = 0; i < this.namesAndValuesIdx && !GrpcHttp2InboundHeaders.equals(name, this.namesAndValues[i]); i += 2) {
            }
            if (i >= this.namesAndValuesIdx) {
                return false;
            }
            int dest = i;
            while (i < this.namesAndValuesIdx) {
                if (!GrpcHttp2InboundHeaders.equals(name, this.namesAndValues[i])) {
                    this.values[dest / 2] = this.values[i / 2];
                    this.namesAndValues[dest] = this.namesAndValues[i];
                    this.namesAndValues[dest + 1] = this.namesAndValues[i + 1];
                    dest += 2;
                }
                i += 2;
            }
            this.namesAndValuesIdx = dest;
            return true;
        }

        @Override
        public Http2Headers set(CharSequence name, CharSequence value) {
            this.remove(name);
            return this.add(name, value);
        }

        @Override
        public Http2Headers setLong(CharSequence name, long value) {
            return this.set(name, (CharSequence)AsciiString.of((CharSequence)CharSequenceValueConverter.INSTANCE.convertLong(value)));
        }

        byte[][] namesAndValues() {
            return this.namesAndValues;
        }

        protected int numHeaders() {
            return this.namesAndValuesIdx / 2;
        }

        protected static boolean equals(AsciiString str0, byte[] str1) {
            return GrpcHttp2InboundHeaders.equals(str0.array(), str0.arrayOffset(), str0.length(), str1, 0, str1.length);
        }

        protected static boolean equals(AsciiString str0, AsciiString str1) {
            return GrpcHttp2InboundHeaders.equals(str0.array(), str0.arrayOffset(), str0.length(), str1.array(), str1.arrayOffset(), str1.length());
        }

        protected static boolean equals(byte[] bytes0, int offset0, int length0, byte[] bytes1, int offset1, int length1) {
            if (length0 != length1) {
                return false;
            }
            return PlatformDependent.equals((byte[])bytes0, (int)offset0, (byte[])bytes1, (int)offset1, (int)length0);
        }

        protected static byte[] bytes(AsciiString str) {
            return str.isEntireArrayUsed() ? str.array() : str.toByteArray();
        }

        protected static AsciiString requireAsciiString(CharSequence cs) {
            if (!(cs instanceof AsciiString)) {
                throw new IllegalArgumentException("AsciiString expected. Was: " + cs.getClass().getName());
            }
            return (AsciiString)cs;
        }

        protected static boolean isPseudoHeader(AsciiString str) {
            return !str.isEmpty() && str.charAt(0) == ':';
        }

        protected AsciiString validateName(AsciiString str) {
            int offset = str.arrayOffset();
            int length = str.length();
            byte[] data = str.array();
            for (int i = offset; i < offset + length; ++i) {
                if (!AsciiString.isUpperCase((byte)data[i])) continue;
                PlatformDependent.throwException((Throwable)Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"invalid header name '%s'", (Object[])new Object[]{str}));
            }
            return str;
        }

        private void expandHeadersAndValues() {
            int newValuesLen = Math.max(2, this.values.length + this.values.length / 2);
            int newNamesAndValuesLen = newValuesLen * 2;
            byte[][] newNamesAndValues = new byte[newNamesAndValuesLen][];
            AsciiString[] newValues = new AsciiString[newValuesLen];
            System.arraycopy(this.namesAndValues, 0, newNamesAndValues, 0, this.namesAndValues.length);
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.namesAndValues = newNamesAndValues;
            this.values = newValues;
        }

        @Override
        public int size() {
            return this.numHeaders();
        }

        protected static void appendNameAndValue(StringBuilder builder, CharSequence name, CharSequence value, boolean prependSeparator) {
            if (prependSeparator) {
                builder.append(", ");
            }
            builder.append(name).append(": ").append(value);
        }

        protected final String namesAndValuesToString() {
            StringBuilder builder = new StringBuilder();
            boolean prependSeparator = false;
            for (int i = 0; i < this.namesAndValuesIdx; i += 2) {
                String name = new String(this.namesAndValues[i], Charsets.US_ASCII);
                AsciiString value = this.values[i / 2];
                GrpcHttp2InboundHeaders.appendNameAndValue(builder, name, (CharSequence)value, prependSeparator);
                prependSeparator = true;
            }
            return builder.toString();
        }
    }

    static final class GrpcHttp2ClientHeadersDecoder
    extends DefaultHttp2HeadersDecoder {
        GrpcHttp2ClientHeadersDecoder(long maxHeaderListSize) {
            super(true, maxHeaderListSize);
        }

        protected GrpcHttp2InboundHeaders newHeaders() {
            return new GrpcHttp2ResponseHeaders(this.numberOfHeadersGuess());
        }
    }

    static final class GrpcHttp2ServerHeadersDecoder
    extends DefaultHttp2HeadersDecoder {
        GrpcHttp2ServerHeadersDecoder(long maxHeaderListSize) {
            super(true, maxHeaderListSize);
        }

        protected GrpcHttp2InboundHeaders newHeaders() {
            return new GrpcHttp2RequestHeaders(this.numberOfHeadersGuess());
        }
    }
}

