/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.BlockCipherUtils;
import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.DesEdeEngine;
import org.bouncycastle.crypto.fips.DesEdeKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsInputDecryptor;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.params.DesEdeParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsTripleDES {
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("TripleDES");
    static final FipsEngineProvider<BlockCipher> ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB64;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final WrapParameters TKW;
    public static final AuthParameters CMAC;

    private FipsTripleDES() {
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm fipsAlgorithm) {
        FipsEngineProvider<Mac> fipsEngineProvider;
        switch ((Mode)fipsAlgorithm.basicVariation()) {
            case CMAC: {
                fipsEngineProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new CMac((BlockCipher)ENGINE_PROVIDER.createEngine());
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsTripleDES MAC Provider: " + fipsAlgorithm);
            }
        }
        return fipsEngineProvider;
    }

    static Mac makeMAC(AuthParameters authParameters) {
        CMac cMac;
        switch ((Mode)authParameters.getAlgorithm().basicVariation()) {
            case CMAC: {
                cMac = new CMac((BlockCipher)ENGINE_PROVIDER.createEngine(), authParameters.macLenInBits);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsTripleDES.OperatorFactory.createMACCalculator: " + authParameters.getAlgorithm());
            }
        }
        return cMac;
    }

    private static void validateKeySize(Algorithm algorithm, int n) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            if (n != 168 && n != 192) {
                throw new IllegalKeyException("Key must be of length 192 bits: " + algorithm.getName());
            }
        } else if (n != 112 && n != 168 && n != 128 && n != 192) {
            throw new IllegalKeyException("Key must be of length 128 or 192 bits: " + algorithm.getName());
        }
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, org.bouncycastle.crypto.Parameters parameters, boolean bl) {
        Algorithm algorithm;
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (!bl || n != 128) {
            FipsTripleDES.validateKeySize(symmetricKey.getAlgorithm(), n);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && !bl && !DesEdeParameters.isReal3Key(validatedSymmetricKey.getKeyBytes())) {
                throw new IllegalKeyException("Key not real 3-Key DESEDE key");
            }
        }
        if (!Properties.isOverrideSet("org.bouncycastle.tripledes.allow_weak") && !bl) {
            if (DesEdeParameters.isActuallyDesKey(validatedSymmetricKey.getKeyBytes())) {
                throw new IllegalKeyException("Attempt to use repeated DES key: " + symmetricKey.getAlgorithm().getName());
            }
            if (DesEdeParameters.isWeakKey(validatedSymmetricKey.getKeyBytes(), 0, validatedSymmetricKey.getKeyBytes().length)) {
                throw new IllegalKeyException("Attempt to use weak key: " + symmetricKey.getAlgorithm().getName());
            }
        }
        if (!(algorithm = symmetricKey.getAlgorithm()).equals(ALGORITHM) && !algorithm.equals(parameters.getAlgorithm())) {
            throw new IllegalKeyException("FIPS Key not for specified algorithm");
        }
        return validatedSymmetricKey;
    }

    private static void cmacStartUpTest(EngineProvider engineProvider) {
        SelfTestExecutor.validate(ALGORITHM, engineProvider, new BasicKatTest<EngineProvider>(){

            @Override
            public boolean hasTestPassed(EngineProvider engineProvider) throws Exception {
                byte[] byArray = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
                byte[] byArray2 = Hex.decode("c0b9bbee139722ab");
                CMac cMac = new CMac(engineProvider.createEngine(), 64);
                KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("0102020404070708080b0b0d0d0e0e101013131515161619"));
                cMac.init(keyParameterImpl);
                cMac.update(byArray, 0, byArray.length);
                byte[] byArray3 = new byte[8];
                cMac.doFinal(byArray3, 0);
                return Arrays.areEqual(byArray3, byArray2);
            }
        });
    }

    static {
        ECB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        TKW = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        CMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        FipsTripleDES.cmacStartUpTest(engineProvider);
        ENGINE_PROVIDER = engineProvider;
        FipsRegister.registerEngineProvider(ALGORITHM, engineProvider);
    }

    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParametersWithIV {
        private final byte[] iv;
        private final int macLenInBits;

        AuthParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null, Utils.getDefaultMacSize(fipsAlgorithm, 64));
        }

        private AuthParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, int n) {
            super(fipsAlgorithm);
            this.iv = byArray;
            this.macLenInBits = n;
        }

        public int getMACSizeInBits() {
            return this.macLenInBits;
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public AuthParameters withIV(byte[] byArray) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(byArray), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom secureRandom) {
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(8, secureRandom), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom secureRandom, int n) {
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createIvIfNecessary(n, secureRandom), this.macLenInBits);
        }

        public AuthParameters withMACSize(int n) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(this.iv), n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    extends FipsEngineProvider<BlockCipher> {
        private static byte[] input = Hex.decode("4e6f772069732074");
        private static byte[] output = Hex.decode("f7cfbe5e6c38b35a");
        private static final byte[] keyBytes = Hex.decode("0102020404070708080b0b0d0d0e0e101013131515161619");

        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new DesEdeEngine(), new VariantKatTest<DesEdeEngine>(){

                @Override
                public void evaluate(DesEdeEngine desEdeEngine) {
                    byte[] byArray = new byte[input.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(keyBytes);
                    desEdeEngine.init(true, keyParameterImpl);
                    desEdeEngine.processBlock(input, 0, byArray, 0);
                    if (!Arrays.areEqual(output, byArray)) {
                        this.fail("Failed self test on encryption");
                    }
                    desEdeEngine.init(false, keyParameterImpl);
                    desEdeEngine.processBlock(byArray, 0, byArray, 0);
                    if (!Arrays.areEqual(input, byArray)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int n, SecureRandom secureRandom) {
            this(ALGORITHM, n, secureRandom);
        }

        public KeyGenerator(FipsParameters fipsParameters, int n, SecureRandom secureRandom) {
            this(fipsParameters.getAlgorithm(), n, secureRandom);
        }

        private KeyGenerator(FipsAlgorithm fipsAlgorithm, int n, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyGenRandom(secureRandom, 112, fipsAlgorithm);
                if (n != 168 && n != 192) {
                    throw new IllegalArgumentException("Attempt to create key with unapproved key size [" + n + "]: " + fipsAlgorithm.getName());
                }
            } else if (n != 112 && n != 168 && n != 128 && n != 192) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + n + "]: " + fipsAlgorithm.getName());
            }
            this.algorithm = fipsAlgorithm;
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        public SymmetricKey generateKey() {
            DesEdeKeyGenerator desEdeKeyGenerator = new DesEdeKeyGenerator(this.algorithm);
            ((CipherKeyGenerator)desEdeKeyGenerator).init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, ((CipherKeyGenerator)desEdeKeyGenerator).generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        private Wrapper createWrapper(FipsAlgorithm fipsAlgorithm, boolean bl) {
            SP80038FWrapEngine sP80038FWrapEngine;
            switch ((Mode)fipsAlgorithm.basicVariation()) {
                case WRAP: {
                    sP80038FWrapEngine = new SP80038FWrapEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), bl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to FipsDESEDE.KeyWrapOperatorFactory: " + fipsAlgorithm.getName());
                }
            }
            return sP80038FWrapEngine;
        }

        @Override
        public FipsKeyWrapper<WrapParameters> createKeyWrapper(SymmetricKey symmetricKey, final WrapParameters wrapParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsTripleDES.validateKey(symmetricKey, wrapParameters, false);
            final Wrapper wrapper = this.createWrapper(wrapParameters.getAlgorithm(), wrapParameters.useInverse);
            wrapper.init(true, new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()));
            return new FipsKeyWrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return wrapParameters;
                }

                @Override
                public byte[] wrap(byte[] byArray, int n, int n2) throws PlainInputProcessingException {
                    try {
                        return wrapper.wrap(byArray, n, n2);
                    }
                    catch (Exception exception) {
                        throw new PlainInputProcessingException("Unable to wrap key: " + exception.getMessage(), exception);
                    }
                }
            };
        }

        @Override
        public FipsKeyUnwrapper<WrapParameters> createKeyUnwrapper(SymmetricKey symmetricKey, final WrapParameters wrapParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsTripleDES.validateKey(symmetricKey, wrapParameters, true);
            final Wrapper wrapper = this.createWrapper(wrapParameters.getAlgorithm(), wrapParameters.useInverse);
            wrapper.init(false, new KeyParameterImpl(validatedSymmetricKey.getKeyBytes()));
            return new FipsKeyUnwrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return wrapParameters;
                }

                @Override
                public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
                    try {
                        return wrapper.unwrap(byArray, n, n2);
                    }
                    catch (InvalidCipherTextException invalidCipherTextException) {
                        throw new InvalidWrappingException("Unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return FipsTripleDES.makeMAC(authParameters).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = FipsTripleDES.makeMAC(authParameters);
            ValidatedSymmetricKey validatedSymmetricKey = FipsTripleDES.validateKey(symmetricKey, authParameters, false);
            if (authParameters.getIV() != null) {
                mac.init(Utils.getParametersWithIV(validatedSymmetricKey, authParameters.getIV()));
            } else {
                mac.init(Utils.getKeyParameter(validatedSymmetricKey));
            }
            return mac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends FipsSymmetricOperatorFactory<Parameters> {
        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey symmetricKey, Parameters parameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsTripleDES.validateKey(symmetricKey, parameters, false);
            return new OutEncryptor(validatedSymmetricKey, parameters, null);
        }

        @Override
        public FipsOutputDecryptor<Parameters> createOutputDecryptor(SymmetricKey symmetricKey, final Parameters parameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsTripleDES.validateKey(symmetricKey, parameters, true);
            final BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createStandardCipher(false, validatedSymmetricKey, ENGINE_PROVIDER, parameters, null);
            return new FipsOutputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public int getMaxOutputSize(int n) {
                    return bufferedBlockCipher.getOutputSize(n);
                }

                @Override
                public int getUpdateOutputSize(int n) {
                    return bufferedBlockCipher.getUpdateOutputSize(n);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream outputStream) {
                    if (bufferedBlockCipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherOutputStreamImpl(outputStream, (StreamCipher)((Object)bufferedBlockCipher.getUnderlyingCipher()));
                    }
                    return new CipherOutputStreamImpl(outputStream, bufferedBlockCipher);
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey symmetricKey, final Parameters parameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsTripleDES.validateKey(symmetricKey, parameters, true);
            final BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createStandardCipher(false, validatedSymmetricKey, ENGINE_PROVIDER, parameters, null);
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public InputStream getDecryptingStream(InputStream inputStream) {
                    if (bufferedBlockCipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherInputStream(inputStream, (StreamCipher)((Object)bufferedBlockCipher.getUnderlyingCipher()));
                    }
                    return new CipherInputStream(inputStream, bufferedBlockCipher);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class OutEncryptor
        extends FipsOutputEncryptor<Parameters>
        implements OperatorUsingSecureRandom<OutputEncryptor<Parameters>> {
            private final Parameters parameters;
            private final ValidatedSymmetricKey key;
            private final BufferedBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey validatedSymmetricKey, Parameters parameters, SecureRandom secureRandom) {
                this.key = validatedSymmetricKey;
                this.parameters = parameters;
                this.cipher = BlockCipherUtils.createStandardCipher(true, validatedSymmetricKey, ENGINE_PROVIDER, parameters, secureRandom);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream outputStream) {
                if (this.cipher.getUnderlyingCipher() instanceof StreamCipher) {
                    return new CipherOutputStreamImpl(outputStream, (StreamCipher)((Object)this.cipher.getUnderlyingCipher()));
                }
                return new CipherOutputStreamImpl(outputStream, this.cipher);
            }

            @Override
            public OutputEncryptor<Parameters> withSecureRandom(SecureRandom secureRandom) {
                return new OutEncryptor(this.key, this.parameters, secureRandom);
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.cipher.getOutputSize(n);
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.cipher.getUpdateOutputSize(n);
            }
        }
    }

    public static final class Parameters
    extends FipsParameters
    implements ParametersWithIV {
        private final byte[] iv;

        Parameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null);
        }

        private Parameters(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            super(fipsAlgorithm);
            ((Mode)fipsAlgorithm.basicVariation()).checkIv(byArray, 8);
            this.iv = byArray;
        }

        public Parameters withIV(byte[] byArray) {
            return new Parameters(this.getAlgorithm(), Arrays.clone(byArray));
        }

        public Parameters withIV(SecureRandom secureRandom) {
            return new Parameters(this.getAlgorithm(), ((Mode)this.getAlgorithm().basicVariation()).createDefaultIvIfNecessary(8, secureRandom));
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    public static final class WrapParameters
    extends FipsParameters {
        private final boolean useInverse;

        WrapParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, false);
        }

        private WrapParameters(FipsAlgorithm fipsAlgorithm, boolean bl) {
            super(fipsAlgorithm);
            this.useInverse = bl;
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean bl) {
            return new WrapParameters(this.getAlgorithm(), bl);
        }
    }
}

