/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import java.util.Optional;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataBookieDriver
extends ZKMetadataDriverBase
implements MetadataBookieDriver {
    private static final Logger log = LoggerFactory.getLogger(ZKMetadataBookieDriver.class);
    ServerConfiguration serverConf;

    @Override
    public synchronized MetadataBookieDriver initialize(ServerConfiguration conf, StatsLogger statsLogger) throws MetadataException {
        super.initialize(conf, statsLogger.scope("bookie"), new BoundExponentialBackoffRetryPolicy(conf.getZkRetryBackoffStartMs(), conf.getZkRetryBackoffMaxMs(), conf.getZkRetryBackoffMaxRetries()), Optional.empty());
        this.serverConf = conf;
        this.statsLogger = statsLogger;
        return this;
    }

    @Override
    public synchronized RegistrationManager createRegistrationManager() {
        return new ZKRegistrationManager(this.serverConf, this.zk);
    }

    @Override
    public void close() {
        super.close();
    }

    static {
        MetadataDrivers.registerBookieDriver("zk", ZKMetadataBookieDriver.class);
    }
}

