/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DeleteContainerRequest;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class CreateContainerTest
extends ClientBase {
    private ZooKeeper zk;
    private Semaphore completedContainerDeletions;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.completedContainerDeletions = new Semaphore(0);
        ZKDatabase testDatabase = new ZKDatabase(this.serverFactory.zkServer.getZKDatabase().snapLog){

            public void addCommittedProposal(Request request) {
                super.addCommittedProposal(request);
                if (request.type == 20) {
                    CreateContainerTest.this.completedContainerDeletions.release();
                }
            }
        };
        this.serverFactory.zkServer.setZKDatabase(testDatabase);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test
    @Timeout(value=30L)
    public void testCreate() throws KeeperException, InterruptedException {
        this.createNoStatVerifyResult("/foo");
        this.createNoStatVerifyResult("/foo/child");
    }

    @Test
    @Timeout(value=30L)
    public void testCreateWithStat() throws KeeperException, InterruptedException {
        Stat stat = this.createWithStatVerifyResult("/foo");
        Stat childStat = this.createWithStatVerifyResult("/foo/child");
        Assertions.assertNotEquals((Object)stat, (Object)childStat);
    }

    @Test
    @Timeout(value=30L)
    public void testCreateWithNullStat() throws KeeperException, InterruptedException {
        String name = "/foo";
        Assertions.assertNull((Object)this.zk.exists("/foo", false));
        Stat stat = null;
        this.zk.create("/foo", "/foo".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER, stat);
        Assertions.assertNull(stat);
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false));
    }

    @Test
    @Timeout(value=30L)
    public void testSimpleDeletion() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.delete("/foo/bar", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Container should have been deleted");
    }

    @Test
    @Timeout(value=30L)
    public void testMultiWithContainerSimple() throws KeeperException, InterruptedException {
        Op createContainer = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.CONTAINER);
        this.zk.multi(Collections.singletonList(createContainer));
        DataTree dataTree = this.serverFactory.getZooKeeperServer().getZKDatabase().getDataTree();
        Assertions.assertEquals((int)dataTree.getContainers().size(), (int)1);
    }

    @Test
    @Timeout(value=30L)
    public void testMultiWithContainer() throws KeeperException, InterruptedException {
        Op createContainer = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.CONTAINER);
        Op createChild = Op.create((String)"/foo/bar", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        this.zk.multi(Arrays.asList(createContainer, createChild));
        DataTree dataTree = this.serverFactory.getZooKeeperServer().getZKDatabase().getDataTree();
        Assertions.assertEquals((int)dataTree.getContainers().size(), (int)1);
        this.zk.delete("/foo/bar", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Container should have been deleted");
        createContainer = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.CONTAINER);
        createChild = Op.create((String)"/foo/bar", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        Op deleteChild = Op.delete((String)"/foo/bar", (int)-1);
        this.zk.multi(Arrays.asList(createContainer, createChild, deleteChild));
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Container should have been deleted");
    }

    @Test
    @Timeout(value=30L)
    public void testSimpleDeletionAsync() throws KeeperException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AsyncCallback.Create2Callback cb = (rc, path, ctx, name, stat) -> {
            Assertions.assertEquals((Object)ctx, (Object)"context");
            latch.countDown();
        };
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER, cb, (Object)"context");
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        this.zk.create("/foo/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.delete("/foo/bar", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Container should have been deleted");
    }

    @Test
    @Timeout(value=30L)
    public void testCascadingDeletion() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar/one", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.delete("/foo/bar/one", -1);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100);
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.zk.exists("/foo/bar", false), (String)"Container should have been deleted");
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Container should have been deleted");
    }

    @Test
    @Timeout(value=30L)
    public void testFalseEmpty() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        this.zk.create("/foo/bar", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100){

            protected Collection<String> getCandidates() {
                return Collections.singletonList("/foo");
            }
        };
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Container should have not been deleted");
    }

    @Test
    @Timeout(value=30L)
    public void testMaxPerMinute() throws InterruptedException {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        RequestProcessor processor = new RequestProcessor(){

            public void processRequest(Request request) {
                try {
                    queue.add(((DeleteContainerRequest)request.readRequestRecord(DeleteContainerRequest::new)).getPath());
                }
                catch (IOException e) {
                    Assertions.fail((Throwable)e);
                }
            }

            public void shutdown() {
            }
        };
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), processor, 1, 2){

            protected long getMinIntervalMs() {
                return 1000L;
            }

            protected Collection<String> getCandidates() {
                return Arrays.asList("/one", "/two", "/three", "/four");
            }
        };
        Executors.newSingleThreadExecutor().submit(() -> {
            containerManager.checkContainers();
            return null;
        });
        Assertions.assertEquals((Object)"/one", queue.poll(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"/two", queue.poll(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)0, (int)queue.size());
        Thread.sleep(500L);
        Assertions.assertEquals((int)0, (int)queue.size());
        Assertions.assertEquals((Object)"/three", queue.poll(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"/four", queue.poll(5L, TimeUnit.SECONDS));
    }

    @Test
    @Timeout(value=30L)
    public void testMaxNeverUsedInterval() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        final AtomicLong elapsed = new AtomicLong(0L);
        final AtomicInteger deletesQty = new AtomicInteger(0);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100, 1000L){

            protected void postDeleteRequest(Request request) throws RequestProcessor.RequestProcessorException {
                deletesQty.incrementAndGet();
                super.postDeleteRequest(request);
            }

            protected long getElapsed(DataNode node) {
                return elapsed.get();
            }
        };
        containerManager.checkContainers();
        Assertions.assertEquals((int)deletesQty.get(), (int)0);
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Container should not have been deleted");
        elapsed.set(10000L);
        containerManager.checkContainers();
        Assertions.assertTrue((boolean)this.completedContainerDeletions.tryAcquire(1L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Container should have been deleted");
    }

    @Test
    @Timeout(value=30L)
    public void testZeroMaxNeverUsedInterval() throws KeeperException, InterruptedException {
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        final AtomicInteger deletesQty = new AtomicInteger(0);
        ContainerManager containerManager = new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100, 0L){

            protected void postDeleteRequest(Request request) throws RequestProcessor.RequestProcessorException {
                deletesQty.incrementAndGet();
                super.postDeleteRequest(request);
            }

            protected long getElapsed(DataNode node) {
                return 10000L;
            }
        };
        containerManager.checkContainers();
        Assertions.assertEquals((int)deletesQty.get(), (int)0);
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Container should not have been deleted");
    }

    private void createNoStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assertions.assertNull((Object)this.zk.exists(newName, false), (String)"Node existed before created");
        this.zk.create(newName, newName.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER);
        Assertions.assertNotNull((Object)this.zk.exists(newName, false), (String)"Node was not created as expected");
    }

    private Stat createWithStatVerifyResult(String newName) throws KeeperException, InterruptedException {
        Assertions.assertNull((Object)this.zk.exists(newName, false), (String)"Node existed before created");
        Stat stat = new Stat();
        this.zk.create(newName, newName.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.CONTAINER, stat);
        this.validateCreateStat(stat, newName);
        Stat referenceStat = this.zk.exists(newName, false);
        Assertions.assertNotNull((Object)referenceStat, (String)"Node was not created as expected");
        Assertions.assertEquals((Object)referenceStat, (Object)stat);
        return stat;
    }

    private void validateCreateStat(Stat stat, String name) {
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assertions.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)name.length(), (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
    }
}

