/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.api.mvcc;

import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.bookkeeper.api.kv.op.Op;
import org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.bookkeeper.api.kv.op.TxnOpBuilder;
import org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.bookkeeper.api.kv.options.Options;
import org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.bookkeeper.api.kv.result.Code;
import org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.bookkeeper.api.kv.result.KeyValue;
import org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.statelib.api.AsyncStateStore;
import org.apache.bookkeeper.statelib.api.exceptions.MVCCStoreException;
import org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStoreReadView;
import org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStoreWriteView;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface MVCCAsyncStore<K, V>
extends AsyncStateStore,
MVCCAsyncStoreWriteView<K, V>,
MVCCAsyncStoreReadView<K, V> {
    public static <T> CompletableFuture<T> failWithCode(Code code, String msg) {
        return FutureUtils.exception((Throwable)new MVCCStoreException(code, msg));
    }

    public OpFactory<K, V> getOpFactory();

    default public CompareOp<K, V> newCompareCreateRevision(CompareResult result, K key, long revision) {
        return this.getOpFactory().compareCreateRevision(result, key, revision);
    }

    default public CompareOp<K, V> newCompareModRevision(CompareResult result, K key, long revision) {
        return this.getOpFactory().compareModRevision(result, key, revision);
    }

    default public CompareOp<K, V> newCompareVersion(CompareResult result, K key, long version) {
        return this.getOpFactory().compareVersion(result, key, version);
    }

    default public CompareOp<K, V> newCompareValue(CompareResult result, K key, V value) {
        return this.getOpFactory().compareValue(result, key, value);
    }

    default public TxnOpBuilder<K, V> newTxn() {
        return this.getOpFactory().newTxn();
    }

    default public PutOp<K, V> newPut(K key, V value) {
        return this.getOpFactory().newPut(key, value, Options.blindPut());
    }

    default public RangeOp<K, V> newGet(K key) {
        return this.getOpFactory().newRange(key, Options.get());
    }

    default public RangeOp<K, V> newRange(K key, K endKey) {
        return this.getOpFactory().newRange(key, (RangeOption)this.getOpFactory().optionFactory().newRangeOption().endKey(endKey).limit(-1L).build());
    }

    default public DeleteOp<K, V> newDelete(K key) {
        return this.getOpFactory().newDelete(key, Options.delete());
    }

    default public DeleteOp<K, V> newDeleteRange(K key, K endKey) {
        return this.getOpFactory().newDelete(key, (DeleteOption)this.getOpFactory().optionFactory().newDeleteOption().endKey(endKey).prevKv(false).build());
    }

    default public IncrementOp<K, V> newIncrement(K key, long amount) {
        return this.getOpFactory().newIncrement(key, amount, Options.blindIncrement());
    }

    default public IncrementOp<K, V> newIncrementAndGet(K key, long amount) {
        return this.getOpFactory().newIncrement(key, amount, Options.incrementAndGet());
    }

    @Override
    default public CompletableFuture<V> get(K key) {
        RangeOp op = this.getOpFactory().newRange(key, Options.get());
        return this.range(op).thenCompose(result -> {
            try {
                if (Code.OK == result.code()) {
                    if (result.kvs().isEmpty()) {
                        CompletableFuture completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = FutureUtils.value((Object)ReferenceCountUtil.retain((Object)((KeyValue)result.kvs().get(0)).value()));
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to retrieve key " + key + " from store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<KeyValue<K, V>> getKeyValue(K key) {
        RangeOp<K, V> op = this.newGet(key);
        return this.range(op).thenCompose(result -> {
            try {
                if (Code.OK == result.code()) {
                    if (result.kvs().isEmpty()) {
                        CompletableFuture completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    List records = result.getKvsAndClear();
                    KeyValue record = (KeyValue)records.get(0);
                    CompletableFuture completableFuture = FutureUtils.value((Object)record);
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to retrieve key " + key + " from store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<List<KeyValue<K, V>>> range(K key, K endKey) {
        RangeOp<K, V> op = this.newRange(key, endKey);
        return this.range(op).thenCompose(result -> {
            try {
                if (Code.OK == result.code()) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)result.getKvsAndClear());
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to retrieve range [" + key + ", " + endKey + "] from store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Void> put(K k, V v) {
        if (v == null) {
            return this.delete(k).thenApply(ignored -> null);
        }
        PutOp<K, V> op = this.newPut(k, v);
        return this.put(op).thenCompose(result -> {
            try {
                if (Code.OK == result.code()) {
                    CompletableFuture completableFuture = FutureUtils.Void();
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to put (" + k + ", " + v + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<V> putIfAbsent(K k, V v) {
        TxnOp op = this.getOpFactory().newTxn().If(new CompareOp[]{this.newCompareValue(CompareResult.EQUAL, k, null)}).Then(new Op[]{this.newPut(k, v)}).Else(new Op[]{this.newGet(k)}).build();
        return this.txn(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code) {
                    if (result.isSuccess()) {
                        CompletableFuture completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    RangeResult rangeResult = (RangeResult)result.results().get(0);
                    if (rangeResult.kvs().isEmpty()) {
                        CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(Code.UNEXPECTED, "Key " + k + " not found when putIfAbsent failed at store " + this.name());
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = FutureUtils.value((Object)ReferenceCountUtil.retain((Object)((KeyValue)rangeResult.kvs().get(0)).value()));
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to putIfAbsent (" + k + ", " + v + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Long> vPut(K k, V v, long expectedVersion) {
        TxnOp op = this.getOpFactory().newTxn().If(new CompareOp[]{this.newCompareVersion(CompareResult.EQUAL, k, expectedVersion)}).Then(new Op[]{this.newPut(k, v)}).build();
        return this.txn(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code && !result.isSuccess()) {
                    code = Code.BAD_REVISION;
                }
                if (Code.OK == code) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)(expectedVersion + 1L));
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to vPut (" + k + ", " + v + ")@version=" + expectedVersion + " to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Long> rPut(K k, V v, long expectedRevision) {
        TxnOp op = this.getOpFactory().newTxn().If(new CompareOp[]{this.newCompareModRevision(CompareResult.EQUAL, k, expectedRevision)}).Then(new Op[]{this.newPut(k, v)}).build();
        return this.txn(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code && !result.isSuccess()) {
                    code = Code.BAD_REVISION;
                }
                if (Code.OK == code) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)result.revision());
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Failed to vPut (" + k + ", " + v + ")@revision=" + expectedRevision + " to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<V> delete(K k) {
        DeleteOp op = this.getOpFactory().newDelete(k, Options.deleteAndGet());
        return this.delete((K)op).thenCompose(result -> {
            try {
                if (Code.OK == result.code()) {
                    List prevKvs = result.prevKvs();
                    if (prevKvs.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = FutureUtils.value((Object)((KeyValue)prevKvs.get(0)).value());
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Fail to delete key " + k + " from store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<List<KeyValue<K, V>>> deleteRange(K key, K endKey) {
        DeleteOp op = this.getOpFactory().newDelete(key, (DeleteOption)this.getOpFactory().optionFactory().newDeleteOption().endKey(endKey).prevKv(true).build());
        return this.delete((K)op).thenCompose(result -> {
            try {
                if (Code.OK == result.code()) {
                    List prevKvs = result.getPrevKvsAndClear();
                    CompletableFuture completableFuture = FutureUtils.value((Object)prevKvs);
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(result.code(), "Fail to delete key range [" + key + ", " + endKey + "] from store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<KeyValue<K, V>> vDelete(K k, long expectedVersion) {
        TxnOp op = this.getOpFactory().newTxn().If(new CompareOp[]{this.newCompareVersion(CompareResult.EQUAL, k, expectedVersion)}).Then(new Op[]{this.getOpFactory().newDelete(k, Options.deleteAndGet())}).build();
        return this.txn(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code && !result.isSuccess()) {
                    code = Code.BAD_REVISION;
                }
                if (Code.OK == code) {
                    List subResults = result.results();
                    DeleteResult deleteResult = (DeleteResult)subResults.get(0);
                    List prevKvs = deleteResult.getPrevKvsAndClear();
                    if (prevKvs.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = FutureUtils.value(prevKvs.get(0));
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(code, "Failed to vDelete key " + k + " (version=" + expectedVersion + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<KeyValue<K, V>> rDelete(K k, long expectedRevision) {
        TxnOp op = this.getOpFactory().newTxn().If(new CompareOp[]{this.newCompareModRevision(CompareResult.EQUAL, k, expectedRevision)}).Then(new Op[]{this.getOpFactory().newDelete(k, Options.deleteAndGet())}).build();
        return this.txn(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code && !result.isSuccess()) {
                    code = Code.BAD_REVISION;
                }
                if (Code.OK == code) {
                    List subResults = result.results();
                    DeleteResult deleteResult = (DeleteResult)subResults.get(0);
                    List prevKvs = deleteResult.getPrevKvsAndClear();
                    if (prevKvs.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtils.value(null);
                        return completableFuture;
                    }
                    CompletableFuture completableFuture = FutureUtils.value(prevKvs.get(0));
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(code, "Failed to rDelete key " + k + " (mod_rev=" + expectedRevision + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Boolean> delete(K k, V v) {
        TxnOp op = this.getOpFactory().newTxn().If(new CompareOp[]{this.newCompareValue(CompareResult.EQUAL, k, v)}).Then(new Op[]{this.getOpFactory().newDelete(k, Options.deleteAndGet())}).build();
        return this.txn(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code && !result.isSuccess()) {
                    code = Code.BAD_REVISION;
                }
                if (Code.OK == code) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)(!result.results().isEmpty() ? 1 : 0));
                    return completableFuture;
                }
                if (Code.BAD_REVISION == code) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)false);
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(code, "Failed to delete (" + k + ", " + v + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Void> increment(K k, long amount) {
        IncrementOp op = this.getOpFactory().newIncrement(k, amount, Options.blindIncrement());
        return this.increment(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code) {
                    CompletableFuture completableFuture = FutureUtils.Void();
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(code, "Failed to increment(" + k + ", " + amount + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Long> incrementAndGet(K k, long amount) {
        IncrementOp op = this.getOpFactory().newIncrement(k, amount, Options.incrementAndGet());
        return this.increment(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)result.totalAmount());
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(code, "Failed to increment(" + k + ", " + amount + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }

    @Override
    default public CompletableFuture<Long> getAndIncrement(K k, long amount) {
        IncrementOp op = this.getOpFactory().newIncrement(k, amount, Options.incrementAndGet());
        return this.increment(op).thenCompose(result -> {
            try {
                Code code = result.code();
                if (Code.OK == code) {
                    CompletableFuture completableFuture = FutureUtils.value((Object)(result.totalAmount() - amount));
                    return completableFuture;
                }
                CompletableFuture completableFuture = MVCCAsyncStore.failWithCode(code, "Failed to increment(" + k + ", " + amount + ") to store " + this.name());
                return completableFuture;
            }
            finally {
                result.close();
            }
        });
    }
}

