/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.util.BitMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitMapTest
extends ZKTestCase {
    @Test
    public void testAddAndRemove() {
        BitMap bitMap = new BitMap();
        String v1 = "v1";
        Integer bit = bitMap.add((Object)v1);
        Assertions.assertEquals((int)1, (int)bitMap.size());
        Assertions.assertTrue((bit >= 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)v1, (Object)bitMap.get(bit.intValue()));
        Assertions.assertEquals((Integer)bit, (Integer)bitMap.getBit((Object)v1));
        Integer newBit = bitMap.add((Object)v1);
        Assertions.assertEquals((Integer)bit, (Integer)newBit);
        Assertions.assertEquals((int)1, (int)bitMap.size());
        String v2 = "v2";
        Integer v2Bit = bitMap.add((Object)v2);
        Assertions.assertEquals((int)2, (int)bitMap.size());
        Assertions.assertNotEquals((Integer)v2Bit, (Integer)bit);
        bitMap.remove((Object)v1);
        Assertions.assertEquals((int)1, (int)bitMap.size());
        Assertions.assertNull((Object)bitMap.get(bit.intValue()));
        Assertions.assertNull((Object)bitMap.getBit((Object)v1));
        bitMap.remove(v2Bit.intValue());
        Assertions.assertEquals((int)0, (int)bitMap.size());
        Assertions.assertNull((Object)bitMap.get(v2Bit.intValue()));
        Assertions.assertNull((Object)bitMap.getBit((Object)v2));
    }

    @Test
    public void testBitReuse() {
        BitMap bitMap = new BitMap();
        int v1Bit = bitMap.add((Object)"v1");
        int v2Bit = bitMap.add((Object)"v2");
        int v3Bit = bitMap.add((Object)"v3");
        bitMap.remove(v2Bit);
        int v4Bit = bitMap.add((Object)"v4");
        Assertions.assertEquals((int)v4Bit, (int)v2Bit);
    }
}

