/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.otel;

import io.opentelemetry.api.common.Attributes;
import java.util.StringJoiner;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.otel.OtelCounter;
import org.apache.bookkeeper.stats.otel.OtelMetricsProvider;
import org.apache.bookkeeper.stats.otel.OtelOpStatsLogger;
import org.apache.bookkeeper.stats.otel.ScopeContext;

public class OtelStatsLogger
implements StatsLogger {
    private final OtelMetricsProvider provider;
    private final String scope;
    private final Attributes attributes;

    OtelStatsLogger(OtelMetricsProvider provider, String scope, Attributes attributes) {
        this.provider = provider;
        this.scope = scope;
        this.attributes = attributes;
    }

    public OpStatsLogger getOpStatsLogger(String name) {
        return this.provider.opStats.computeIfAbsent(this.scopeContext(name), sc -> new OtelOpStatsLogger(this.provider.meter, (ScopeContext)sc));
    }

    public OpStatsLogger getThreadScopedOpStatsLogger(String name) {
        return this.getOpStatsLogger(name);
    }

    public Counter getCounter(String name) {
        return this.provider.counters.computeIfAbsent(this.scopeContext(name), sc -> new OtelCounter(this.provider.meter, (ScopeContext)sc));
    }

    public Counter getThreadScopedCounter(String name) {
        return this.getCounter(name);
    }

    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.provider.meter.gaugeBuilder(this.completeName(name)).buildWithCallback(observableDoubleMeasurement -> {
            double v = gauge.getSample().doubleValue();
            observableDoubleMeasurement.record(v, this.attributes);
        });
    }

    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    public StatsLogger scope(String name) {
        return new OtelStatsLogger(this.provider, this.completeName(name), this.attributes);
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }

    public StatsLogger scopeLabel(String labelName, String labelValue) {
        Attributes newAttributes = Attributes.builder().putAll(this.attributes).put(labelName, labelValue).build();
        return new OtelStatsLogger(this.provider, this.scope, newAttributes);
    }

    private ScopeContext scopeContext(String name) {
        return new ScopeContext(this.completeName(name), this.attributes);
    }

    private String completeName(String name) {
        String metricName = this.scope.isEmpty() ? name : new StringJoiner(".").add(this.scope).add(name).toString();
        return metricName;
    }
}

