/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentWatcherACLTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentWatcherACLTest.class);
    private static final List<ACL> ACL_NO_READ = Collections.singletonList(new ACL(30, ZooDefs.Ids.ANYONE_ID_UNSAFE));
    private BlockingQueue<WatchedEvent> events;
    private Watcher persistentWatcher;
    private static final Round roundNothingAsAIsWatchedButDeniedBIsNotWatched = new Round("Nothing as a is watched but denied. b is not watched", false, true, null, "/a", AddWatchMode.PERSISTENT, new Step[]{new Step(5, "/a"), new Step(1, "/a/b"), new Step(5, "/a/b"), new Step(2, "/a/b"), new Step(2, "/a")});
    private static final Round roundNothingAsBothAAndBDenied = new Round("Nothing as both a and b denied", false, false, null, "/a", AddWatchMode.PERSISTENT, new Step[]{new Step(5, "/a"), new Step(1, "/a/b"), new Step(2, "/a/b"), new Step(2, "/a")});
    private static final Round roundAChangesInclChildrenAreSeen = new Round("a changes, incl children, are seen", true, false, null, "/a", AddWatchMode.PERSISTENT, new Step[]{new Step(1, "/a", Watcher.Event.EventType.NodeCreated, "/a"), new Step(5, "/a", Watcher.Event.EventType.NodeDataChanged, "/a"), new Step(1, "/a/b", Watcher.Event.EventType.NodeChildrenChanged, "/a"), new Step(5, "/a/b"), new Step(2, "/a/b", Watcher.Event.EventType.NodeChildrenChanged, "/a"), new Step(2, "/a", Watcher.Event.EventType.NodeDeleted, "/a")});
    private static final Round roundNothingForAAsItSDeniedBChangesSeen = new Round("Nothing for a as it's denied, b changes allowed/seen", false, true, null, "/a", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(5, "/a"), new Step(1, "/a/b", Watcher.Event.EventType.NodeCreated, "/a/b"), new Step(5, "/a/b", Watcher.Event.EventType.NodeDataChanged, "/a/b"), new Step(2, "/a/b", Watcher.Event.EventType.NodeDeleted, "/a/b"), new Step(2, "/a")});
    private static final Round roundNothingBothDenied = new Round("Nothing - both denied", false, false, null, "/a", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(5, "/a"), new Step(1, "/a/b"), new Step(5, "/a/b"), new Step(2, "/a/b"), new Step(2, "/a")});
    private static final Round roundNothingAllDenied = new Round("Nothing - all denied", false, false, false, "/a", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(1, "/a/b"), new Step(5, "/a/b"), new Step(1, "/a/b/c"), new Step(5, "/a/b/c"), new Step(2, "/a/b/c"), new Step(2, "/a/b")});
    private static final Round roundADeniesSeeAllChangesForBAndCIncludingBChildren = new Round("a denies, see all changes for b and c, including b's children", false, true, true, "/a", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(1, "/a/b", Watcher.Event.EventType.NodeCreated, "/a/b"), new Step(5, "/a/b", Watcher.Event.EventType.NodeDataChanged, "/a/b"), new Step(1, "/a/b/c", Watcher.Event.EventType.NodeCreated, "/a/b/c"), new Step(5, "/a/b/c", Watcher.Event.EventType.NodeDataChanged, "/a/b/c"), new Step(2, "/a/b/c", Watcher.Event.EventType.NodeDeleted, "/a/b/c"), new Step(2, "/a/b", Watcher.Event.EventType.NodeDeleted, "/a/b")});
    private static final Round roundADeniesSeeAllBChangesAndBChildrenNothingForC = new Round("a denies, see all b changes and b's children, nothing for c", false, true, false, "/a", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(1, "/a/b", Watcher.Event.EventType.NodeCreated, "/a/b"), new Step(5, "/a/b", Watcher.Event.EventType.NodeDataChanged, "/a/b"), new Step(1, "/a/b/c"), new Step(5, "/a/b/c"), new Step(2, "/a/b/c"), new Step(2, "/a/b", Watcher.Event.EventType.NodeDeleted, "/a/b")});
    private static final Round roundNothingTheWatchIsOnC = new Round("Nothing - the watch is on c", false, true, false, "/a/b/c", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(1, "/a/b"), new Step(5, "/a/b"), new Step(1, "/a/b/c"), new Step(5, "/a/b/c"), new Step(2, "/a/b/c"), new Step(2, "/a/b")});
    private static final Round roundTheWatchIsOnlyOnCBAndCAllowed = new Round("The watch is only on c (b and c allowed)", false, true, true, "/a/b/c", AddWatchMode.PERSISTENT_RECURSIVE, new Step[]{new Step(1, "/a/b"), new Step(5, "/a/b"), new Step(1, "/a/b/c", Watcher.Event.EventType.NodeCreated, "/a/b/c"), new Step(5, "/a/b/c", Watcher.Event.EventType.NodeDataChanged, "/a/b/c"), new Step(2, "/a/b/c", Watcher.Event.EventType.NodeDeleted, "/a/b/c"), new Step(2, "/a/b")});
    private static final Round[] ROUNDS = new Round[]{roundNothingAsAIsWatchedButDeniedBIsNotWatched, roundNothingAsBothAAndBDenied, roundAChangesInclChildrenAreSeen, roundNothingForAAsItSDeniedBChangesSeen, roundNothingBothDenied, roundNothingAllDenied, roundADeniesSeeAllChangesForBAndCIncludingBChildren, roundADeniesSeeAllBChangesAndBChildrenNothingForC, roundNothingTheWatchIsOnC, roundTheWatchIsOnlyOnCBAndCAllowed};

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.events = new LinkedBlockingQueue<WatchedEvent>();
        this.persistentWatcher = event -> {
            this.events.add(event);
            LOG.info("Added event: {}; total: {}", (Object)event, (Object)this.events.size());
        };
    }

    private static List<ACL> selectAcl(Boolean allow) {
        if (allow == null) {
            return null;
        }
        if (!allow.booleanValue()) {
            return ACL_NO_READ;
        }
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    private void execRound(Round round) throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            boolean firstStepCreatesA;
            List<ACL> aclForA = PersistentWatcherACLTest.selectAcl(round.allowA);
            List<ACL> aclForB = PersistentWatcherACLTest.selectAcl(round.allowB);
            List<ACL> aclForC = PersistentWatcherACLTest.selectAcl(round.allowC);
            boolean bl = firstStepCreatesA = round.steps.length > 0 && round.steps[0].opCode == 1 && round.steps[0].target.equals("/a");
            if (!firstStepCreatesA) {
                zk.create("/a", new byte[0], aclForA, CreateMode.PERSISTENT);
            }
            zk.addWatch(round.watchTarget, this.persistentWatcher, round.watchMode);
            for (int i = 0; i < round.steps.length; ++i) {
                Step step = round.steps[i];
                switch (step.opCode) {
                    case 1: {
                        List<ACL> acl = step.target.endsWith("/c") ? aclForC : (step.target.endsWith("/b") ? aclForB : aclForA);
                        zk.create(step.target, new byte[0], acl, CreateMode.PERSISTENT);
                        break;
                    }
                    case 2: {
                        zk.delete(step.target, -1);
                        break;
                    }
                    case 5: {
                        zk.setData(step.target, new byte[0], -1);
                        break;
                    }
                    default: {
                        Assertions.fail((String)("Unexpected opCode " + step.opCode + " in step " + i));
                    }
                }
                WatchedEvent actualEvent = this.events.poll(500L, TimeUnit.MILLISECONDS);
                if (step.eventType == null) {
                    Assertions.assertNull((Object)actualEvent, (String)("Unexpected event " + actualEvent + " at step " + i));
                    continue;
                }
                String m = "In event " + actualEvent + " at step " + i;
                Assertions.assertNotNull((Object)actualEvent, (String)m);
                Assertions.assertEquals((Object)step.eventType, (Object)actualEvent.getType(), (String)m);
                Assertions.assertEquals((Object)step.eventPath, (Object)actualEvent.getPath(), (String)m);
            }
        }
    }

    @Test
    public void testNothingAsAIsWatchedButDeniedBIsNotWatched() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundNothingAsAIsWatchedButDeniedBIsNotWatched);
    }

    @Test
    public void testNothingAsBothAAndBDenied() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundNothingAsBothAAndBDenied);
    }

    @Test
    public void testAChangesInclChildrenAreSeen() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundAChangesInclChildrenAreSeen);
    }

    @Test
    public void testNothingForAAsItSDeniedBChangesSeen() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundNothingForAAsItSDeniedBChangesSeen);
    }

    @Test
    public void testNothingBothDenied() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundNothingBothDenied);
    }

    @Test
    public void testNothingAllDenied() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundNothingAllDenied);
    }

    @Test
    public void testADeniesSeeAllChangesForBAndCIncludingBChildren() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundADeniesSeeAllChangesForBAndCIncludingBChildren);
    }

    @Test
    public void testADeniesSeeAllBChangesAndBChildrenNothingForC() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundADeniesSeeAllBChangesAndBChildrenNothingForC);
    }

    @Test
    public void testNothingTheWatchIsOnC() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundNothingTheWatchIsOnC);
    }

    @Test
    public void testTheWatchIsOnlyOnCBAndCAllowed() throws IOException, InterruptedException, KeeperException {
        this.execRound(roundTheWatchIsOnlyOnCBAndCAllowed);
    }

    private static String allowString(String prefix, Boolean allow) {
        if (allow == null) {
            return "";
        }
        return prefix + (allow != false ? "allow" : "deny");
    }

    private static String watchModeString(AddWatchMode watchMode) {
        switch (watchMode) {
            case PERSISTENT: {
                return "PERSISTENT";
            }
            case PERSISTENT_RECURSIVE: {
                return "PRECURSIVE";
            }
        }
        return "?";
    }

    private static String actionString(int opCode) {
        switch (opCode) {
            case 1: {
                return "create";
            }
            case 2: {
                return "delete";
            }
            case 5: {
                return "modify";
            }
        }
        return "?";
    }

    private static String eventPathString(String eventPath) {
        if (eventPath == null) {
            return "?";
        }
        if (eventPath.length() <= 1) {
            return eventPath;
        }
        return eventPath.substring(eventPath.lastIndexOf(47) + 1);
    }

    private static void genCsv(StringBuilder sb) {
        sb.append("Initial State,").append("Action,").append("NodeCreated,").append("NodeDeleted,").append("NodeDataChanged,").append("NodeChildrenChanged,").append("Notes/summary\n");
        sb.append("Assume /a always exists\n\n");
        for (Round round : ROUNDS) {
            sb.append("\"ACL").append(PersistentWatcherACLTest.allowString(": a ", round.allowA)).append(PersistentWatcherACLTest.allowString(", b ", round.allowB)).append(PersistentWatcherACLTest.allowString(", c ", round.allowC)).append("\"").append(",,,,,,\"").append(round.summary).append("\"\n");
            for (int i = 0; i < round.steps.length; ++i) {
                Step step = round.steps[i];
                if (i == 0) {
                    sb.append("\"addWatch(").append(round.watchTarget).append(", ").append(PersistentWatcherACLTest.watchModeString(round.watchMode)).append(")\"");
                }
                sb.append(",").append(PersistentWatcherACLTest.actionString(step.opCode)).append(" ").append(step.target).append(",");
                if (step.eventType == Watcher.Event.EventType.NodeCreated) {
                    sb.append("y - ").append(PersistentWatcherACLTest.eventPathString(step.eventPath));
                }
                sb.append(",");
                if (step.eventType == Watcher.Event.EventType.NodeDeleted) {
                    sb.append("y - ").append(PersistentWatcherACLTest.eventPathString(step.eventPath));
                }
                sb.append(",");
                if (step.eventType == Watcher.Event.EventType.NodeDataChanged) {
                    sb.append("y - ").append(PersistentWatcherACLTest.eventPathString(step.eventPath));
                }
                sb.append(",");
                if (round.watchMode == AddWatchMode.PERSISTENT_RECURSIVE) {
                    sb.append("n");
                } else if (step.eventType == Watcher.Event.EventType.NodeChildrenChanged) {
                    sb.append("y - ").append(PersistentWatcherACLTest.eventPathString(step.eventPath));
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        PersistentWatcherACLTest.genCsv(sb);
        System.out.println(sb);
    }

    private static class Round {
        final String summary;
        final Boolean allowA;
        final Boolean allowB;
        final Boolean allowC;
        final String watchTarget;
        final AddWatchMode watchMode;
        final Step[] steps;

        Round(String summary, Boolean allowA, Boolean allowB, Boolean allowC, String watchTarget, AddWatchMode watchMode, Step[] steps) {
            this.summary = summary;
            this.allowA = allowA;
            this.allowB = allowB;
            this.allowC = allowC;
            this.watchTarget = watchTarget;
            this.watchMode = watchMode;
            this.steps = steps;
        }
    }

    private static class Step {
        final int opCode;
        final String target;
        final Watcher.Event.EventType eventType;
        final String eventPath;

        Step(int opCode, String target) {
            this(opCode, target, null, null);
        }

        Step(int opCode, String target, Watcher.Event.EventType eventType, String eventPath) {
            this.opCode = opCode;
            this.target = target;
            this.eventType = eventType;
            this.eventPath = eventPath;
        }
    }
}

